/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog.lookup;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.Db2Database;
import com.ibm.etools.fm.core.model.db2.Db2DatabaseQuery;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.ui.dialog.lookup.Db2LookupDialog;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.dialog.lookup.PatternState;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelDecorator;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelProvider;
import com.ibm.pdtools.common.component.ui.views.systems.model.ContentLoader;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;

public class Db2DatabaseLookupDialog
extends Db2LookupDialog<Db2Database> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int NAME_INDEX = 0;
    private static final int CREATOR_INDEX = 1;
    private static final String[] databaseLookupColumnNames = new String[]{Messages.Db2DatabaseLookupDialog_Name, Messages.Db2DatabaseLookupDialog_Creator};
    private static final String[] databaseLabelList = new String[]{Messages.Db2DatabaseLookupDialog_Name_, Messages.Db2DatabaseLookupDialog_Creator_};

    protected String getColumnText(Object element, int columnIndex) {
        return Db2DatabaseLookupDialog.getTableProperty(element, columnIndex);
    }

    private static String getTableProperty(Object element, int columnIndex) {
        if (element instanceof Db2Database) {
            Db2Database database = (Db2Database)element;
            switch (columnIndex) {
                case 0: {
                    return database.getName();
                }
                case 1: {
                    return database.getCreator();
                }
            }
            logger.debug((Object)MessageFormat.format("Unable to get column text for column {0} for item ''{1}''", columnIndex, element));
            return "";
        }
        return "";
    }

    public DecoratingLabelProvider getLabelProvider() {
        return new Db2DatabaseDecoratingLabelProvider((ILabelProvider)new SystemsLabelProvider(), (ILabelDecorator)new SystemsLabelDecorator());
    }

    public Db2DatabaseLookupDialog(Db2Subsystem subsystem) {
        super(subsystem, databaseLabelList, databaseLookupColumnNames, new String[databaseLabelList.length], Db2Database.class);
        ContentLoader.ICallableWithProgress itemProvider = new ContentLoader.ICallableWithProgress<List<?>>(){

            public List<?> call(IHowIsGoing monitor) throws InterruptedException, CommunicationException {
                Db2DatabaseQuery query = new Db2DatabaseQuery(Db2DatabaseLookupDialog.this.getDb2Subsystem(), Db2Database.class);
                query.setNamePattern(Db2DatabaseLookupDialog.this.contentProvider.getNewInput().getPatternList()[0]);
                query.setOwnerPattern(Db2DatabaseLookupDialog.this.contentProvider.getNewInput().getPatternList()[1]);
                Result result = query.loadObjects(monitor);
                if (result.isSuccessfulWithoutWarnings()) {
                    return query.getObjects();
                }
                throw new CommunicationException(MessageFormat.format(com.ibm.pdtools.common.component.core.Messages.__LOAD_FAILED_DUE_TO_X, result.getMessagesCombined().toString()));
            }
        };
        this.setItemProvider(itemProvider);
        this.setTooltipList(new String[]{Messages.Db2DatabaseLookupDialog_nameTooltip, Messages.Db2DatabaseLookupDialog_CreatorTooltip});
    }

    public void setInitialOwnerPattern(String ownerPattern) {
        this.initialPatternList[1] = ownerPattern;
    }

    public void setInitialNamePattern(String namePattern) {
        this.initialPatternList[0] = namePattern;
    }

    @Override
    protected ViewerFilter[] getFilters() {
        return new ViewerFilter[]{new DatabaseViewerFilter()};
    }

    protected String getDialogName() {
        return MessageFormat.format(Messages.Db2DatabaseLookupDialog_LookupForXObjectrs, Messages.Db2Database_DB2Database);
    }

    private static class DatabaseViewerFilter
    extends ViewerFilter {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private DatabaseViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof Db2Database && parentElement instanceof PatternState) {
                Db2Database database = (Db2Database)element;
                PatternState input = (PatternState)parentElement;
                return Db2DatabaseLookupDialog.matchEscapedRegex((String)input.getPatternList()[1], (String)database.getCreator()) && Db2DatabaseLookupDialog.matchEscapedRegex((String)input.getPatternList()[0], (String)database.getName());
            }
            return true;
        }
    }

    protected static class Db2DatabaseDecoratingLabelProvider
    extends DecoratingLabelProvider
    implements ITableLabelProvider {
        public Db2DatabaseDecoratingLabelProvider(ILabelProvider provider, ILabelDecorator decorator) {
            super(provider, decorator);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof Db2Database) {
                return this.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof String)) {
                return Db2DatabaseLookupDialog.getTableProperty(element, columnIndex);
            }
            if (columnIndex == 0) {
                return (String)element;
            }
            return null;
        }
    }
}

