/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog.lookup;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetQuery;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetModel;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetWizard;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.util.EncodingUtils;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import com.ibm.pdtools.common.component.ui.dialog.lookup.LookupContentProvider;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.jface.wizard.IWizard;

public class DataSetContentProvider
extends LookupContentProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final Pattern validPattern = Pattern.compile("\\A[a-zA-Z#@\\$*%]?[a-zA-Z0-9#@\\$\\-*%]{0,7}(\\.[a-zA-Z#@\\$*%]?[a-zA-Z0-9#@\\$\\-*%]{0,7}){0,21}\\Z");
    DataSetQuery lastQuery = null;
    DataSetQuery currentQuery = null;
    Pattern matchPattern = null;

    public static boolean validFor(Object input) {
        return DataSetContentProvider.validFor(input, HostType.ZOS.getCommunicationEncoding());
    }

    public static boolean validFor(Object input, String codepage) {
        if (input instanceof String) {
            String strInput = EncodingUtils.codepageConverter((String)((String)input), (String)codepage, (String)HostType.ZOS.getCommunicationEncoding());
            return validPattern.matcher(strInput).matches();
        }
        return false;
    }

    public static String stripLastQualifier(String strInput) {
        Objects.requireNonNull(strInput, "Must specify a non-null strInput.");
        int cutOff = strInput.lastIndexOf(".");
        if (cutOff == strInput.length() - 1) {
            cutOff = strInput.lastIndexOf(".", cutOff - 1);
        }
        if (cutOff >= 0) {
            return strInput.substring(0, cutOff + 1);
        }
        if (!strInput.isEmpty()) {
            return "";
        }
        return null;
    }

    public DataSetContentProvider(IPDHost systemProvider) {
        super(systemProvider);
    }

    public void onInputChange(Object newInput) {
        if (!DataSetContentProvider.validFor(newInput, this.getSystem().getCodePage())) {
            throw new IllegalArgumentException(newInput == null ? "null" : newInput.toString());
        }
        this.currentQuery = null;
        if (newInput instanceof String) {
            String input = (String)newInput;
            int lastSep = input.lastIndexOf(".");
            if (lastSep <= 0) {
                this.currentQuery = DataSetQuery.create((IPDHost)this.getSystem(), (String)"*");
            } else {
                Object queryText = input;
                if (!((String)queryText).substring(((String)queryText).length() - 1).equals("*")) {
                    queryText = input.substring(0, lastSep + 1) + "*";
                }
                String cleanedQuery = ((String)queryText).replaceAll("\\*\\*\\*", "**");
                while (((String)queryText).length() > cleanedQuery.length()) {
                    queryText = cleanedQuery;
                    cleanedQuery = cleanedQuery.replaceAll("\\*\\*\\*", "**");
                }
                if (DataSetQuery.isValidQuery((String)queryText, (String)this.getSystem().getCodePage())) {
                    this.currentQuery = DataSetQuery.create((IPDHost)this.getSystem(), (String)queryText);
                    this.currentQuery.setFetchingProperties(false);
                }
            }
        }
        if (this.currentQuery == null) {
            throw new IllegalArgumentException(newInput == null ? "null" : newInput.toString());
        }
    }

    public Object getUpLevelInput() {
        if (this.getInput() == null) {
            return null;
        }
        String strInput = (String)this.getInput();
        if (strInput.isEmpty()) {
            return null;
        }
        return DataSetContentProvider.stripLastQualifier(strInput);
    }

    public void updateMatcher(String filter) {
        Object oldQuery = filter;
        int memberStartPos = ((String)oldQuery).indexOf("(");
        if (memberStartPos >= 0) {
            oldQuery = ((String)oldQuery).substring(0, memberStartPos);
        }
        oldQuery = (String)oldQuery + "**";
        String newQuery = ((String)oldQuery).replaceAll("\\*\\*\\*", "**");
        while (((String)oldQuery).length() > newQuery.length()) {
            oldQuery = newQuery;
            newQuery = newQuery.replaceAll("\\*\\*\\*", "**");
        }
        this.matchPattern = DataSetQuery.convertToRegexp((String)newQuery);
    }

    public boolean canUseLastViewerData() {
        return this.currentQuery != null && this.currentQuery.equals((Object)this.lastQuery);
    }

    public List<? extends IZRL> reloadData(IHowIsGoing monitor) throws InterruptedException {
        if (this.currentQuery == null) {
            return null;
        }
        this.currentQuery.loadDataSets(monitor);
        this.lastQuery = this.currentQuery;
        return this.currentQuery.getDataSets();
    }

    public boolean matches(IZRL resource) {
        if (resource == null) {
            return false;
        }
        if (resource instanceof DataSet) {
            if (this.matchPattern == null) {
                throw new IllegalStateException();
            }
            return this.matchPattern.matcher(resource.getFormattedName()).matches();
        }
        return false;
    }

    public String getJobName() {
        if (this.currentQuery == null) {
            return Messages.Invalid_INPUT;
        }
        return MessageFormat.format(Messages.DataSetContentProvider_LOADING_DATA_SETS_FOR_X, this.currentQuery.getQuery());
    }

    public boolean isValidFor(Object input) {
        return DataSetContentProvider.validFor(input);
    }

    public String getResultStatusInfo() {
        if (this.currentQuery == null) {
            return Messages.Invalid_INPUT;
        }
        return MessageFormat.format(Messages.DataSetContentProvider_SHOWING_DATA_SETS_FOR_X, this.currentQuery.getQuery());
    }

    public Class<?> getType() {
        return DataSet.class;
    }

    public boolean canCreateNewResource() {
        return true;
    }

    public boolean createNewResource(IPDHost host, List<IZRL> selection, String filter) {
        AllocateDataSetWizard allocateWizard;
        int openResult;
        AllocateDataSetModel allocateParams = new AllocateDataSetModel();
        allocateParams.setHost(host);
        int memStartPos = ((String)filter).indexOf("(");
        if (memStartPos >= 0) {
            filter = ((String)filter).substring(0, memStartPos);
        }
        if (((String)filter).length() > 0 && ((String)filter).charAt(((String)filter).length() - 1) == '.') {
            filter = (String)filter + "NEW";
        }
        if (!((String)filter).startsWith("MQ:") && !((String)filter).startsWith("/")) {
            allocateParams.setDataSetName((String)filter);
        }
        if (selection.size() >= 1 && selection.get(0) instanceof DataSet) {
            DataSet allocateLike = (DataSet)selection.get(0);
            allocateLike = DataSet.create((IPDHost)host, (String)allocateLike.getName());
            allocateParams.setAllocateLike(allocateLike.clone());
        }
        return (openResult = PDScrollableWizardDialog.openWizard((IWizard)(allocateWizard = AllocateDataSetWizard.create(allocateParams)))) == 0 && allocateWizard.getRunnable().isCompletedSuccessfully();
    }
}

