/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog.lookup;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.cics.CicsAppl;
import com.ibm.etools.fm.core.model.cics.CicsTemporaryStorage;
import com.ibm.etools.fm.core.model.cics.CicsTemporaryStorageQuery;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import com.ibm.pdtools.common.component.ui.dialog.lookup.LookupContentProvider;
import java.text.MessageFormat;
import java.util.List;
import java.util.regex.Pattern;

public class CicsTSContentProvider
extends LookupContentProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final Pattern validPattern = Pattern.compile("\\ATS:[A-Z0-9#$@]{1,8}:.*\\Z", 2);
    private Pattern matchPattern;
    private CicsAppl currentAppl;
    private CicsAppl lastAppl;

    public static boolean validFor(Object input) {
        if (input instanceof String) {
            String strInput = (String)input;
            return validPattern.matcher(strInput).matches();
        }
        return input instanceof CicsAppl;
    }

    public CicsTSContentProvider(IPDHost systemProvider) {
        super(systemProvider);
    }

    public void onInputChange(Object newInput) {
        this.codepageTranslator(newInput);
        if (!CicsTSContentProvider.validFor(newInput)) {
            throw new IllegalArgumentException(newInput == null ? "null" : newInput.toString());
        }
        this.currentAppl = null;
        if (newInput instanceof String) {
            String input = (String)newInput;
            int applIdSepPos = input.lastIndexOf(":");
            String applId = input.substring("FI:".length(), applIdSepPos);
            if (CicsAppl.isValidName((String)applId, (String)this.getSystem().getCodePage())) {
                this.currentAppl = CicsAppl.create((IPDHost)this.getSystem(), (String)applId);
            }
        } else if (newInput instanceof CicsAppl) {
            this.currentAppl = (CicsAppl)newInput;
        }
        if (this.currentAppl == null) {
            throw new IllegalArgumentException(newInput == null ? "null" : newInput.toString());
        }
    }

    public Object getUpLevelInput() {
        return "TS:";
    }

    public void updateMatcher(String filter) {
        filter = (String)filter + "*";
        filter = StringUtils.escapeRegex((String)filter);
        filter = ((String)filter).replaceAll("\\\\\\*", ".*");
        filter = ((String)filter).replaceAll("%", ".");
        this.matchPattern = Pattern.compile((String)filter, 66);
    }

    public boolean canUseLastViewerData() {
        return this.currentAppl != null && this.currentAppl.equals((Object)this.lastAppl);
    }

    public List<? extends IZRL> reloadData(IHowIsGoing monitor) throws InterruptedException {
        if (this.currentAppl == null) {
            return null;
        }
        CicsTemporaryStorageQuery query = CicsTemporaryStorageQuery.create((CicsAppl)this.currentAppl, (String)"*");
        query.loadCICSResources(monitor);
        this.lastAppl = this.currentAppl;
        return query.getCICSResources();
    }

    public boolean matches(IZRL resource) {
        if (resource == null) {
            return false;
        }
        if (resource instanceof CicsTemporaryStorage) {
            if (this.matchPattern == null) {
                throw new IllegalStateException();
            }
            return this.matchPattern.matcher(resource.getFormattedName()).matches();
        }
        return false;
    }

    public String getJobName() {
        if (this.currentAppl == null) {
            return Messages.Invalid_INPUT;
        }
        return MessageFormat.format(Messages.CICSTSContentProvider_LOADING_CICS_TS_X, this.currentAppl.getName());
    }

    public String getResultStatusInfo() {
        if (this.currentAppl == null) {
            return Messages.Invalid_INPUT;
        }
        return MessageFormat.format(Messages.CICSTSContentProvider_SHOWING_CICS_TS_X, this.currentAppl.getName());
    }

    public boolean isValidFor(Object input) {
        return CicsTSContentProvider.validFor(input);
    }

    public Class<?> getType() {
        return CicsTemporaryStorage.class;
    }
}

