/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog.lookup;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.cics.CicsAppl;
import com.ibm.etools.fm.core.model.cics.CicsApplIDQuery;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import com.ibm.pdtools.common.component.ui.dialog.lookup.LookupContentProvider;
import java.util.List;
import java.util.regex.Pattern;

public class CicsApplIdContentProvider
extends LookupContentProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final Pattern validPattern = Pattern.compile("\\A(FI:|TD:|TS:)[^:]*\\Z", 2);
    private String input;
    private Pattern matchPattern;
    private String inputPrefix;

    public static boolean validFor(Object input) {
        if (input instanceof String) {
            String strInput = (String)input;
            return validPattern.matcher(strInput).matches();
        }
        return false;
    }

    public static String getPrefix(String applIdResource) throws IllegalArgumentException {
        if (applIdResource == null) {
            throw new IllegalArgumentException();
        }
        String upperInput = applIdResource.toUpperCase();
        if (upperInput.startsWith("FI:")) {
            return "FI:";
        }
        if (upperInput.startsWith("TD:")) {
            return "TD:";
        }
        if (upperInput.startsWith("TS:")) {
            return "TS:";
        }
        return null;
    }

    public CicsApplIdContentProvider(IPDHost systemProvider) {
        super(systemProvider);
    }

    public void onInputChange(Object newInput) {
        this.codepageTranslator(newInput);
        if (!CicsApplIdContentProvider.validFor(newInput)) {
            throw new IllegalArgumentException(newInput == null ? "null" : newInput.toString());
        }
        if (!(newInput instanceof String)) {
            throw new IllegalArgumentException(newInput == null ? "null" : newInput.toString());
        }
        this.input = (String)newInput;
    }

    public Object getUpLevelInput() {
        if (this.input == null) {
            throw new IllegalStateException();
        }
        String prefix = CicsApplIdContentProvider.getPrefix(this.input);
        if (this.input.toUpperCase().equals(prefix)) {
            return null;
        }
        return prefix;
    }

    public void updateMatcher(String filter) {
        this.inputPrefix = CicsApplIdContentProvider.getPrefix((String)filter);
        filter = (String)filter + "*";
        filter = StringUtils.escapeRegex((String)filter);
        filter = ((String)filter).replaceAll("\\\\\\*", ".*");
        filter = ((String)filter).replaceAll("%", ".");
        this.matchPattern = Pattern.compile((String)filter, 66);
    }

    public boolean canUseLastViewerData() {
        return true;
    }

    public List<? extends IZRL> reloadData(IHowIsGoing monitor) throws InterruptedException {
        if (this.input == null) {
            throw new IllegalStateException();
        }
        CicsApplIDQuery query = CicsApplIDQuery.create((IPDHost)this.getSystem(), (String)"*");
        query.loadCICSApps(monitor);
        return query.getCICSApps();
    }

    public boolean matches(IZRL resource) {
        if (resource == null) {
            return false;
        }
        if (resource instanceof CicsAppl) {
            if (this.inputPrefix == null) {
                throw new IllegalStateException();
            }
            return this.matchPattern.matcher(this.inputPrefix + resource.getName()).matches();
        }
        return false;
    }

    public String getJobName() {
        return Messages.CICSApplIdContentProvider_LOADING_CICS_APPS;
    }

    public String getResultStatusInfo() {
        if (this.input == null) {
            return Messages.Invalid_INPUT;
        }
        return Messages.CICSApplIdContentProvider_SHOWING_CICS_APPS;
    }

    public boolean isValidFor(Object input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException();
        }
        return CicsApplIdContentProvider.validFor(input);
    }

    public Class<?> getType() {
        return CicsAppl.class;
    }
}

