/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.MessageQueue;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.core.model.cics.CicsFile;
import com.ibm.etools.fm.core.model.cics.CicsTemporaryStorage;
import com.ibm.etools.fm.core.model.cics.CicsTransientData;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.callback.IOnSelectionEvent;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ZRLSaveAsDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String ZRL_COMBO = "com.ibm.etools.fm.pages.ZRLSaveAsDialog.ZRLname";
    private static final Class<?>[] SAVE_AS_RESOURCE_TYPES = new Class[]{DataSet.class, Member.class, MessageQueue.class, UssFile.class, CicsTransientData.class, CicsTemporaryStorage.class};
    private Combo resourceCombo;
    private IZRL selectedResource;
    private final IPDHost system;

    public ZRLSaveAsDialog(IPDHost system, IZRL initialSelection) {
        this.system = system;
        this.selectedResource = initialSelection;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.ZRLSaveAsDialog_TITLE);
        this.setMessage(Messages.ZRLSaveAsDialog_MSG);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillAll());
        GUI.label.left((Composite)composite, (String)Messages.ZRLSaveAsDialog_TARGET_COMBO, (Object)GUI.grid.d.left1());
        this.resourceCombo = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1(composite), this.resourceCombo, (IHostProvider)this.system).types(SAVE_AS_RESOURCE_TYPES).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                ZRLSaveAsDialog.this.selectedResource = zrl;
            }
        }).addResourceContentProposals(ZRL_COMBO).create();
        this.resourceCombo.setText(this.selectedResource != null ? this.selectedResource.getFormattedName() : "");
        this.resourceCombo.setFocus();
        this.resourceCombo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                ZRLSaveAsDialog.this.validateResourceName();
            }
        });
        this.setComplete(this.validateResourceName());
        return composite;
    }

    public boolean close() {
        if (this.getReturnCode() == 0) {
            if (!this.validateResourceName()) {
                return false;
            }
            FMUIPlugin.getDefault().renewDialogValue(ZRL_COMBO, this.selectedResource.getFormattedName());
        }
        return super.close();
    }

    private boolean validateResourceName() {
        String value = this.resourceCombo.getText();
        if (value.trim().isEmpty()) {
            this.selectedResource = null;
            this.setComplete(false);
            this.setErrorMessage(null);
            return false;
        }
        boolean parsedValidZrl = false;
        if (ZRLs.isParseable((IPDHost)this.system, (String)value)) {
            this.selectedResource = ZRLs.parseZRL((IPDHost)this.system, (String)value);
            parsedValidZrl = true;
            this.setComplete(true);
            this.setErrorMessage(null);
        }
        if (this.selectedResource instanceof UssFile && ((UssFile)this.selectedResource).isDirectory()) {
            this.selectedResource = null;
            parsedValidZrl = false;
        }
        if (this.selectedResource instanceof CicsFile) {
            this.selectedResource = null;
            parsedValidZrl = false;
        }
        this.setComplete(parsedValidZrl);
        this.setErrorMessage(parsedValidZrl ? null : Messages.ZRLSaveAsDialog_INVALID_TARGET);
        return parsedValidZrl;
    }

    public IZRL getSelectedResource() {
        return this.selectedResource;
    }
}

