/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.UssFileQuery;
import com.ibm.etools.fm.core.model.UssFileType;
import com.ibm.etools.fm.ui.widget.TypeComposite;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class UssFileQueryDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private IPDHost host;
    private UssFileQuery query;
    private String initialQuery;
    private Combo wQuery;
    private TypeComposite<UssFileType> wTypes;
    private boolean editing;

    public UssFileQueryDialog(IPDHost system, boolean editing) {
        this.host = Objects.requireNonNull(system, "Must provide a non-null system");
        this.editing = editing;
    }

    public void setQuery(UssFileQuery query) {
        this.query = Objects.requireNonNull(query, "Must provide a non-null query");
        this.host = query.getSystem();
    }

    public UssFileQuery getQuery() {
        return this.query;
    }

    public void setInitialQuery(String initialQuery) {
        this.initialQuery = initialQuery;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.editing ? Messages.UssFileQueryDialog_EDIT_USS_QUERY : Messages.UssFileQueryDialog_ADD_USS_QUERY);
        this.setMessage(Messages.UssFileQueryDialog_ENTER_USS_QUERY_MSG);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillAll());
        GUI.label.left((Composite)composite, (String)Messages.Label__QUERY, (Object)GUI.grid.d.left1());
        this.wQuery = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wQuery, ((Object)((Object)this)).getClass().getCanonicalName() + "Query");
        GUI.grid.padding((Composite)composite, (int)1);
        Group filterGroup = GUI.group((Composite)composite, (String)Messages.TYPE_FILTERING_OPTIONS, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)2));
        this.wTypes = new TypeComposite<UssFileType>((Composite)filterGroup, 3, (Object)GUI.grid.d.fillAll(), UssFileType.STANDARD_VALUES){

            @Override
            protected String getLabelFor(UssFileType item) {
                return item.getName();
            }
        };
        this.wTypes.setAllCheckboxLabel(Messages.UssFileQueryDialog_ALL_FILE_TYPES);
        this.setInitialValues();
        this.wQuery.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                UssFileQueryDialog.this.setComplete(true);
            }
        });
        this.wTypes.addSelectionListener(new Listener(){

            public void handleEvent(Event event) {
                UssFileQueryDialog.this.setComplete(true);
            }
        });
        this.wQuery.setFocus();
        this.setComplete(true);
        return composite;
    }

    private void setInitialValues() {
        List standardValues = UssFileType.STANDARD_VALUES;
        if (this.query != null) {
            this.wQuery.setText(this.query.getQuery());
            List actualTypesFiltered = this.query.getTypesFiltered();
            this.wTypes.setSelectedTypes(actualTypesFiltered.isEmpty() ? standardValues : actualTypesFiltered);
        } else {
            this.wTypes.setSelectedTypes(standardValues);
        }
        if (this.initialQuery != null) {
            this.wQuery.setText(this.initialQuery);
        }
    }

    protected void setComplete(boolean complete) {
        String queryText = this.wQuery.getText();
        List<UssFileType> selectedTypes = this.wTypes.getSelected();
        if (complete && !UssFileQuery.isValidQuery((IPDHost)this.host, (String)queryText)) {
            complete = false;
            this.setErrorMessage(Messages.UssFileQueryDialog_INVALID_QUERY);
        } else if (complete && selectedTypes.isEmpty()) {
            complete = false;
            this.setErrorMessage(Messages.UssFileQueryDialog_SPECIFY_MIN_ONE_TYPE);
        } else if (complete) {
            this.query = UssFileQuery.create((IPDHost)this.host, (String)queryText);
            if (selectedTypes.size() == UssFileType.STANDARD_VALUES.size()) {
                this.query.setTypesFiltered(new ArrayList());
            } else {
                this.query.setTypesFiltered(selectedTypes);
            }
            this.setErrorMessage(null);
        }
        super.setComplete(complete);
    }
}

