/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.MemberPresence;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.callback.IOnSelectionEvent;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.widget.ResourceContentProposals;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class TemplateResourceSaveAsDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private boolean cancelButtonPressed = false;
    private static final String DSN_COMBO = "com.ibm.etools.fm.pages.DataSetSelectionDialog.DSN";
    private Combo resourceCombo;
    private IZRL selectedResource;
    private final IPDHost system;
    private final MemberPresence memberRequirement;

    public TemplateResourceSaveAsDialog(IPDHost system, IZRL initialSelection, MemberPresence memberRequirement) {
        this.system = system;
        this.selectedResource = initialSelection;
        this.memberRequirement = memberRequirement;
    }

    protected Control createDialogArea(Composite parent) {
        String title = Messages.TemplateResourceSaveAsDialog_TITLE_SAVE_AS;
        this.getShell().setText(title);
        this.setTitle(title);
        this.setMessage(Messages.TemplateResourceSaveAsDialog_MESSAGE_SPECIFY_NAME_FOR_SAVE_AS);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillAll());
        GUI.label.left((Composite)composite, (String)Messages.TemplateResourceSaveAsDialog_LABEL_RESOURCE_NAME, (Object)GUI.grid.d.left1());
        this.resourceCombo = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        ResourceContentProposals rcp = ResourceContentProposals.addTo(this.resourceCombo, (IHostProvider)this.system, DSN_COMBO, FMHost.getPermittedTemplateResourceType((IPDHost)this.system));
        if (this.memberRequirement == MemberPresence.None) {
            rcp.setAllowedResourceTypes(new Class[]{DataSet.class});
        }
        this.resourceCombo.setText(this.selectedResource != null ? this.selectedResource.getFormattedName() : "");
        this.resourceCombo.setFocus();
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1(composite), this.resourceCombo, (IHostProvider)this.system).types(this.memberRequirement.getAllowedClasses()).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                TemplateResourceSaveAsDialog.this.selectedResource = zrl;
            }
        }).create();
        return composite;
    }

    protected void cancelPressed() {
        this.cancelButtonPressed = true;
        super.cancelPressed();
    }

    public boolean close() {
        if (this.cancelButtonPressed) {
            return super.close();
        }
        if (!this.validateResourceName()) {
            return false;
        }
        FMUIPlugin.getDefault().renewDialogValue(DSN_COMBO, this.selectedResource.getFormattedName());
        return super.close();
    }

    private boolean validateResourceName() {
        String value = this.resourceCombo.getText().trim();
        if (value.isEmpty() || !ZRLs.isParseable((IPDHost)this.system, (String)value)) {
            this.setMessage(Messages.TemplateResourceSaveAsDialog_ERROR_INVALID_RESOURCE_NAME, 3);
            this.selectedResource = null;
            return false;
        }
        this.selectedResource = ZRLs.parseZRL((IPDHost)this.system, (String)value);
        this.setErrorMessage(null);
        return true;
    }

    public IZRL getSelectedResource() {
        return this.selectedResource;
    }
}

