/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.util.ZrlLoaderDialogUtils;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.text.MessageFormat;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class NewMemberDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private IPDHost host;
    private Combo dsnCombo;
    private Combo memberCombo;
    private String dataSetName;
    private String newMemberName;
    private Member selectedNewMember;
    private final DataSetOrMember initialDsom;

    public NewMemberDialog(IPDHost host, DataSetOrMember initialDsom) {
        this.host = host;
        this.initialDsom = initialDsom;
    }

    protected Composite createDialogContent(Composite parent) {
        this.setTitle(Messages.NewMemberDialog_0);
        this.setMessage(Messages.NewMemberDialog_1);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillAll());
        GUI.label.left((Composite)composite, (String)Messages.NewMemberDialog_2, (Object)GUI.grid.d.left1());
        this.dsnCombo = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        LookupDialogFactory.defaults(LookupButton.createLookupResourceButtonLeft1(composite), this.dsnCombo, (IHostProvider)this.host).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "dsnCombo").create();
        if (this.initialDsom != null) {
            this.dsnCombo.setText(this.initialDsom.asDataSet().getFormattedName());
        }
        GUI.label.left((Composite)composite, (String)Messages.NewMemberDialog_3, (Object)GUI.grid.d.left1());
        this.memberCombo = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)2));
        new ComboValueSaver(this.memberCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "memberCombo");
        if (this.initialDsom != null && this.initialDsom.asMember() != null) {
            this.memberCombo.setText(this.initialDsom.asMember().getName());
        }
        if (!this.dsnCombo.getText().isEmpty()) {
            this.memberCombo.setFocus();
        } else {
            this.dsnCombo.setFocus();
        }
        this.memberCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (NewMemberDialog.this.memberCombo.getText().trim().isEmpty()) {
                    NewMemberDialog.this.setComplete(false);
                } else {
                    NewMemberDialog.this.setComplete(true);
                }
            }
        });
        this.setComplete(false);
        return composite;
    }

    public boolean close() {
        if (this.getReturnCode() == 1) {
            return super.close();
        }
        if (!this.validateInputDSN()) {
            return false;
        }
        if (!this.validateMemberName()) {
            return false;
        }
        if (!this.checkResourceStatus()) {
            return false;
        }
        return super.close();
    }

    private boolean validateMemberName() {
        String newMemName = this.memberCombo.getText().trim();
        String newFullName = this.dataSetName + "(" + newMemName + ")";
        if (!Member.isParseable((String)newFullName, (boolean)true, (String)this.host.getCodePage())) {
            this.setErrorMessage(Messages.NewMemberDialog_4);
            this.memberCombo.setFocus();
            return false;
        }
        this.newMemberName = newMemName;
        return true;
    }

    private boolean validateInputDSN() {
        String aDSN = this.dsnCombo.getText().trim().toUpperCase();
        if (!DataSet.isValidName((String)aDSN, (String)this.host.getCodePage())) {
            this.setErrorMessage(Messages.NewMemberDialog_5);
            this.dsnCombo.setFocus();
            return false;
        }
        this.dataSetName = aDSN;
        return true;
    }

    private boolean checkResourceStatus() {
        DataSet selectedDSN;
        block7: {
            block8: {
                Member selectedMember;
                block10: {
                    block11: {
                        block9: {
                            this.selectedNewMember = null;
                            selectedDSN = DataSet.create((IPDHost)this.host, (String)this.dataSetName);
                            selectedMember = Member.create((DataSet)selectedDSN, (String)this.newMemberName);
                            try {
                                Result<StringBuffer> result = ZrlLoaderDialogUtils.refreshDataSetProperties((DataSetOrMember)selectedDSN);
                                if (!result.isSuccessfulWithoutWarnings()) break block7;
                                if (!selectedDSN.getConfirmedExists()) break block8;
                                if (selectedDSN.getType() == DataSetType.LIBRARY || selectedDSN.getType() == DataSetType.PDS) break block9;
                                this.setErrorMessage(Messages.NewMemberDialog_9);
                                this.dsnCombo.setFocus();
                                return false;
                            }
                            catch (InterruptedException ie) {
                                return false;
                            }
                        }
                        if (!selectedDSN.getMembers().contains(selectedMember)) break block10;
                        if (PDDialogs.openQuestionThreadSafe((String)MessageFormat.format(Messages.NewMemberDialog_6, selectedMember.getFormattedName()))) break block11;
                        this.setErrorMessage(null);
                        this.memberCombo.setFocus();
                        return false;
                    }
                    this.selectedNewMember = selectedMember.asMember();
                    return true;
                }
                this.selectedNewMember = selectedMember.asMember();
                return true;
            }
            this.setErrorMessage(MessageFormat.format(Messages.NewMemberDialog_7, selectedDSN.getFormattedName()));
            this.dsnCombo.setFocus();
            return false;
        }
        this.setErrorMessage(MessageFormat.format(Messages.NewMemberDialog_8, selectedDSN.getFormattedName()));
        this.dsnCombo.setFocus();
        return false;
    }

    public Member getNewMember() {
        return this.selectedNewMember;
    }
}

