/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.MessageQueue;
import com.ibm.etools.fm.core.model.MessageQueueManager;
import com.ibm.etools.fm.core.model.MessageQueueQuery;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.callback.IOnSelectionEvent;
import com.ibm.etools.fm.ui.dialog.lookup.callback.ISelectedValueFormatter;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.dialog.lookup.filter.ILookupFilterProvider;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import java.lang.reflect.Field;
import java.util.Objects;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class MessageQueueQueryDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private IPDHost host;
    private MessageQueueQuery mqQuery;
    private String initialQuery;
    private Combo wMQM;
    private Combo wQuery;
    private final boolean editing;

    public MessageQueueQueryDialog(IPDHost system, boolean editing) {
        this.host = Objects.requireNonNull(system);
        this.editing = editing;
    }

    public void setQuery(MessageQueueQuery mqQuery) {
        this.mqQuery = Objects.requireNonNull(mqQuery);
        this.host = mqQuery.getSystem();
    }

    public MessageQueueQuery getQuery() {
        return this.mqQuery;
    }

    public void setInitialQuery(String initialQuery) {
        this.initialQuery = initialQuery;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.getDialogTitle());
        this.setMessage(Messages.MessageQueueQueryDialog_SPECIFY_MQM_TO_QUERY);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillAll());
        GUI.label.left((Composite)composite, (String)Messages.MessageQueueQueryDialog_MANAGER, (Object)GUI.grid.d.left1());
        this.wMQM = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1(composite), this.wMQM, (IHostProvider)this.host).types(MessageQueue.class, MessageQueueManager.class).addComboValueSaver(((Object)((Object)this)).getClass().getCanonicalName() + "Manager").filter(new ILookupFilterProvider(){

            @Override
            public String getInitialFilter(Combo combo2) {
                return "MQ:" + MessageQueueQueryDialog.this.wMQM.getText();
            }
        }).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                if (zrl instanceof MessageQueue) {
                    MessageQueueQueryDialog.this.wQuery.setText(zrl.getName());
                } else if (zrl instanceof MessageQueueManager) {
                    MessageQueueQueryDialog.this.wQuery.setText("*");
                }
            }
        }).formatter(new ISelectedValueFormatter(){

            @Override
            public String getNewValue(IPDHost selectedHost, IZRL zrl) {
                if (zrl instanceof MessageQueue) {
                    return ((MessageQueue)zrl).getManager().getName();
                }
                if (zrl instanceof MessageQueueManager) {
                    return zrl.getName();
                }
                return zrl.getFormattedName();
            }
        }).create();
        GUI.label.left((Composite)composite, (String)Messages.Label__QUERY, (Object)GUI.grid.d.left1());
        this.wQuery = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        final Button wQueryLookup = LookupButton.createLookupButtonLeft1(composite);
        LookupDialogFactory.defaults(wQueryLookup, this.wQuery, (IHostProvider)this.host).addComboValueSaver(((Object)((Object)this)).getClass().getCanonicalName() + "Query").types(MessageQueue.class, MessageQueueManager.class).filter(new ILookupFilterProvider(){

            @Override
            public String getInitialFilter(Combo combo2) {
                return "MQ:" + MessageQueueQueryDialog.this.wMQM.getText() + ":" + MessageQueueQueryDialog.this.wQuery.getText();
            }
        }).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                if (zrl instanceof MessageQueue) {
                    MessageQueueQueryDialog.this.wMQM.setText(((MessageQueue)zrl).getManager().getName());
                } else if (zrl instanceof MessageQueueManager) {
                    MessageQueueQueryDialog.this.wMQM.setText(zrl.getName());
                }
            }
        }).formatter(new ISelectedValueFormatter(){

            @Override
            public String getNewValue(IPDHost selectedHost, IZRL zrl) {
                if (zrl instanceof MessageQueue) {
                    return zrl.getName();
                }
                if (zrl instanceof MessageQueueManager) {
                    return "*";
                }
                return zrl.getFormattedName();
            }
        }).create();
        this.wMQM.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                wQueryLookup.setEnabled(!MessageQueueQueryDialog.this.wMQM.getText().trim().isEmpty());
            }
        });
        this.setInitialValues();
        this.wMQM.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                MessageQueueQueryDialog.this.checkComplete();
            }
        });
        this.wQuery.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                MessageQueueQueryDialog.this.checkComplete();
            }
        });
        if (this.wMQM.getText().isEmpty()) {
            this.wMQM.setFocus();
            wQueryLookup.setEnabled(false);
        } else {
            this.wQuery.setFocus();
        }
        this.checkComplete();
        return composite;
    }

    private void setInitialValues() {
        if (this.mqQuery != null) {
            this.wMQM.setText(this.mqQuery.getMQManager().getName());
            this.wQuery.setText(this.mqQuery.getQuery());
        }
        if (this.initialQuery != null) {
            this.wQuery.setText(this.initialQuery);
        }
    }

    public void checkComplete() {
        this.setComplete(MessageQueueManager.isValidName((IPDHost)this.host, (String)this.wMQM.getText()) && MessageQueueQuery.isValidQuery((IPDHost)this.host, (String)this.wQuery.getText()));
    }

    protected void setComplete(boolean complete) {
        if (complete) {
            if (this.wQuery != null) {
                MessageQueueManager mqm = MessageQueueManager.create((IPDHost)this.host, (String)this.wMQM.getText());
                this.mqQuery = MessageQueueQuery.create((MessageQueueManager)mqm, (String)this.wQuery.getText());
            }
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(Messages.MessageQueueQueryDialog_ENTER_VALID_MQ_AND_QUERY);
        }
        super.setComplete(complete);
    }

    private String getDialogTitle() {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        boolean isFilter = false;
        if (selection != null && selection.toString().contains(".rse.") && selection instanceof TreeSelection) {
            TreeSelection treeSelection = (TreeSelection)selection;
            Object object = treeSelection.getFirstElement();
            try {
                Field field = object.getClass().getSuperclass().getSuperclass().getDeclaredField("isNewFilterActionClicked");
                field.setAccessible(true);
                isFilter = (Boolean)field.get(object);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        String title = "";
        title = this.editing ? Messages.MessageQueueQueryDialog_EDIT_MQ_QUERY : (isFilter ? Messages.NewMSGQueueFilter : Messages.MessageQueueQueryDialog_ADD_MQ_QUERY);
        return title;
    }
}

