/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.util.ByteStringComparator;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.SelectionDialog;

public class MemberLookupDialog
extends SelectionDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(MemberLookupDialog.class);
    private final DataSet dataSet;
    private Table wMemList;
    private boolean allowMultiSelect = true;
    private String excludevalue = "";
    private List<Member> collect = new ArrayList<Member>();
    private ILabelProvider labeller = new SystemsLabelProvider();
    private ArrayList<Member> selected = new ArrayList();
    private Job jLoadMembers = new Job(Messages.MemberLookupDialog_LOADING_MEMBERS){
        private List<Member> members;

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(this.getName(), 5);
            IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
            monitor.worked(2);
            try {
                MemberLookupDialog.this.dataSet.refreshSelf(howIsGoing);
            }
            catch (InterruptedException e) {
                logger.trace((Object)"cancelled loading of data set members via refreshSelf() in member lookup dialog");
                return new Status(8, "com.ibm.etools.fm.core", Messages._JOB_WAS_CANCELLED);
            }
            this.members = new ArrayList<Member>(MemberLookupDialog.this.dataSet.getMembers());
            Collections.sort(this.members, new Comparator<Member>(){

                @Override
                public int compare(Member o1, Member o2) {
                    return new ByteStringComparator(o1.getSystem().getHostType()).compare(o1.getName(), o2.getName());
                }
            });
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.worked(2);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    (this).MemberLookupDialog.this.wMemList.removeAll();
                    ArrayList<String> excludeList = new ArrayList<String>(Arrays.asList((this).MemberLookupDialog.this.excludevalue.split(",")));
                    if (excludeList != null) {
                        for (String string : excludeList) {
                            ArrayList col = new ArrayList();
                            members = members.stream().filter(s -> !s.getPDLabel().matches(excludeVal.replaceAll("\\*", "\\\\w*"))).collect(Collectors.toList());
                        }
                    }
                    for (Object object : members) {
                        TableItem tableItem = new TableItem((this).MemberLookupDialog.this.wMemList, 0);
                        tableItem.setText((this).MemberLookupDialog.this.labeller.getText(object));
                        tableItem.setData(object);
                        tableItem.setImage((this).MemberLookupDialog.this.labeller.getImage(object));
                    }
                    (this).MemberLookupDialog.this.parent.layout(false);
                }
            });
            return Status.OK_STATUS;
        }
    };
    private Composite parent;

    public MemberLookupDialog(DataSet dataSet, String excludeValue) {
        super(Display.getCurrent().getActiveShell());
        this.dataSet = Objects.requireNonNull(dataSet, "Must provide a non-null dataSet");
        this.excludevalue = excludeValue;
    }

    public void setAllowMultiSelect(boolean allowMultiSelect) {
        this.allowMultiSelect = allowMultiSelect;
    }

    protected Control createDialogArea(Composite parent) {
        this.parent = parent;
        this.getShell().setText(Messages.MemberLookupDialog_MEMBER_SELECTION);
        this.setHelpAvailable(false);
        TrayDialog.setDialogHelpAvailable((boolean)false);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        int style = 2048;
        if (this.allowMultiSelect) {
            style |= 2;
        }
        this.wMemList = GUI.table((Composite)composite, (Object)GUI.grid.d.fillAll(), (int)style);
        this.wMemList.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MemberLookupDialog.this.getOkButton().setEnabled(MemberLookupDialog.this.wMemList.getSelectionCount() > 0);
            }
        });
        this.wMemList.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                if (MemberLookupDialog.this.getOkButton().isEnabled()) {
                    MemberLookupDialog.this.okPressed();
                }
            }
        });
        this.jLoadMembers.schedule();
        return composite;
    }

    protected Point getInitialSize() {
        return new Point(250, 400);
    }

    protected Point getInitialLocation(Point initialSize) {
        Point parentLocation = this.getParentShell().getLocation();
        Point parentSize = this.getParentShell().getSize();
        Point ourSize = this.getInitialSize();
        int x = parentLocation.x + parentSize.x / 2 - ourSize.x / 2;
        int y = parentLocation.y + parentSize.y / 2 - ourSize.y / 2;
        return new Point(x, y);
    }

    protected void cancelPressed() {
        this.jLoadMembers.cancel();
        super.cancelPressed();
    }

    public ArrayList<Member> getSelectedMembers() {
        return this.selected;
    }

    protected void okPressed() {
        TableItem[] tableItemArray = this.wMemList.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem ti = tableItemArray[n2];
            this.selected.add((Member)ti.getData());
            ++n2;
        }
        this.setResult(this.selected);
        super.okPressed();
    }
}

