/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.ims.ImsAccessMode;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.ImsQueryDialogModel;
import com.ibm.etools.fm.ui.dialog.lookup.ImsSubsystemLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.views.systems.handlers.ModifyImsSubsystemConfig;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import java.lang.reflect.Field;
import java.util.Objects;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.SelectObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class ImsQueryWizard
extends Wizard {
    private ImsQueryDialogModel model;

    private ImsQueryWizard() {
    }

    public static int open(ImsQueryDialogModel model) {
        return PDScrollableWizardDialog.openWizard((IWizard)new ImsQueryWizard().init(model));
    }

    public void addPages() {
        this.addPage((IWizardPage)new ImsQueryPage(this.model));
    }

    public ImsQueryWizard init(ImsQueryDialogModel model) {
        Objects.requireNonNull(model, "Must provide a non-null model.");
        this.setWindowTitle(ImsQueryWizard.getWizardTitle(model));
        this.model = model;
        this.setHelpAvailable(false);
        return this;
    }

    private static String getWizardTitle(ImsQueryDialogModel imsModel) {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        boolean isFilter = false;
        if (selection != null && selection.toString().contains(".rse.") && selection instanceof TreeSelection) {
            TreeSelection treeSelection = (TreeSelection)selection;
            Object object = treeSelection.getFirstElement();
            try {
                Field field = object.getClass().getSuperclass().getSuperclass().getDeclaredField("isNewFilterActionClicked");
                field.setAccessible(true);
                isFilter = (Boolean)field.get(object);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        String title = "";
        title = imsModel.isEditing() ? Messages.ImsQueryDialog_TITLE_EDIT_IMS_QUERY : (isFilter ? Messages.NewIMSFilter : Messages.ImsQueryDialog_TITLE_ADD_IMS_QUERY);
        return title;
    }

    public boolean performFinish() {
        return true;
    }

    private static class ImsQueryPage
    extends WizardPage {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private final ImsQueryDialogModel model;

        protected ImsQueryPage(ImsQueryDialogModel model) {
            super("imsQueryPage", ImsQueryWizard.getWizardTitle(model), null);
            this.model = model;
        }

        public void createControl(Composite parent) {
            this.setMessage(Messages.ImsQueryDialog_2);
            parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillAll());
            GUI.label.left((Composite)parent, (String)Messages.ImsQueryDialog_3, (Object)GUI.grid.d.left1());
            Text wSubsystem = GUI.text.fieldReadOnly((Composite)parent, (Object)GUI.grid.d.fillH((int)1));
            Composite subsystemButtonsComp = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)2, (boolean)false), (Object)GUI.grid.d.left1());
            Button wSubsystemEdit = GUI.button.push((Composite)subsystemButtonsComp, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/ims_customize_subsystem_config.gif"), (String)Messages.CUSTOMIZE_IMS_SUBSYSTEM, (Object)GUI.grid.d.left1());
            wSubsystemEdit.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ModifyImsSubsystemConfig.editConfigAndSaveIfSuccessful(model.getSubsystemConfig());
                }
            });
            Button wSubsystemLookup = LookupButton.createLookupButtonLeft1(subsystemButtonsComp);
            wSubsystemLookup.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ImsSubsystemConfig selectedConfig = ImsSubsystemLookupDialog.promptForValidConfig(model.getSystem(), null);
                    if (selectedConfig != null) {
                        model.setSubsystemConfig(selectedConfig);
                    }
                }
            });
            GUI.label.left((Composite)parent, (String)Messages.ImsQueryDialog_LABEL_REGION, (Object)GUI.grid.d.left1());
            Composite regionComp = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)2, (boolean)true), (Object)GUI.grid.d.fillH((int)2));
            Button wModeBmp = GUI.button.radio((Composite)regionComp, (String)Messages.ImsQueryDialog_RADIO_BMP, (Object)GUI.grid.d.fillH((int)1));
            Button wModeDli = GUI.button.radio((Composite)regionComp, (String)Messages.ImsQueryDialog_RADIO_DLI, (Object)GUI.grid.d.fillH((int)1));
            GUI.label.left((Composite)parent, (String)Messages.ImsQueryDialog_LABEL_TYPE, (Object)GUI.grid.d.left1());
            Composite modeComp = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)2, (boolean)true), (Object)GUI.grid.d.fillH((int)2));
            Button wModeStatic = GUI.button.radio((Composite)modeComp, (String)Messages.ImsQueryDialog_RADIO_PSBS, (Object)GUI.grid.d.fillH((int)1));
            Button wModeDynamic = GUI.button.radio((Composite)modeComp, (String)Messages.ImsQueryDialog_RADIO_DBS, (Object)GUI.grid.d.fillH((int)1));
            GUI.label.left((Composite)parent, (String)Messages.ImsQueryDialog_LABEL_PATTERN, (Object)GUI.grid.d.left1());
            Combo wPattern = GUI.combo.editable((Composite)parent, (Object)GUI.grid.d.fillH((int)2));
            new ComboValueSaver(wPattern, ((Object)((Object)this)).getClass().getCanonicalName() + "pattern");
            this.setDataBinding(wSubsystem, wModeBmp, wModeDli, wModeStatic, wModeDynamic, wPattern, wSubsystemLookup);
            this.setControl((Control)parent);
        }

        private void setDataBinding(Text wSubsystem, Button wModeBmp, Button wModeDli, Button wModeStatic, Button wModeDynamic, final Combo wPattern, final Button wSubsystemLookup) {
            DataBindingContext controller = new DataBindingContext();
            SelectObservableValue targetAccessMode = new SelectObservableValue();
            targetAccessMode.addOption((Object)ImsAccessMode.DYNAMIC, (IObservableValue)WidgetProperties.widgetSelection().observe((Widget)wModeDynamic));
            targetAccessMode.addOption((Object)ImsAccessMode.STATIC, (IObservableValue)WidgetProperties.widgetSelection().observe((Widget)wModeStatic));
            final IObservableValue modelAccessMode = BeanProperties.value((String)this.model.ACCESS_MODE).observe((Object)this.model);
            controller.bindValue((IObservableValue)targetAccessMode, modelAccessMode);
            SelectObservableValue targetRegionType = new SelectObservableValue();
            targetRegionType.addOption((Object)ImsRegionType.BMP, (IObservableValue)WidgetProperties.widgetSelection().observe((Widget)wModeBmp));
            targetRegionType.addOption((Object)ImsRegionType.DLI, (IObservableValue)WidgetProperties.widgetSelection().observe((Widget)wModeDli));
            final IObservableValue modelRegionType = BeanProperties.value((String)this.model.REGION_TYPE).observe((Object)this.model);
            controller.bindValue((IObservableValue)targetRegionType, modelRegionType);
            final IObservableValue modelConfig = BeanProperties.value((String)this.model.SUBSYSTEM_CONFIG).observe((Object)this.model);
            controller.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)wSubsystem), modelConfig, null, new UpdateValueStrategy().setConverter((IConverter)new Converter(ImsSubsystemConfig.class, String.class){

                public Object convert(Object fromObject) {
                    return fromObject instanceof ImsSubsystemConfig ? ((ImsSubsystemConfig)fromObject).getLabel() : "";
                }
            }));
            controller.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)wPattern), modelConfig, new UpdateValueStrategy(), new UpdateValueStrategy().setConverter((IConverter)new Converter(ImsSubsystemConfig.class, Boolean.class){

                public Object convert(Object fromObject) {
                    if (fromObject != null) {
                        return true;
                    }
                    return false;
                }
            }));
            controller.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)wModeBmp), modelConfig, new UpdateValueStrategy(), new UpdateValueStrategy().setConverter((IConverter)new Converter(ImsSubsystemConfig.class, Boolean.class){

                public Object convert(Object fromObject) {
                    if (fromObject != null && ((ImsSubsystemConfig)fromObject).isBmpSupported()) {
                        return true;
                    }
                    return false;
                }
            }));
            controller.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)wModeDli), modelConfig, new UpdateValueStrategy(), new UpdateValueStrategy().setConverter((IConverter)new Converter(ImsSubsystemConfig.class, Boolean.class){

                public Object convert(Object fromObject) {
                    if (fromObject != null && ((ImsSubsystemConfig)fromObject).isDliSupported()) {
                        return true;
                    }
                    return false;
                }
            }));
            controller.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)wModeStatic), modelConfig, new UpdateValueStrategy(), new UpdateValueStrategy().setConverter((IConverter)new Converter(ImsSubsystemConfig.class, Boolean.class){

                public Object convert(Object fromObject) {
                    if (fromObject != null && model.getSubsystemConfig().isBmpSupported() && model.getSubsystemConfig().getBmpConfig().isAccessModeSupported(ImsAccessMode.STATIC)) {
                        return true;
                    }
                    return false;
                }
            }));
            controller.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)wModeDynamic), modelConfig, new UpdateValueStrategy(), new UpdateValueStrategy().setConverter((IConverter)new Converter(ImsSubsystemConfig.class, Boolean.class){

                public Object convert(Object fromObject) {
                    if (fromObject != null && model.getSubsystemConfig().isDliSupported() && model.getSubsystemConfig().getDliConfig().isAccessModeSupported(ImsAccessMode.DYNAMIC)) {
                        return true;
                    }
                    return false;
                }
            }));
            final IObservableValue modelPattern = BeanProperties.value((String)this.model.PATTERN).observe((Object)this.model);
            controller.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)wPattern), modelPattern);
            WizardPageSupport.create((WizardPage)this, (DataBindingContext)controller);
            controller.addValidationStatusProvider((ValidationStatusProvider)new MultiValidator(){

                protected IStatus validate() {
                    IStatus status = ValidationStatus.ok();
                    if (modelConfig.getValue() == null) {
                        wSubsystemLookup.setFocus();
                        status = ValidationStatus.error((String)Messages.ImsQueryDialog_ERROR_SPECIFY_IMS_SUSYSTEM);
                    } else if (modelRegionType.getValue() == null) {
                        status = ValidationStatus.error((String)Messages.ImsQueryWizard_PLEASE_SPECIFY_REGION_TYPE);
                    } else if (modelAccessMode.getValue() == null) {
                        status = ValidationStatus.error((String)Messages.ImsQueryDialog_ERROR_SPECIFY_CONNECTION_MODE);
                    } else if (((String)modelPattern.getValue()).trim().isEmpty()) {
                        wPattern.setFocus();
                        status = ValidationStatus.error((String)Messages.ImsQueryDialog_ERROR_OBJECT_SEARCH_MISSING);
                    }
                    return status.isOK() ? ValidationStatus.info((String)Messages.ImsQueryDialog_2) : status;
                }
            });
            controller.updateTargets();
        }
    }
}

