/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog;

import com.ibm.etools.fm.core.model.ims.ImsAccessMode;
import com.ibm.etools.fm.core.model.ims.ImsDatabaseQuery;
import com.ibm.etools.fm.core.model.ims.ImsPsbQuery;
import com.ibm.etools.fm.core.model.ims.ImsRegionSpecificQuery;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.pdtools.common.component.core.model.PDPropertyChangeSupport;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;

public class ImsQueryDialogModel
extends PDPropertyChangeSupport
implements IHostProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private IPDHost host;
    public final String EDITING = "editing";
    public final String REGION_ENABLED_IN_QUERY = "regionEnabledInQuery";
    public final String SUBSYSTEM_CONFIG = "subsystemConfig";
    public final String REGION_TYPE = "regionType";
    public final String ACCESS_MODE = "accessMode";
    public final String PATTERN = "pattern";
    private final boolean editing;
    private boolean regionEnabledInQuery;
    private ImsSubsystemConfig subsystemConfig;
    private ImsRegionType regionType;
    private ImsAccessMode accessMode;
    private String pattern = "";

    public ImsQueryDialogModel(IPDHost host, boolean editing) {
        this.host = host;
        this.editing = editing;
        this.firePropertyChange("editing", false, this.editing);
        this.regionEnabledInQuery = true;
        this.firePropertyChange("regionEnabledInQuery", this.regionEnabledInQuery, true);
    }

    public ImsRegionSpecificQuery getQuery() {
        switch (this.accessMode) {
            case DYNAMIC: {
                return new ImsDatabaseQuery(this.subsystemConfig.getSubsystem(), this.pattern, this.regionEnabledInQuery ? this.regionType : null, ImsAccessMode.DYNAMIC);
            }
            case STATIC: {
                return new ImsPsbQuery(this.subsystemConfig.getSubsystem(), this.pattern, this.regionEnabledInQuery ? this.regionType : null, ImsAccessMode.STATIC);
            }
        }
        throw new IllegalStateException();
    }

    public boolean isEditing() {
        return this.editing;
    }

    public boolean isRegionEnabledInQuery() {
        return this.regionEnabledInQuery;
    }

    public ImsSubsystemConfig getSubsystemConfig() {
        return this.subsystemConfig;
    }

    public void setSubsystemConfig(ImsSubsystemConfig config) {
        if (!this.getSystem().equals(config.getSubsystem().getSystem())) {
            throw new IllegalArgumentException(config.getSubsystem().getSystem().getConnectionName());
        }
        this.subsystemConfig = config;
        this.firePropertyChange("subsystemConfig", this.subsystemConfig, this.subsystemConfig);
        this.setRegionType(config);
        if (config.isBmpSupported() && config.getBmpConfig().isAccessModeSupported(ImsAccessMode.STATIC)) {
            this.setAccessMode(ImsAccessMode.STATIC);
        } else if (config.isDliSupported() && config.getDliConfig().isAccessModeSupported(ImsAccessMode.DYNAMIC)) {
            this.setAccessMode(ImsAccessMode.DYNAMIC);
        }
    }

    public ImsRegionType getRegionType() {
        return this.regionType;
    }

    public void setRegionType(ImsRegionType regionType) {
        this.regionType = regionType;
        this.firePropertyChange("regionType", this.regionType, this.regionType);
    }

    public void setRegionType(ImsSubsystemConfig config) {
        if (config.isBmpSupported()) {
            this.setRegionType(ImsRegionType.BMP);
        } else if (config.isDliSupported()) {
            this.setRegionType(ImsRegionType.DLI);
        }
    }

    public ImsAccessMode getAccessMode() {
        return this.accessMode;
    }

    public void setAccessMode(ImsAccessMode accessMode) {
        this.accessMode = accessMode;
        this.firePropertyChange("accessMode", this.accessMode, this.accessMode);
    }

    public void setAccessMode(ImsRegionSpecificQuery query) {
        if (query instanceof ImsPsbQuery) {
            this.setAccessMode(ImsAccessMode.STATIC);
        } else if (query instanceof ImsDatabaseQuery) {
            this.setAccessMode(ImsAccessMode.DYNAMIC);
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.firePropertyChange("pattern", this.pattern, this.pattern);
    }

    public IPDHost getSystem() {
        return this.host;
    }
}

