/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.ims.ImsAccessMode;
import com.ibm.etools.fm.core.model.ims.ImsDatabase;
import com.ibm.etools.fm.core.model.ims.ImsDd;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.core.socket.func.ims.ADDS;
import com.ibm.etools.fm.core.socket.func.ims.LDDS;
import com.ibm.etools.fm.core.socket.func.ims.LDDSParser;
import com.ibm.etools.fm.core.socket.func.ims.SSOP;
import com.ibm.etools.fm.core.socket.io.CommonConnectionFM;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunctionParser;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class ImsDatabaseDataSetDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int COLUMN_DBD_NAME = 0;
    private static final int COLUMN_NAME = 1;
    private static final int COLUMN_DSN = 2;
    private List<ImsDd> mergedDbdDds;
    private final List<ImsDd> originalDbdDds;
    private TableViewer viewer;
    private Button wResetToDefaults;
    private IPDHost host;

    public ImsDatabaseDataSetDialog(IPDHost system, List<ImsDd> mergedDbdDds, List<ImsDd> originalDbdDds) {
        Objects.requireNonNull(mergedDbdDds, "Must provide a non-null mergedDbdDds");
        for (ImsDd mergedDd : mergedDbdDds) {
            if (originalDbdDds.contains(mergedDd)) continue;
            throw new IllegalArgumentException(mergedDd.toString());
        }
        this.mergedDbdDds = new ArrayList<ImsDd>(mergedDbdDds);
        this.originalDbdDds = new ArrayList<ImsDd>(originalDbdDds);
        this.host = system;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.ImsDatabaseDataSetDialog_TITLE_DB_DS_SPECIFICATION);
        this.setMessage(Messages.ImsDatabaseDataSetDialog_MESSAGE_ENTER_DS_FOR_EACH_DBD);
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.viewer = this.doCreateTableViewer(parent, 2);
        GUI.grid.padding((Composite)parent, (int)1);
        this.wResetToDefaults = GUI.button.push((Composite)parent, (String)Messages.ImsDatabaseDataSetDialog_BUTTON_RESTORE_DEFAULTS, (Object)GUI.grid.d.horiz((int)131072, (boolean)false, (int)1));
        this.wResetToDefaults.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ArrayList<ImsDd> resetDds = new ArrayList<ImsDd>(ImsDatabaseDataSetDialog.this.originalDbdDds.size());
                for (ImsDd imsDd : ImsDatabaseDataSetDialog.this.originalDbdDds) {
                    resetDds.add(new ImsDd(imsDd));
                }
                ImsDatabaseDataSetDialog.this.mergedDbdDds = resetDds;
                ImsDatabaseDataSetDialog.this.viewer.setInput(ImsDatabaseDataSetDialog.this.mergedDbdDds);
                ImsDatabaseDataSetDialog.this.updateCompleteness();
            }
        });
        this.wResetToDefaults.setEnabled(this.isDdsModified());
        this.updateCompleteness();
        return parent;
    }

    private TableViewer doCreateTableViewer(Composite composite, int width) {
        ScrolledComposite scrollComp = new ScrolledComposite(composite, 2816);
        scrollComp.setLayoutData((Object)GUI.grid.d.fillAll());
        scrollComp.setExpandHorizontal(true);
        scrollComp.setExpandVertical(true);
        Composite tableComp = new Composite((Composite)scrollComp, 0);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComp.setLayout((Layout)tableLayout);
        this.viewer = new TableViewer(tableComp, 65540);
        TableViewerColumn cDbdName = new TableViewerColumn(this.viewer, 16384, 0);
        cDbdName.getColumn().setText(Messages.ImsDatabaseDataSetDialog_COLUMN_TEXT_DBD_NAME);
        cDbdName.setLabelProvider((CellLabelProvider)new ImsDdDbdNameColumnLabelProvider());
        TableViewerColumn cName = new TableViewerColumn(this.viewer, 16384, 1);
        cName.getColumn().setText(Messages.ImsDatabaseDataSetDialog_COLUMN_TEXT_DD_NAME);
        cName.setLabelProvider((CellLabelProvider)new ImsDdNameColumnLabelProvider());
        TableViewerColumn cDsn = new TableViewerColumn(this.viewer, 16384, 2);
        cDsn.getColumn().setText(Messages.ImsDatabaseDataSetDialog_COLUMN_TEXT_DS_NAME);
        cDsn.setLabelProvider((CellLabelProvider)new ImsDdDsnColumnLabelProvider(this.host));
        cDsn.setEditingSupport((EditingSupport)new RenameEditingSupport(this.viewer));
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                TableItem[] selection;
                if (traverseEvent.detail == 4 && (selection = ImsDatabaseDataSetDialog.this.viewer.getTable().getSelection()).length > 0) {
                    Object item = selection[0].getData();
                    traverseEvent.doit = false;
                    ImsDatabaseDataSetDialog.this.viewer.editElement(item, 2);
                }
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ImsDdContentProvider());
        this.viewer.setInput(this.mergedDbdDds);
        scrollComp.setContent((Control)tableComp);
        tableLayout.setColumnData((Widget)cDbdName.getColumn(), (ColumnLayoutData)new ColumnWeightData(25));
        tableLayout.setColumnData((Widget)cName.getColumn(), (ColumnLayoutData)new ColumnWeightData(25));
        tableLayout.setColumnData((Widget)cDsn.getColumn(), (ColumnLayoutData)new ColumnWeightData(50));
        return this.viewer;
    }

    private void updateCompleteness() {
        boolean complete = true;
        for (ImsDd dd : this.mergedDbdDds) {
            if (DataSet.isValidName((String)dd.getDsn(), (String)this.host.getCodePage())) continue;
            this.setErrorMessage(MessageFormat.format(Messages.ImsDatabaseDataSetDialog_ERROR_INVALID_DD_FOR_DBD, dd.getDsn(), dd.getDbdName()));
            complete = false;
        }
        this.wResetToDefaults.setEnabled(this.isDdsModified());
        if (complete) {
            this.setErrorMessage(null);
        }
        this.setComplete(complete);
    }

    private boolean isDdsModified() {
        for (ImsDd mergedDd : this.mergedDbdDds) {
            for (ImsDd original : this.originalDbdDds) {
                if (!mergedDd.equals((Object)original) || mergedDd.getDsn().equals(original.getDsn())) continue;
                return true;
            }
        }
        return false;
    }

    public List<ImsDd> getDbdDds() {
        return this.mergedDbdDds;
    }

    public static Result<StringBuffer> allocateDatabaseDataSets(CommonConnectionFM connection, final ImsDatabase db, boolean letUserEditDataSets, ImsAccessMode accessMode, IHowIsGoing monitor) throws InterruptedException, CommunicationException, NullPointerException {
        Objects.requireNonNull(connection, "Must specify a non-null connection.");
        final IPDHost system = connection.getSystem();
        if (!system.equals(db.getSystem())) {
            throw new IllegalArgumentException(db.getSystem().toString());
        }
        boolean allocateDone = false;
        while (!allocateDone) {
            monitor.worked(1);
            LDDS ldds = new LDDS();
            ldds.setDatabaseName(db.getName());
            ldds.setSubsystemConfig(db.getSubsystem().getCanonicalConfig());
            Result loadResult = UtilityFunctionRunner.executeAndParse((CommonConnectionFM)connection, (UtilityFunction)ldds, (UtilityFunctionParser)new LDDSParser(), (IHowIsGoing)monitor);
            if (!loadResult.isSuccessfulWithoutWarnings()) {
                String msgs = loadResult.getMessagesCombined().toString();
                logger.debug(new Object[]{"Failed to load database data sets", msgs});
                if (loadResult.getResultRC() != 0) {
                    return new Result(loadResult);
                }
            }
            final List loadedDbdDds = (List)loadResult.getOutput();
            final ArrayList<ImsDd> mergedDbdDds = new ArrayList<ImsDd>();
            for (ImsDd imsDd : loadedDbdDds) {
                mergedDbdDds.add(new ImsDd(imsDd));
            }
            List savedDds = ((FMHost)FMHost.getSystem((IPDHost)system)).getImsDatabaseDataSetDds(db.getSubsystem(), db.getName());
            if (savedDds != null) {
                for (ImsDd customDd : savedDds) {
                    int i = 0;
                    while (i < mergedDbdDds.size()) {
                        if (((ImsDd)mergedDbdDds.get(i)).getName().equals(customDd.getName())) {
                            mergedDbdDds.set(i, customDd);
                        }
                        ++i;
                    }
                }
            }
            if (letUserEditDataSets) {
                final AtomicInteger dialogRc = new AtomicInteger();
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ImsDatabaseDataSetDialog dialog = new ImsDatabaseDataSetDialog(system, mergedDbdDds, loadedDbdDds);
                        dialogRc.set(dialog.open());
                        if (dialogRc.get() == 0) {
                            ((FMHost)FMHost.getSystem((IPDHost)system)).setImsDatabaseDataSetDds(db.getSubsystem(), db.getName(), dialog.getDbdDds());
                        }
                    }
                });
                if (dialogRc.get() == 1) {
                    logger.trace((Object)"User failed to specify DFSMDA data sets for DLI");
                    if (connection != null) {
                        connection.forceConnectionClose();
                    }
                    throw new InterruptedException();
                }
            } else {
                ((FMHost)FMHost.getSystem((IPDHost)system)).setImsDatabaseDataSetDds(db.getSubsystem(), db.getName(), mergedDbdDds);
            }
            monitor.worked(1);
            SSOP ssop = new SSOP();
            ssop.setConfig(db.getSubsystem().getCanonicalConfig(), accessMode);
            Result setSubsysOptionsResult = UtilityFunctionRunner.runCommand((CommonConnectionFM)connection, (UtilityFunction)ssop, (IHowIsGoing)monitor);
            if (!setSubsysOptionsResult.isSuccessfulWithoutWarnings()) {
                String msgs = setSubsysOptionsResult.getMessagesCombined().toString();
                logger.debug(new Object[]{"Failed to set IMS subsystem options", msgs});
                return new Result(setSubsysOptionsResult);
            }
            monitor.worked(1);
            ADDS adds = new ADDS();
            adds.setDds(db.getName(), ((FMHost)FMHost.getSystem((IPDHost)system)).getImsDatabaseDataSetDds(db.getSubsystem(), db.getName()));
            Result allocateDdsResult = UtilityFunctionRunner.executeAndParse((CommonConnectionFM)connection, (UtilityFunction)adds, (UtilityFunctionParser)new LDDSParser(), (IHowIsGoing)monitor);
            if (!allocateDdsResult.isSuccessfulWithoutWarnings()) {
                String longMessage = allocateDdsResult.getMessagesCombined().toString();
                String displayMessage = allocateDdsResult.getDisplayMessage();
                if (displayMessage.isEmpty()) {
                    displayMessage = longMessage;
                }
                PDDialogs.openErrorThreadSafe((String)Messages.ImsDatabaseDataSetDialog_ERROR, (String)Messages.ImsDatabaseDataSetDialog_ERROR_FAILED_TO_ALLOCATE, (String)longMessage, (String)displayMessage);
            }
            if (allocateDdsResult.isSuccessfulWithoutWarnings()) {
                allocateDone = true;
            } else {
                letUserEditDataSets = true;
            }
            monitor.worked(1);
        }
        return null;
    }

    private static class ImsDdContentProvider
    implements IStructuredContentProvider {
        private ImsDdContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (!(inputElement instanceof List)) {
                logger.warn((Object)("Unknown input:" + String.valueOf(inputElement)));
                return new Object[0];
            }
            List list = (List)inputElement;
            for (Object object : list) {
                if (object instanceof ImsDd) continue;
                logger.warn((Object)("Unknown element type:" + String.valueOf(inputElement)));
                return new Object[0];
            }
            return list.toArray();
        }
    }

    private static class ImsDdDbdNameColumnLabelProvider
    extends ColumnLabelProvider {
        private ImsDdDbdNameColumnLabelProvider() {
        }

        public String getText(Object element) {
            return ((ImsDd)element).getDbdName();
        }
    }

    private static class ImsDdDsnColumnLabelProvider
    extends ColumnLabelProvider {
        IPDHost host = null;

        public ImsDdDsnColumnLabelProvider(IPDHost host) {
            this.host = host;
        }

        public Image getImage(Object element) {
            if (!DataSet.isValidName((String)((ImsDd)element).getDsn(), (String)this.host.getCodePage())) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
            }
            return super.getImage(element);
        }

        public Color getForeground(Object element) {
            if (!DataSet.isValidName((String)((ImsDd)element).getDsn(), (String)this.host.getCodePage())) {
                return Display.getDefault().getSystemColor(3);
            }
            return super.getForeground(element);
        }

        public String getText(Object element) {
            return ((ImsDd)element).getDsn();
        }
    }

    private static class ImsDdNameColumnLabelProvider
    extends ColumnLabelProvider {
        private ImsDdNameColumnLabelProvider() {
        }

        public String getText(Object element) {
            return ((ImsDd)element).getName();
        }
    }

    private class RenameEditingSupport
    extends EditingSupport {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private TextCellEditor textCellEditor;

        public RenameEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.textCellEditor = new TextCellEditor((Composite)viewer.getTable());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.textCellEditor;
        }

        protected Object getValue(Object element) {
            ImsDd imsDd = (ImsDd)element;
            return imsDd.getDsn();
        }

        protected void setValue(Object element, Object value) {
            ImsDd imsDd = (ImsDd)element;
            String strVal = (String)value;
            imsDd.setDsn(strVal.toUpperCase());
            this.getViewer().update(element, null);
            ImsDatabaseDataSetDialog.this.updateCompleteness();
        }
    }
}

