/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.BaseEditorOptions;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.MessageQueue;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.Volume;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.editor.template.TemplateEditorUtilities;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.callback.IOnSelectionEvent;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.util.ZrlLoaderDialogUtils;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ImportDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private Combo outputFileCombo;
    private Combo baseTemplateCombo;
    private Button outputFileLookupButton;
    private Button printHeaderButton;
    private Button doubleByteData;
    private Button includeFillersButton;
    private Button includeRedefinesButton;
    private Button singleQuotesButton;
    private Combo baseResourceCombo;
    private IPDHost aHostProvider;
    private String baseResourceName;
    private String baseTemplateName;
    private String outputFile;
    private boolean replace;
    private boolean append;
    private String volume;
    private boolean printHeader;
    private boolean includeFillers;
    private boolean includeRedifines;
    private boolean singleQuotes;
    private boolean specifyDoubleBytes;
    private Combo wDestResourceVolser;
    private Button appendButton;
    private boolean isMemberSelection;
    private boolean isAppendVisible;
    private String cachedDsName;
    private BaseEditorOptions options;

    public ImportDialog(IPDHost aHostProvider, boolean isMemberSelection, boolean isAppendVisible) {
        this.aHostProvider = aHostProvider;
        this.isMemberSelection = isMemberSelection;
        this.isAppendVisible = isAppendVisible;
        this.options = new BaseEditorOptions();
    }

    protected Control createDialogArea(Composite parent) {
        this.createTitle();
        GridLayout margins = GUI.grid.l.margins((int)1, (boolean)false);
        margins.verticalSpacing = 1;
        Composite composite = GUI.composite((Composite)parent, (Layout)margins, (Object)GUI.grid.d.fillH((int)1));
        this.createSourceGrp(composite);
        this.createDestinationGrp(composite);
        this.createCsvOptGrp(composite);
        return composite;
    }

    private void createCsvOptGrp(Composite composite) {
        Group cvsGroup = GUI.group((Composite)composite, (String)Messages.ExportAbstractDialog_13, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.printHeaderButton = GUI.button.checkbox((Composite)cvsGroup, (String)Messages.ExportAbstractDialog_6, (Object)GUI.grid.d.fillH((int)1));
        this.printHeaderButton.setToolTipText(Messages.ExportAbstractDialog_7);
        this.printHeaderButton.setSelection(this.printHeader);
        this.doubleByteData = GUI.button.checkbox((Composite)cvsGroup, (String)Messages.ImportDialog_DOUBLEBYTEDATA, (Object)GUI.grid.d.fillH((int)1));
        this.doubleByteData.setToolTipText(Messages.ImportDialog_DOUBLEBYTEDATA);
        this.doubleByteData.setSelection(this.specifyDoubleBytes);
        this.includeFillersButton = GUI.button.checkbox((Composite)cvsGroup, (String)Messages.ExportAbstractDialog_14, (Object)GUI.grid.d.fillH((int)1));
        this.includeFillersButton.setToolTipText(Messages.ExportAbstractDialog_15);
        this.includeFillersButton.setSelection(this.includeFillers);
        this.includeRedefinesButton = GUI.button.checkbox((Composite)cvsGroup, (String)Messages.ExportAbstractDialog_16, (Object)GUI.grid.d.fillH((int)1));
        this.includeRedefinesButton.setToolTipText(Messages.ExportAbstractDialog_17);
        this.includeRedefinesButton.setSelection(this.includeRedifines);
        this.singleQuotesButton = GUI.button.checkbox((Composite)cvsGroup, (String)Messages.ExportAbstractDialog_28, (Object)GUI.grid.d.fillH((int)1));
        this.singleQuotesButton.setToolTipText(Messages.ExportAbstractDialog_29);
        this.singleQuotesButton.setSelection(this.singleQuotes);
    }

    private void createDestinationGrp(Composite composite) {
        GridLayout margins = GUI.grid.l.margins((int)3, (boolean)false);
        margins.verticalSpacing = 1;
        Group resGroup = GUI.group((Composite)composite, (String)Messages.ImportDialog_IMPORTDEST, (Layout)margins, (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)resGroup, (String)Messages.EditorOptionDialog_DSNPATH, (Object)GUI.grid.d.left1());
        this.baseResourceCombo = GUI.combo.editable((Composite)resGroup, (Object)GUI.grid.d.fillH((int)1));
        this.baseResourceCombo.setToolTipText(Messages.ExportDialog_4);
        this.baseResourceCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportDialog.this.setErrorMessage(null);
            }
        });
        this.baseResourceCombo.setText(this.baseResourceName);
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)resGroup), this.baseResourceCombo, (IHostProvider)this.aHostProvider).types(ZRLs.getAllResourceTypesForZos()).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "baseResName").create();
        GUI.label.left((Composite)resGroup, (String)Messages.Label__VOLUME, (Object)GUI.grid.d.left1());
        this.wDestResourceVolser = GUI.combo.editable((Composite)resGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wDestResourceVolser, ((Object)((Object)this)).getClass().getCanonicalName() + "DestVolume");
        if (this.isAppendVisible) {
            this.appendButton = GUI.button.checkbox((Composite)resGroup, (String)Messages.CompareWizardPageResultDatasets_DISPOSITION_APPEND, (Object)GUI.grid.d.fillH((int)2));
            this.appendButton.setSelection(this.append);
        }
    }

    private void createTitle() {
        this.setTitle(Messages.ImportDialog_IMPORTCSV);
        this.setMessage(" ");
    }

    protected void createSourceGrp(Composite parent) {
        List assocs;
        Group outputGroup = GUI.group((Composite)parent, (String)Messages.ImportDialog_IMPORTSOURCE, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)outputGroup, (String)Messages.ImportDialog_CSVFILE, (Object)GUI.grid.d.left1());
        this.outputFileCombo = GUI.combo.editable((Composite)outputGroup, (Object)GUI.grid.d.fillH((int)1));
        this.outputFileCombo.setToolTipText(Messages.ImportDialog_CSVFILE);
        new ComboValueSaver(this.outputFileCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "outputFile");
        this.outputFileCombo.select(0);
        this.outputFileCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportDialog.this.setErrorMessage(null);
            }
        });
        this.outputFileCombo.setText(this.outputFile);
        this.outputFileLookupButton = GUI.button.push((Composite)outputGroup, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/search.gif"), (String)Messages.ExportAbstractDialog_3, (Object)GUI.grid.d.left1());
        this.outputFileLookupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
                String fileName = dialog.open();
                if (fileName == null) {
                    return;
                }
                ImportDialog.this.outputFileCombo.setText(fileName);
            }
        });
        GUI.label.left((Composite)outputGroup, (String)"", (Object)GUI.grid.d.left1());
        GUI.label.left((Composite)outputGroup, (String)Messages.Db2EditorDialog_19, (Object)GUI.grid.d.left1());
        this.baseTemplateCombo = GUI.combo.editable((Composite)outputGroup, (Object)GUI.grid.d.fillH((int)1));
        this.baseTemplateCombo.setText(this.baseTemplateName);
        Button baseTemplateEditButton = GUI.button.push((Composite)outputGroup, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/templateEditor.gif"), (String)Messages.__EDIT_TEMPLATE, (Object)GUI.grid.d.left1());
        baseTemplateEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String aTemplateName = ImportDialog.this.baseTemplateCombo.getText().trim();
                if (!aTemplateName.isEmpty()) {
                    if (ImportDialog.this.validateTemplateExists()) {
                        TemplateEditorUtilities.openTemplateEditSession(ImportDialog.this.options.getaTemplate());
                    } else {
                        PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.EditorOptionDialog_TemplateEditInvalidTemplate, aTemplateName));
                    }
                } else {
                    PDDialogs.openErrorThreadSafe((String)Messages.EditorOptionDialog_TemplateEditNoTemplate);
                }
            }
        });
        LookupDialogFactory.defaults(LookupButton.createLookupTemplateButtonLeft1((Composite)outputGroup), this.baseTemplateCombo, (IHostProvider)this.aHostProvider).types(FMHost.getPermittedTemplateResourceType((IPDHost)this.aHostProvider)).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL z) {
                ImportDialog.this.options.setaTemplate(z);
            }
        }).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "Template").create();
        if (this.options.getaResource() != null && !(assocs = FMHost.getSystem((IPDHost)this.aHostProvider.getSystem()).getTemplateAssociations(this.options.getaResource())).isEmpty()) {
            ComboValueSaver.getInstance((Combo)this.baseTemplateCombo).setCustomItems(assocs.toArray(new String[0]), false, false);
            this.baseTemplateCombo.select(0);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridData data = GUI.grid.d.fillAll();
        data.minimumWidth = 100;
        Button importButton = GUI.button.push((Composite)parent, (String)Messages.ImportDialog_IMPORT, (Object)data, (String)Messages.ExportDialog_10);
        importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ImportDialog.this.validateAndClose();
            }
        });
        Button cancelButton = GUI.button.push((Composite)parent, (String)Messages.EditorOptionDialog_CANCEL, (Object)data);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ImportDialog.this.cancelPressed();
            }
        });
        this.getShell().setDefaultButton(importButton);
    }

    private boolean validateTemplateExists() {
        String result;
        block6: {
            String value = this.baseTemplateCombo.getText().toUpperCase().trim();
            if (this.options.getaTemplate() != null && value.equalsIgnoreCase(this.options.getaTemplate().getFormattedName())) {
                return true;
            }
            this.options.setaTemplate(null);
            if (value.isEmpty()) {
                this.setErrorMessage(Messages.ExportDialog_15);
                this.options.setaTemplate(null);
                this.baseTemplateCombo.setFocus();
                return false;
            }
            this.setErrorMessage(null);
            result = TemplateEditorUtilities.okAsTemplate(ZRLs.parseZRL((IPDHost)this.aHostProvider, (String)value), false, null);
            if (result != null) break block6;
            this.options.setaTemplate(ZRLs.parseZRL((IPDHost)this.aHostProvider.getSystem(), (String)value));
            return true;
        }
        try {
            this.setErrorMessage(result);
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(Messages.EditorOptionDialog_DSNERR_MSG);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.baseTemplateCombo.setFocus();
        this.options.setaTemplate(null);
        return false;
    }

    private void validateAndClose() {
        this.setErrorMessage(null);
        if (this.checkFileExists() && this.checkTemplateName() && this.validateTemplateExists() && this.validateVolsor() && this.validateResourceName()) {
            this.okPressed();
        }
    }

    private boolean checkFileExists() {
        File csvFile = new File(this.outputFileCombo.getText());
        if (!csvFile.exists()) {
            this.setMessage(Messages.ImportDialog_CSVFILENOTEXIST, 3);
            this.outputFileCombo.setFocus();
            return false;
        }
        return true;
    }

    private boolean validateResourceName() {
        block9: {
            if (this.baseResourceCombo.getText().trim().isEmpty()) {
                this.setMessage(Messages.ExportDialog_11, 3);
                this.baseResourceCombo.setFocus();
                return false;
            }
            String value = this.baseResourceCombo.getText().trim();
            if (!ZRLs.isParseable((IPDHost)this.aHostProvider, (String)value)) {
                this.setErrorMessage(Messages.ExportDialog_12);
                this.baseResourceCombo.setFocus();
                return false;
            }
            if (this.isMemberSelection) {
                if (value.contains("(")) {
                    return this.checkMemberExists(value);
                }
                return this.checkDSExists(value);
            }
            if (value.contains("(")) {
                return this.checkMemberExists(value);
            }
            String dsName = value;
            DataSet selectedDSN = DataSet.create((IPDHost)this.aHostProvider, (String)dsName);
            try {
                Result<StringBuffer> result = ZrlLoaderDialogUtils.refreshDataSetProperties((DataSetOrMember)selectedDSN);
                if (!result.isSuccessfulWithoutWarnings()) break block9;
                if (selectedDSN.getConfirmedExists() && selectedDSN.getType() == DataSetType.LIBRARY) {
                    this.setErrorMessage(Messages.ImportDialog_ValidateError);
                    return false;
                }
            }
            catch (InterruptedException ex) {
                this.setErrorMessage(ex.getMessage());
                return false;
            }
        }
        this.setErrorMessage(Messages.ImportDialog_ValidResource);
        return true;
    }

    private boolean checkMemberExists(String value) {
        int indexOfFirstBrace = value.indexOf("(");
        String dsName = value.substring(0, indexOfFirstBrace);
        String memberName = value.substring(indexOfFirstBrace + 1, value.length() - 1);
        DataSet selectedDSN = DataSet.create((IPDHost)this.aHostProvider, (String)dsName);
        Member selectedMember = Member.create((DataSet)selectedDSN, (String)memberName);
        try {
            Result<StringBuffer> result = ZrlLoaderDialogUtils.refreshDataSetProperties((DataSetOrMember)selectedDSN);
            if (result.isSuccessfulWithoutWarnings() && selectedDSN.getConfirmedExists() && selectedDSN.getMembers().contains(selectedMember)) {
                boolean confirm = this.popUpConfirmDialog();
                if (confirm) {
                    this.okPressed();
                }
                return false;
            }
        }
        catch (InterruptedException ex) {
            this.setErrorMessage(ex.getMessage());
            return false;
        }
        return true;
    }

    private boolean checkDSExists(String dsName) {
        DataSet selectedDSN = DataSet.create((IPDHost)this.aHostProvider, (String)dsName);
        try {
            Result<StringBuffer> result = ZrlLoaderDialogUtils.refreshDataSetProperties((DataSetOrMember)selectedDSN);
            if (result.isSuccessfulWithoutWarnings() && selectedDSN.getConfirmedExists()) {
                boolean confirm = this.popUpConfirmDialog();
                if (confirm) {
                    this.okPressed();
                }
                return false;
            }
        }
        catch (InterruptedException ex) {
            this.setErrorMessage(ex.getMessage());
            return false;
        }
        return true;
    }

    private boolean popUpConfirmDialog() {
        boolean confirm = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Confirm", (String)Messages.ImportDialog_IMPORTEXIST);
        if (confirm) {
            this.replace = true;
            return true;
        }
        return false;
    }

    private boolean checkTemplateName() {
        String value = this.baseTemplateCombo.getText().toUpperCase().trim();
        if (value.isEmpty()) {
            this.setErrorMessage(Messages.ExportDialog_13);
            this.options.setaTemplate(null);
            this.baseTemplateCombo.setFocus();
            return false;
        }
        if (!Member.isParseable((String)value, (boolean)true, (String)this.aHostProvider.getSystem().getCodePage())) {
            this.setErrorMessage(Messages.ExportDialog_14);
            this.options.setaTemplate(null);
            this.baseTemplateCombo.setFocus();
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean validateVolsor() {
        String aVolume = this.wDestResourceVolser.getText().toUpperCase();
        if (aVolume.isEmpty()) {
            this.options.setaVolumeSerial(null);
            return true;
        }
        if (this.options.getaResource() instanceof MessageQueue || this.options.getaResource() instanceof UssFile) {
            PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.EditorOptionDialog_VOLUME_NA, this.options.getaResource().getFormattedName()));
            this.options.setaVolumeSerial(null);
            return true;
        }
        if (Volume.isValid((String)aVolume, (String)this.aHostProvider.getCodePage())) {
            this.options.setaVolumeSerial(aVolume);
            return true;
        }
        this.setErrorMessage(Messages.EditorOptionDialog_VOLUME_SERIAL_INVALID);
        this.options.setaVolumeSerial(null);
        this.wDestResourceVolser.setFocus();
        return false;
    }

    protected void okPressed() {
        this.cachedDsName = this.baseResourceName = this.baseResourceCombo.getText();
        this.baseTemplateName = this.baseTemplateCombo.getText();
        this.outputFile = this.outputFileCombo.getText();
        this.includeFillers = this.includeFillersButton.getSelection();
        this.printHeader = this.printHeaderButton.getSelection();
        this.includeRedifines = this.includeRedefinesButton.getSelection();
        this.singleQuotes = this.singleQuotesButton.getSelection();
        this.specifyDoubleBytes = this.doubleByteData.getSelection();
        this.volume = this.wDestResourceVolser.getText();
        if (this.isAppendVisible) {
            this.append = this.appendButton.getSelection();
        }
        super.okPressed();
    }

    public void setBaseResourceName(String baseResourceName) {
        this.baseResourceName = baseResourceName;
    }

    public String getBaseResourceName() {
        return this.baseResourceName;
    }

    public String getBaseTemplateName() {
        return this.baseTemplateName;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public boolean isPrintHeader() {
        return this.printHeader;
    }

    public boolean isIncludeFillers() {
        return this.includeFillers;
    }

    public boolean isIncludeRedifines() {
        return this.includeRedifines;
    }

    public boolean isSingleQuotes() {
        return this.singleQuotes;
    }

    public boolean isSpecifyDoubleBytes() {
        return this.specifyDoubleBytes;
    }

    public String getVolume() {
        return this.volume;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public String getCachedDsName() {
        return this.cachedDsName;
    }

    public void setBaseTemplateName(String baseTemplateName) {
        this.baseTemplateName = baseTemplateName;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public void setPrintHeader(boolean printHeader) {
        this.printHeader = printHeader;
    }

    public void setSpecifyDoubleBytes(boolean specifyDoubleBytes) {
        this.specifyDoubleBytes = specifyDoubleBytes;
    }

    public void setIncludeFillers(boolean includeFillers) {
        this.includeFillers = includeFillers;
    }

    public void setIncludeRedifines(boolean includeRedifines) {
        this.includeRedifines = includeRedifines;
    }

    public void setSingleQuotes(boolean singleQuotes) {
        this.singleQuotes = singleQuotes;
    }
}

