/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog;

import com.ibm.etools.fm.core.Messages;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.ui.dialog.PDDialogWithText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class FMDialogWithText
extends PDDialogWithText {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(FMDialogWithText.class);

    private FMDialogWithText(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String longMessage, String[] additionalButtonLabels, PDDialogWithText.ITextDialogRunnable[] additionalActions) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex, longMessage, additionalButtonLabels, additionalActions);
    }

    public static void showResultDump(Result<StringBuffer> result, boolean forceOutputToString, int minRC) {
        boolean resultDisplayed = false;
        if (result != null && result.getRC() == 0) {
            Result newResult = new Result();
            newResult.copy(result);
            StringBuffer resultBuffer = (StringBuffer)newResult.getOutput();
            if (resultBuffer != null && resultBuffer.toString().contains("<message number=")) {
                int index = resultBuffer.toString().indexOf("text=");
                String resultString = resultBuffer.toString().substring(index + 6);
                resultString = resultString.substring(0, resultString.indexOf(34));
                newResult.setOutput((Object)new StringBuffer(resultString));
                FMDialogWithText.showResultDump(newResult, forceOutputToString, minRC, new String[0], new PDDialogWithText.ITextDialogRunnable[0]);
                resultDisplayed = true;
            }
        }
        if (!resultDisplayed) {
            FMDialogWithText.showResultDump(result, forceOutputToString, minRC, new String[0], new PDDialogWithText.ITextDialogRunnable[0]);
        }
    }

    public static void showResultDump(final Result<?> result, final boolean forceOutputToString, int minRC, final String[] labels, final PDDialogWithText.ITextDialogRunnable[] actions) {
        if (result == null || result.getRC() < minRC) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell activeShell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                String dumpedOutputAndMessages = result.dumpOutputAndMessages(forceOutputToString);
                if (result.getRC() < 4) {
                    FMDialogWithText.openInformation((Shell)activeShell, (String)Messages.FMDialogWithText_INFORMATION, (String)Messages.FMDialogWithText_REVIEW_INFO, (String)dumpedOutputAndMessages, (String[])labels, (PDDialogWithText.ITextDialogRunnable[])actions);
                } else if (result.getRC() == 4) {
                    FMDialogWithText.openWarning((Shell)activeShell, (String)Messages.FMDialogWithText_WARNING, (String)Messages.FMDialogWithText_REVIEW_WARNINGS, (String)dumpedOutputAndMessages, (String[])labels, (PDDialogWithText.ITextDialogRunnable[])actions);
                } else {
                    FMDialogWithText.openError((Shell)activeShell, (String)Messages.Error, (String)Messages.FMDialogWithText_REVIEW_ERRORS, (String)dumpedOutputAndMessages, (String[])labels, (PDDialogWithText.ITextDialogRunnable[])actions);
                }
            }
        });
    }
}

