/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DummyMember;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.core.model.db2.Db2EditOptions;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2SubsystemProvider;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.core.model.db2.Db2TemplateOptions;
import com.ibm.etools.fm.editor.formatted2.dialogs.Db2OptionsDialog;
import com.ibm.etools.fm.editor.template.TemplateEditorUtilities;
import com.ibm.etools.fm.editor.template2.TemplateEditorUtilities2;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.Export2DesktopData;
import com.ibm.etools.fm.ui.dialog.ExportAbstractDialog;
import com.ibm.etools.fm.ui.dialog.lookup.Db2SubsystemLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.Db2TableLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.callback.IOnSelectionEvent;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.util.ZrlLoaderDialogUtils;
import com.ibm.etools.fm.ui.widget.Db2TableContentProposals;
import com.ibm.etools.fm.ui.wizards.db2.Db2ObjectModelUtil;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.EncodingUtils;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ExportDialog2
extends ExportAbstractDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private IPDHost host;
    private Db2EditOptions options;
    private boolean initWithDb2EditOptions;
    private Combo ssidCombo;
    private Combo ownerCombo;
    private Combo nameCombo;
    private Combo startPosCombo;
    private Combo rowCountCombo;
    private Combo encodingCombo;
    private Combo dbcsEncodingCombo;
    private Combo db2TemplateCombo;
    private Button db2TemplateEditButton;
    private Export2DesktopData initdata;

    public ExportDialog2(IPDHost host, Db2Subsystem subsystem, Db2Table table) {
        Objects.requireNonNull(host, "Must specify a non-null host.");
        this.options = new Db2EditOptions();
        if (table != null) {
            this.options.setTable(table);
        } else if (subsystem != null) {
            this.options.setSubsystem(subsystem);
        } else {
            this.options.setHost(host);
        }
        this.host = this.options.getSystem();
        this.initWithDb2EditOptions = false;
    }

    public ExportDialog2(Db2EditOptions options) {
        this.host = options.getSystem();
        this.options = options.clone();
        this.initWithDb2EditOptions = true;
    }

    public void initValues(Export2DesktopData initdata) {
        this.initdata = initdata;
        super.setInitData(initdata);
    }

    private void initDialogValues() {
        if (this.initdata != null) {
            super.setInitData(this.initdata);
            super.initialiseValues();
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.ExportDialog2_0);
        this.setMessage(Messages.ExportDialog2_1);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.createDB2ObjectGroup(composite);
        this.createTemplateGroup(composite);
        this.createDB2EditorOptionsGroup(composite);
        this.createOutputDetailsGroup(composite, false);
        this.initialiseDialogValues();
        this.initDialogValues();
        return composite;
    }

    private void initialiseDialogValues() {
        if (this.options.getSubsystem() != null) {
            this.ssidCombo.setText(this.options.getSubsystem().getSubsystemID());
        }
        if (this.options.getTable() != null) {
            this.ownerCombo.setText(Db2ObjectModelUtil.getObjectName(this.options.getCreator()));
            this.nameCombo.setText(Db2ObjectModelUtil.getObjectName(this.options.getName()));
        }
        if (this.options.getTemplate() != null) {
            this.db2TemplateCombo.setText(this.options.getTemplate().getFormattedName());
        }
        this.encodingCombo.setText(this.options.getEncoding());
        this.dbcsEncodingCombo.setText(this.options.getDbcsEncoding());
        ComboValueSaver.getInstance((Combo)this.encodingCombo).setCustomItems(EncodingUtils.getDefaultEncodingValues(), false);
        ComboValueSaver.getInstance((Combo)this.dbcsEncodingCombo).setCustomItems(EncodingUtils.getDefaultDBCSEncodingValues(), false);
        this.encodingCombo.setText(this.options.getEncoding());
        if (this.initWithDb2EditOptions) {
            this.startPosCombo.setText(this.options.getStartPosition());
            this.rowCountCombo.setText(this.options.getRowCount());
            this.dbcsEncodingCombo.setText(this.options.getDbcsEncoding());
        } else {
            this.startPosCombo.select(0);
            if (this.rowCountCombo.getItemCount() == 0) {
                this.rowCountCombo.setText("ALL");
            } else {
                this.rowCountCombo.select(0);
            }
            this.dbcsEncodingCombo.select(0);
        }
        if (this.options.getSubsystem() == null) {
            this.ssidCombo.setFocus();
        } else if (this.options.getTable() == null) {
            this.ownerCombo.setFocus();
        } else {
            this.db2TemplateCombo.setFocus();
        }
    }

    private void createDB2ObjectGroup(Composite parent) {
        Group db2ObjectGroup = GUI.group((Composite)parent, (String)Messages.Db2EditorDialog_2, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)db2ObjectGroup, (String)Messages.Db2EditorDialog_3, (Object)GUI.grid.d.left1());
        this.ssidCombo = GUI.combo.editable((Composite)db2ObjectGroup, (Object)GUI.grid.d.fillH((int)1));
        this.ssidCombo.setToolTipText(Messages.Db2EditorDialog_4);
        new ComboValueSaver(this.ssidCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "ssid");
        this.ssidCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportDialog2.this.setErrorMessage(null);
                ExportDialog2.this.validateSubsystem();
            }
        });
        Button ssidLookup = GUI.button.push((Composite)db2ObjectGroup, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/search.gif"), (String)Messages.Db2EditorDialog_38, (Object)GUI.grid.d.left1());
        ssidLookup.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                Db2SubsystemLookupDialog lookup = new Db2SubsystemLookupDialog(ExportDialog2.this.options.getSystem());
                if (lookup.open() == 0) {
                    ExportDialog2.this.options.setSubsystem((Db2Subsystem)lookup.getFirstSelectedObject());
                    ExportDialog2.this.ssidCombo.setText(ExportDialog2.this.options.getSubsystem().getSubsystemID());
                }
            }
        });
        GUI.label.left((Composite)db2ObjectGroup, (String)Messages.Db2EditorDialog_7, (Object)GUI.grid.d.left1());
        this.ownerCombo = GUI.combo.editable((Composite)db2ObjectGroup, (Object)GUI.grid.d.fillH((int)1));
        this.ownerCombo.setToolTipText(Messages.Db2EditorDialog_8);
        this.ownerCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportDialog2.this.setErrorMessage(null);
            }
        });
        SelectionAdapter lookupHandler = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExportDialog2.this.validateSubsystem()) {
                    Db2TableLookupDialog lookup = new Db2TableLookupDialog(ExportDialog2.this.options.getSubsystem());
                    lookup.setInitialOwnerPattern(ExportDialog2.this.ownerCombo.getText());
                    lookup.setInitialNamePattern(ExportDialog2.this.nameCombo.getText());
                    if (lookup.open() == 0) {
                        Db2Table selected = (Db2Table)lookup.getFirstSelectedObject();
                        ExportDialog2.this.options.setTable(selected);
                        ExportDialog2.this.initialiseDialogValues();
                    }
                }
            }
        };
        Button lookupTableButtonForOwner = GUI.button.push((Composite)db2ObjectGroup, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/search.gif"), (String)Messages.Db2EditorDialog_33, (Object)GUI.grid.d.left1());
        lookupTableButtonForOwner.addSelectionListener((SelectionListener)lookupHandler);
        GUI.label.left((Composite)db2ObjectGroup, (String)Messages.Db2EditorDialog_11, (Object)GUI.grid.d.left1());
        this.nameCombo = GUI.combo.editable((Composite)db2ObjectGroup, (Object)GUI.grid.d.fillH((int)1));
        this.nameCombo.setToolTipText(Messages.Db2EditorDialog_12);
        Db2TableContentProposals.addTo(this.ownerCombo, this.nameCombo, (Db2SubsystemProvider)this.options, ((Object)((Object)this)).getClass().getCanonicalName() + "Resource");
        this.nameCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportDialog2.this.setErrorMessage(null);
            }
        });
        Button lookupTableButtonForName = GUI.button.push((Composite)db2ObjectGroup, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/search.gif"), (String)Messages.Db2EditorDialog_33, (Object)GUI.grid.d.left1());
        lookupTableButtonForName.addSelectionListener((SelectionListener)lookupHandler);
    }

    private void createTemplateGroup(Composite parent) {
        Group group = GUI.group((Composite)parent, (String)Messages.Db2EditorDialog_19, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)group, (String)Messages.Db2EditorDialog_20, (Object)GUI.grid.d.left1());
        this.db2TemplateCombo = GUI.combo.editable((Composite)group, (Object)GUI.grid.d.fillH((int)1));
        this.db2TemplateEditButton = GUI.button.push((Composite)group, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/templateEditor.gif"), (String)Messages.__EDIT_TEMPLATE, (Object)GUI.grid.d.left1());
        this.db2TemplateEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String aTemplateName = ExportDialog2.this.db2TemplateCombo.getText().trim();
                if (!aTemplateName.isEmpty() && ExportDialog2.this.validateSubsystem() && ExportDialog2.this.validateTableName()) {
                    if (ExportDialog2.this.validateTemplateDataSetName(true)) {
                        Db2TemplateOptions tmpOptions = new Db2TemplateOptions();
                        tmpOptions.setTable(ExportDialog2.this.options.getTable());
                        tmpOptions.setTemplate(ExportDialog2.this.options.getTemplate());
                        TemplateEditorUtilities2.openTemplateEditSession(tmpOptions);
                        return;
                    }
                    ExportDialog2.this.setErrorMessage(MessageFormat.format(Messages.EditorOptionDialog_TemplateEditInvalidTemplate, aTemplateName));
                    return;
                }
                ExportDialog2.this.setErrorMessage(Messages.EditorOptionDialog_TemplateEditNoTemplate);
            }
        });
        LookupDialogFactory.defaults(LookupButton.createLookupTemplateButtonLeft1((Composite)group), this.db2TemplateCombo, (IHostProvider)this.host).types(FMHost.getPermittedTemplateResourceType((IPDHost)this.host)).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                ExportDialog2.this.options.setTemplate(zrl);
                ExportDialog2.this.db2TemplateCombo.setText(ExportDialog2.this.options.getTemplate().getFormattedName());
            }
        }).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "Template").create();
        List assocs = FMHost.getSystem((IPDHost)this.host).getTemplateAssociations((IZRL)this.options.getTable());
        if (assocs.size() > 0) {
            ComboValueSaver.getInstance((Combo)this.db2TemplateCombo).setCustomItems(assocs.toArray(new String[0]), false, false);
            this.db2TemplateCombo.select(0);
        }
        this.db2TemplateCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportDialog2.this.setErrorMessage(null);
            }
        });
    }

    private void createDB2EditorOptionsGroup(Composite parent) {
        Group db2OptionsGroup = GUI.group((Composite)parent, (String)Messages.Db2EditorDialog_34, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)db2OptionsGroup, (String)Messages.Db2EditorDialog_13, (Object)GUI.grid.d.left1());
        this.startPosCombo = GUI.combo.editable((Composite)db2OptionsGroup, (Object)GUI.grid.d.fillH((int)1));
        this.startPosCombo.setToolTipText(Messages.Db2EditorDialog_14);
        new ComboValueSaver(this.startPosCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "startPosCombo");
        this.startPosCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportDialog2.this.setErrorMessage(null);
            }
        });
        GUI.label.left((Composite)db2OptionsGroup, (String)Messages.Db2EditorDialog_15, (Object)GUI.grid.d.left1());
        this.rowCountCombo = GUI.combo.editable((Composite)db2OptionsGroup, (Object)GUI.grid.d.fillH((int)1));
        this.rowCountCombo.setToolTipText(Messages.Db2EditorDialog_16);
        new ComboValueSaver(this.rowCountCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "rowCountCombo");
        this.rowCountCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportDialog2.this.setErrorMessage(null);
            }
        });
        GUI.label.left((Composite)db2OptionsGroup, (String)Messages.Db2EditorDialog_17, (Object)GUI.grid.d.left1());
        this.encodingCombo = GUI.combo.editable((Composite)db2OptionsGroup, (Object)GUI.grid.d.fillH((int)1));
        this.encodingCombo.setToolTipText(Messages.Db2EditorDialog_18);
        new ComboValueSaver(this.encodingCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "encodingCombo");
        this.encodingCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportDialog2.this.setErrorMessage(null);
            }
        });
        GUI.label.left((Composite)db2OptionsGroup, (String)Messages.Db2EditorDialog_GraphicEncoding, (Object)GUI.grid.d.left1());
        this.dbcsEncodingCombo = GUI.combo.editable((Composite)db2OptionsGroup, (Object)GUI.grid.d.fillH((int)1));
        this.dbcsEncodingCombo.setToolTipText(Messages.Db2EditorDialog_GraphicEncodingDesc);
        new ComboValueSaver(this.dbcsEncodingCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "dbcsEncodingCombo");
        this.dbcsEncodingCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportDialog2.this.setErrorMessage(null);
            }
        });
    }

    private boolean validateTemplateDataSetName(boolean memberMustExist) {
        String result;
        block6: {
            String value = this.db2TemplateCombo.getText().toUpperCase().trim();
            if (value.isEmpty()) {
                this.options.setTemplate((IZRL)DummyMember.createDummyMember((IPDHost)this.host));
                return true;
            }
            if (this.options.getTemplate() != null && value.equalsIgnoreCase(this.options.getTemplate().getFormattedName())) {
                return true;
            }
            this.options.setTemplate(null);
            this.setErrorMessage(null);
            result = TemplateEditorUtilities.okAsTemplate(ZRLs.parseZRL((IPDHost)this.host, (String)value), memberMustExist, null);
            if (result != null) break block6;
            this.options.setTemplate(ZRLs.parseZRL((IPDHost)this.host, (String)value));
            return true;
        }
        try {
            this.setErrorMessage(result);
            this.db2TemplateCombo.setFocus();
            this.options.setTemplate(null);
            return false;
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(Messages.Db2EditorDialog_26);
            this.db2TemplateCombo.setFocus();
            this.options.setTemplate(null);
            return false;
        }
        catch (InterruptedException e) {
            this.db2TemplateCombo.setFocus();
            this.options.setTemplate(null);
            return false;
        }
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonBar = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)3, (boolean)true), (Object)new GridData(0x1000008, 4, false, false));
        this.createButtonsForButtonBar(buttonBar);
        return buttonBar;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridData data = GUI.grid.d.fillAll();
        data.minimumWidth = 100;
        Button exportButton = GUI.button.push((Composite)parent, (String)Messages.ExportDialog2_2, (Object)data, (String)Messages.ExportDialog2_3);
        exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ExportDialog2.this.options.setEdit(true);
                ExportDialog2.this.validateAndClose();
            }
        });
        Button optionButton = GUI.button.push((Composite)parent, (String)Messages.Db2EditorDialog_27, (Object)data, (String)Messages.Db2EditorDialog_28);
        optionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Db2OptionsDialog dialog;
                if (ExportDialog2.this.validateSubsystem() && (dialog = new Db2OptionsDialog(ExportDialog2.this.options.getSystemOptions(), ExportDialog2.this.options.getEditorOptions())).open() == 0) {
                    ExportDialog2.this.options.putEditorOptions(dialog.getEditorOptions());
                    ExportDialog2.this.options.setSystemOptions(dialog.getSystemOptions());
                }
            }
        });
        Button cancelButton = GUI.button.push((Composite)parent, (String)Messages.EditorOptionDialog_CANCEL, (Object)data);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ExportDialog2.this.cancelPressed();
            }
        });
        this.getShell().setDefaultButton(exportButton);
    }

    private boolean validateAndClose() {
        this.setErrorMessage(null);
        if (!this.validateSubsystem()) {
            return false;
        }
        if (!this.validateTableName()) {
            return false;
        }
        if (this.options.getTable() == null) {
            this.setErrorMessage(Messages.Db2EditorDialog_35);
            return false;
        }
        if (!this.noDupEditSession()) {
            return false;
        }
        if (!this.validateStartPosition()) {
            return false;
        }
        if (!this.validateRowCount()) {
            return false;
        }
        if (!this.validateEncoding()) {
            return false;
        }
        if (!this.validateDbcsEncoding()) {
            return false;
        }
        if (!super.validate(false)) {
            return false;
        }
        if (!this.validateTemplateDataSetName(false)) {
            return false;
        }
        Result result = new Result();
        if (!ZrlLoaderDialogUtils.tableExists(this.options.getTable(), result, true)) {
            this.setErrorMessage(MessageFormat.format(Messages.Db2ObjectCheckError, this.options.getCreator(), this.options.getName()));
            return false;
        }
        return this.close();
    }

    private boolean validateSubsystem() {
        String ssid = this.ssidCombo.getText().trim();
        if (!Db2Subsystem.isValidName((IPDHost)this.options.getSystem(), (String)ssid)) {
            this.setErrorMessage(Messages.Db2EditorDialog_39);
            this.ssidCombo.setFocus();
            return false;
        }
        this.options.setSubsystem(new Db2Subsystem(this.options.getSystem(), ssid));
        return true;
    }

    private boolean validateTableName() {
        String tableCreater = Db2ObjectModelUtil.getObjectName(this.ownerCombo.getText());
        if (tableCreater.isEmpty()) {
            try {
                AuthDetails authDetails = this.options.getSystem().getLogin(true);
                tableCreater = authDetails.getUsername();
            }
            catch (InterruptedException e) {
                logger.debug((Object)"User cancelled while retrieving the user name.");
            }
        }
        if (!Db2Table.isValidOwner((IPDHost)this.options.getSystem(), (String)tableCreater)) {
            this.setErrorMessage(Messages.Db2EditorDialog_36);
            this.ownerCombo.setText(tableCreater);
            this.ownerCombo.setFocus();
            return false;
        }
        String tableName = Db2ObjectModelUtil.getObjectName(this.nameCombo.getText());
        if (!Db2Table.isValidName((IPDHost)this.options.getSystem(), (String)tableName)) {
            this.setErrorMessage(Messages.Db2EditorDialog_37);
            this.nameCombo.setFocus();
            return false;
        }
        this.options.setTable(new Db2Table(this.options.getSubsystem(), tableName, tableCreater));
        return true;
    }

    private boolean noDupEditSession() {
        if (this.options == null || this.options.getTable() == null) {
            this.setErrorMessage(Messages.Db2EditorDialog_35);
            return false;
        }
        return true;
    }

    private boolean validateStartPosition() {
        String value = this.startPosCombo.getText().trim();
        if (value.isEmpty()) {
            this.options.setStartPosition("1");
            this.startPosCombo.setText(this.options.getStartPosition());
            return true;
        }
        if (this.validInteger(value)) {
            this.options.setStartPosition(value);
            return true;
        }
        this.setErrorMessage(MessageFormat.format(Messages.ExportDialog2_IntegerMustBe1ToMaxInt, Integer.MAX_VALUE));
        this.startPosCombo.setFocus();
        return false;
    }

    private boolean validateRowCount() {
        String value = this.rowCountCombo.getText().trim();
        if (value.isEmpty()) {
            this.options.setRowCount("ALL");
            this.rowCountCombo.setText(this.options.getRowCount());
            return true;
        }
        if ("ALL".equalsIgnoreCase(value)) {
            this.options.setRowCount("ALL");
            return true;
        }
        if (this.validInteger(value)) {
            this.options.setRowCount(value);
            return true;
        }
        this.setErrorMessage(MessageFormat.format(Messages.Db2EditorDialog_30, "ALL"));
        this.rowCountCombo.setFocus();
        return false;
    }

    private boolean validateEncoding() {
        String value = this.encodingCombo.getText();
        if (value.isEmpty()) {
            this.options.setEncoding(this.host.getHostType().getDefaultEncoding());
            return true;
        }
        if (!EncodingUtils.isValidCodePage((String)(value = EncodingUtils.parseCodePage((String)value)))) {
            this.setErrorMessage(Messages.Db2EditorDialog_31);
            this.encodingCombo.setFocus();
            this.options.setEncoding(this.host.getHostType().getDefaultEncoding());
            return false;
        }
        this.options.setEncoding(value);
        return true;
    }

    private boolean validateDbcsEncoding() {
        String value = this.dbcsEncodingCombo.getText();
        if (value.isEmpty()) {
            this.options.setDbcsEncoding("");
            return true;
        }
        if (!EncodingUtils.isValidCodePage((String)(value = EncodingUtils.parseCodePage((String)value)))) {
            this.setErrorMessage(Messages.Db2EditorDialog_31);
            this.dbcsEncodingCombo.setFocus();
            this.options.setDbcsEncoding("");
            return false;
        }
        this.options.setDbcsEncoding(value);
        return true;
    }

    public Db2EditOptions getOptions() {
        return this.options;
    }
}

