/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.BaseEditorOptions;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.MessageQueue;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.Volume;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.editor.template.TemplateEditorUtilities;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.Export2DesktopData;
import com.ibm.etools.fm.ui.dialog.ExportAbstractDialog;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.callback.IOnSelectionEvent;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.widget.NumberForcer;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.util.ArrayUtils;
import com.ibm.pdtools.common.component.jhost.util.EncodingUtils;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ExportDialog
extends ExportAbstractDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private IPDHost aHostProvider;
    private Combo baseResourceCombo;
    private Combo volumeSerialCombo;
    private Combo baseTemplateCombo;
    private Combo startPositionTypeCombo;
    private Combo startPositionCombo;
    private Combo recordLimitCombo;
    private Button recordSamplingButton;
    private Combo includePhysicalRecordsCombo;
    private Combo skipPhysicalRecordCombo;
    private Combo binaryReclenCombo;
    private Combo encodingCombo;
    private Combo dbcsEncodingCombo;
    private Combo ioExitCombo;
    private BaseEditorOptions options;
    private BaseEditorOptions initOptions;
    private Export2DesktopData initdata;

    public ExportDialog(IPDHost aHostProvider) {
        Objects.requireNonNull(aHostProvider, "Must specify a non-null aHostProvider.");
        this.aHostProvider = aHostProvider;
        this.options = new BaseEditorOptions();
    }

    public void initValues(BaseEditorOptions initOptions, Export2DesktopData initdata) {
        this.initOptions = initOptions;
        this.initdata = initdata;
        super.setInitData(initdata);
        this.initOptions.setOnlySelectedRecs(false);
        this.options = initOptions.clone();
    }

    private void initDialogValues() {
        if (this.initOptions != null) {
            if (this.initOptions.getaResource() != null) {
                ExportDialog.setTextIfNotNull(this.baseResourceCombo, this.initOptions.getaResource().getFormattedName());
            }
            if (this.initOptions.getaTemplate() != null) {
                ExportDialog.setTextIfNotNull(this.baseTemplateCombo, this.initOptions.getaTemplate().getFormattedName());
            }
            if (!this.baseResourceCombo.getText().isEmpty()) {
                this.baseTemplateCombo.setFocus();
            }
            if (this.initOptions.getaVolumeSerial() != null) {
                ExportDialog.setTextIfNotNull(this.volumeSerialCombo, this.initOptions.getaVolumeSerial());
            }
            this.startPositionTypeCombo.setText(this.initOptions.getStartType().name());
            if (this.initOptions.getaStartPosition() != null) {
                ExportDialog.setTextIfNotNull(this.startPositionCombo, this.initOptions.getaStartPosition());
            }
            this.startPositionCombo.setEnabled(this.initOptions.getStartType() != BaseEditorOptions.BaseStartPosType.NONE);
            ExportDialog.setTextIfNotNull(this.recordLimitCombo, this.initOptions.getRecordLimit());
            this.recordSamplingButton.setSelection(this.initOptions.isRecordSampling());
            this.includePhysicalRecordsCombo.setEnabled(this.initOptions.isRecordSampling());
            this.skipPhysicalRecordCombo.setEnabled(this.initOptions.isRecordSampling());
            ExportDialog.setTextIfNotNull(this.includePhysicalRecordsCombo, this.initOptions.getIncludePhysicalRecords());
            ExportDialog.setTextIfNotNull(this.skipPhysicalRecordCombo, this.initOptions.getSkipPhysicalRecords());
            ExportDialog.setTextIfNotNull(this.binaryReclenCombo, this.initOptions.getBinaryLength());
            ExportDialog.setTextIfNotNull(this.encodingCombo, this.initOptions.getEncodingForSession());
            ExportDialog.setTextIfNotNull(this.dbcsEncodingCombo, this.initOptions.getDbcsEncodingForSession());
            ExportDialog.setTextIfNotNull(this.ioExitCombo, this.initOptions.getIoExitName());
            super.setInitData(this.initdata);
            super.initialiseValues();
        }
    }

    private static void setTextIfNotNull(Combo c, String modelValue) {
        if (modelValue != null) {
            c.setText(modelValue);
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.ExportDialog_0);
        this.setMessage(Messages.ExportDialog_1);
        GridLayout margins = GUI.grid.l.margins((int)1, (boolean)false);
        margins.verticalSpacing = 1;
        Composite composite = GUI.composite((Composite)parent, (Layout)margins, (Object)GUI.grid.d.fillH((int)1));
        this.createBaseResourceSpecGroup(composite);
        this.createTemplateComposite(composite);
        this.createStartPositionComposite(composite);
        this.createProcessingOptionsComposite(composite);
        this.createOutputDetailsGroup(composite, true);
        this.initDialogValues();
        return composite;
    }

    private void createBaseResourceSpecGroup(Composite parent) {
        GridLayout margins = GUI.grid.l.margins((int)3, (boolean)false);
        margins.verticalSpacing = 1;
        Group resGroup = GUI.group((Composite)parent, (String)Messages.ExportDialog_2, (Layout)margins, (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)resGroup, (String)Messages.ExportDialog_3, (Object)GUI.grid.d.left1());
        this.baseResourceCombo = GUI.combo.editable((Composite)resGroup, (Object)GUI.grid.d.fillH((int)1));
        this.baseResourceCombo.setToolTipText(Messages.ExportDialog_4);
        this.baseResourceCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportDialog.this.setErrorMessage(null);
            }
        });
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)resGroup), this.baseResourceCombo, (IHostProvider)this.aHostProvider).types(ZRLs.getAllResourceTypesForZos()).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "baseResName").create();
        GUI.label.left((Composite)resGroup, (String)Messages.EditorOptionDialog_VOLUME_SERIAL, (Object)GUI.grid.d.left1());
        this.volumeSerialCombo = GUI.combo.editable((Composite)resGroup, (Object)GUI.grid.d.fillH((int)2));
        this.volumeSerialCombo.setToolTipText(Messages.ExportDialog_7);
        new ComboValueSaver(this.volumeSerialCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "volser");
        GUI.label.left((Composite)resGroup, (String)"", (Object)GUI.grid.d.left1());
    }

    private void createTemplateComposite(Composite parent) {
        List assocs;
        GridLayout margins = GUI.grid.l.margins((int)4, (boolean)false);
        margins.verticalSpacing = 1;
        Group group = GUI.group((Composite)parent, (String)Messages.EditorOptionDialog_TEMPLATE_GROUP_NAME, (Layout)margins, (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)group, (String)Messages.EditorOptionDialog_DSN, (Object)GUI.grid.d.left1());
        this.baseTemplateCombo = GUI.combo.editable((Composite)group, (Object)GUI.grid.d.fillH((int)1));
        if (!this.baseResourceCombo.getText().isEmpty()) {
            this.baseTemplateCombo.setFocus();
        }
        Button baseTemplateEditButton = GUI.button.push((Composite)group, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/templateEditor.gif"), (String)Messages.__EDIT_TEMPLATE, (Object)GUI.grid.d.left1());
        baseTemplateEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String aTemplateName = ExportDialog.this.baseTemplateCombo.getText().trim();
                if (!aTemplateName.isEmpty()) {
                    if (ExportDialog.this.validateTemplateExists()) {
                        TemplateEditorUtilities.openTemplateEditSession(ExportDialog.this.options.getaTemplate());
                    } else {
                        PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.EditorOptionDialog_TemplateEditInvalidTemplate, aTemplateName));
                    }
                } else {
                    PDDialogs.openErrorThreadSafe((String)Messages.EditorOptionDialog_TemplateEditNoTemplate);
                }
            }
        });
        LookupDialogFactory.defaults(LookupButton.createLookupTemplateButtonLeft1((Composite)group), this.baseTemplateCombo, (IHostProvider)this.aHostProvider).types(FMHost.getPermittedTemplateResourceType((IPDHost)this.aHostProvider)).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL z) {
                ExportDialog.this.options.setaTemplate(z);
            }
        }).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "Template").create();
        if (this.options.getaResource() != null && !(assocs = FMHost.getSystem((IPDHost)this.aHostProvider.getSystem()).getTemplateAssociations(this.options.getaResource())).isEmpty()) {
            ComboValueSaver.getInstance((Combo)this.baseTemplateCombo).setCustomItems(assocs.toArray(new String[0]), false, false);
            this.baseTemplateCombo.select(0);
        }
    }

    private void createStartPositionComposite(Composite parent) {
        GridLayout margins = GUI.grid.l.margins((int)2, (boolean)false);
        margins.verticalSpacing = 1;
        Group group = GUI.group((Composite)parent, (String)Messages.EditorOptionDialog_START_POSITION_GROUP, (Layout)margins, (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)group, (String)Messages.EditorOptionDialog_START_POS_TYPE, (Object)GUI.grid.d.left1());
        this.startPositionTypeCombo = GUI.combo.readOnly((Composite)group, (Object)GUI.grid.d.fillH((int)1), (Object[])ArrayUtils.getToStringArray((Object[])BaseEditorOptions.BaseStartPosType.values()));
        this.startPositionTypeCombo.select(0);
        this.startPositionTypeCombo.setToolTipText(Messages.ExportDialog_8);
        this.startPositionTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String str = ExportDialog.this.startPositionTypeCombo.getText();
                if (str.equals(BaseEditorOptions.BaseStartPosType.NONE.toString())) {
                    ExportDialog.this.startPositionCombo.setEnabled(false);
                } else if (str.equals(BaseEditorOptions.BaseStartPosType.KEY.toString())) {
                    ExportDialog.this.startPositionCombo.setEnabled(true);
                } else if (str.equals(BaseEditorOptions.BaseStartPosType.RBA.toString())) {
                    ExportDialog.this.startPositionCombo.setEnabled(true);
                } else if (str.equals(BaseEditorOptions.BaseStartPosType.RECORD_NUMBER.toString())) {
                    ExportDialog.this.startPositionCombo.setEnabled(true);
                }
            }
        });
        GUI.label.left((Composite)group, (String)Messages.EditorOptionDialog_START_POS, (Object)GUI.grid.d.left1());
        this.startPositionCombo = GUI.combo.editable((Composite)group, (Object)GUI.grid.d.fillH((int)1));
        this.startPositionCombo.setToolTipText(Messages.ExportDialog_16);
        new ComboValueSaver(this.startPositionCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "startPosCombo");
        this.startPositionCombo.setEnabled(false);
    }

    private void createProcessingOptionsComposite(Composite parent) {
        GridLayout margins = GUI.grid.l.margins((int)2, (boolean)false);
        margins.verticalSpacing = 1;
        Group group = GUI.group((Composite)parent, (String)Messages.EditorOptionDialog_PROCESSING_OPTION_GROUP_NAME, (Layout)margins, (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)group, (String)Messages.EditorOptionDialog_REC_SAMP, (Object)GUI.grid.d.left1());
        this.recordSamplingButton = new Button((Composite)group, 32);
        this.recordSamplingButton.setSelection(false);
        this.recordSamplingButton.setToolTipText(Messages.ExportDialog_17);
        this.recordSamplingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportDialog.this.includePhysicalRecordsCombo.setEnabled(ExportDialog.this.recordSamplingButton.getSelection());
                ExportDialog.this.skipPhysicalRecordCombo.setEnabled(ExportDialog.this.recordSamplingButton.getSelection());
            }
        });
        GUI.label.left((Composite)group, (String)Messages.EditorOptionDialog_INC_PHY_REC, (Object)GUI.grid.d.left1());
        this.includePhysicalRecordsCombo = GUI.combo.editable((Composite)group, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.includePhysicalRecordsCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "inclPhy");
        this.includePhysicalRecordsCombo.setEnabled(false);
        NumberForcer includePhysicalRecordsComboNF = NumberForcer.addTo(this.includePhysicalRecordsCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "inclPhy");
        includePhysicalRecordsComboNF.setLowerBound(1, true);
        includePhysicalRecordsComboNF.setUpperBound(Integer.MAX_VALUE, true);
        GUI.label.left((Composite)group, (String)Messages.EditorOptionDialog_SKIP_PHY_REC, (Object)GUI.grid.d.left1());
        this.skipPhysicalRecordCombo = GUI.combo.editable((Composite)group, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.skipPhysicalRecordCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "skipPhys");
        this.skipPhysicalRecordCombo.setEnabled(false);
        NumberForcer skipPhysicalRecordComboNF = NumberForcer.addTo(this.skipPhysicalRecordCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "skipPhys");
        skipPhysicalRecordComboNF.setLowerBound(1, true);
        skipPhysicalRecordComboNF.setUpperBound(Integer.MAX_VALUE, true);
        GUI.label.left((Composite)group, (String)Messages.EditorOptionDialog_REC_LIMIT, (Object)GUI.grid.d.left1());
        this.recordLimitCombo = GUI.combo.editable((Composite)group, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.recordLimitCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "recLim");
        NumberForcer recordLimitComboNF = NumberForcer.addTo(this.recordLimitCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "recLim");
        recordLimitComboNF.setLowerBound(1, true);
        recordLimitComboNF.setUpperBound(Integer.MAX_VALUE, true);
        GUI.label.left((Composite)group, (String)Messages.EditorOptionDialog_RECLEN, (Object)GUI.grid.d.left1());
        this.binaryReclenCombo = GUI.combo.editable((Composite)group, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.binaryReclenCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "binRecLen");
        NumberForcer binaryReclenComboNF = NumberForcer.addTo(this.binaryReclenCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "binRecLen");
        binaryReclenComboNF.setLowerBound(1, true);
        binaryReclenComboNF.setUpperBound(Integer.MAX_VALUE, true);
        this.binaryReclenCombo.setToolTipText(Messages.ExportDialog_18);
        GUI.label.left((Composite)group, (String)Messages.EditorOptionDialog_ENCODING, (Object)GUI.grid.d.left1());
        this.encodingCombo = GUI.combo.editable((Composite)group, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.encodingCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "encoding");
        ComboValueSaver.getInstance((Combo)this.encodingCombo).setCustomItems(EncodingUtils.getDefaultEncodingValues(), false);
        this.encodingCombo.select(0);
        this.encodingCombo.setToolTipText(Messages.ExportDialog_19);
        GUI.label.left((Composite)group, (String)Messages.EditorOptionDialog_GRAPHIC_ENCODING, (Object)GUI.grid.d.left1());
        this.dbcsEncodingCombo = GUI.combo.editable((Composite)group, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.dbcsEncodingCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "dbcsEncoding");
        ComboValueSaver.getInstance((Combo)this.dbcsEncodingCombo).setCustomItems(EncodingUtils.getDefaultDBCSEncodingValues(), false);
        this.dbcsEncodingCombo.select(0);
        this.dbcsEncodingCombo.setToolTipText(Messages.EditorOptionDialog_GRAPHIC_ENCODING_TIP);
        GUI.label.left((Composite)group, (String)Messages.ExportDialog_5, (Object)GUI.grid.d.left1());
        this.ioExitCombo = GUI.combo.editable((Composite)group, (Object)GUI.grid.d.fillH((int)1));
        this.ioExitCombo.setToolTipText(Messages.EditorOptionDialog_1);
        new ComboValueSaver(this.ioExitCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "ioExit");
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonBar = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)true), (Object)new GridData(0x1000008, 4, false, false));
        this.createButtonsForButtonBar(buttonBar);
        return buttonBar;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridData data = GUI.grid.d.fillAll();
        data.minimumWidth = 100;
        Button exportButton = GUI.button.push((Composite)parent, (String)Messages.ExportDialog_9, (Object)data, (String)Messages.ExportDialog_10);
        exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ExportDialog.this.validateAndClose();
            }
        });
        Button cancelButton = GUI.button.push((Composite)parent, (String)Messages.EditorOptionDialog_CANCEL, (Object)data);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ExportDialog.this.cancelPressed();
            }
        });
        this.getShell().setDefaultButton(exportButton);
    }

    private boolean validateAndClose() {
        this.setErrorMessage(null);
        return this.validateResourceName() && this.validateVolsor() && this.checkTemplateName() && super.validate(true) && this.validateStartPosition() && this.validateProcessingOptions() && this.validateEncoding() && this.validateDbcsEncoding() && this.validateIoExitName() && this.validateTemplateExists() && this.close();
    }

    private boolean validateResourceName() {
        if (this.baseResourceCombo.getText().trim().isEmpty()) {
            this.setMessage(Messages.ExportDialog_11, 3);
            this.baseResourceCombo.setFocus();
            return false;
        }
        String value = this.baseResourceCombo.getText().trim();
        if (!ZRLs.isParseable((IPDHost)this.aHostProvider, (String)value)) {
            this.setErrorMessage(Messages.ExportDialog_12);
            this.baseResourceCombo.setFocus();
            return false;
        }
        this.options.setaResource(ZRLs.parseZRL((IPDHost)this.aHostProvider.getSystem(), (String)value));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean validateVolsor() {
        String aVolume = this.volumeSerialCombo.getText().toUpperCase();
        if (aVolume.isEmpty()) {
            this.options.setaVolumeSerial(null);
            return true;
        }
        if (this.options.getaResource() instanceof MessageQueue || this.options.getaResource() instanceof UssFile) {
            PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.EditorOptionDialog_VOLUME_NA, this.options.getaResource().getFormattedName()));
            this.options.setaVolumeSerial(null);
            return true;
        }
        if (Volume.isValid((String)aVolume, (String)this.aHostProvider.getCodePage())) {
            this.options.setaVolumeSerial(aVolume);
            return true;
        }
        this.setErrorMessage(Messages.EditorOptionDialog_VOLUME_SERIAL_INVALID);
        this.options.setaVolumeSerial(null);
        this.volumeSerialCombo.setFocus();
        return false;
    }

    private boolean checkTemplateName() {
        String value = this.baseTemplateCombo.getText().toUpperCase().trim();
        if (value.isEmpty()) {
            this.setErrorMessage(Messages.ExportDialog_13);
            this.options.setaTemplate(null);
            this.baseTemplateCombo.setFocus();
            return false;
        }
        if (!Member.isParseable((String)value, (boolean)true, (String)this.aHostProvider.getSystem().getCodePage())) {
            this.setErrorMessage(Messages.ExportDialog_14);
            this.options.setaTemplate(null);
            this.baseTemplateCombo.setFocus();
            return false;
        }
        return true;
    }

    private boolean validateTemplateExists() {
        String result;
        block6: {
            String value = this.baseTemplateCombo.getText().toUpperCase().trim();
            if (this.options.getaTemplate() != null && value.equalsIgnoreCase(this.options.getaTemplate().getFormattedName())) {
                return true;
            }
            this.options.setaTemplate(null);
            if (value.isEmpty()) {
                this.setErrorMessage(Messages.ExportDialog_15);
                this.options.setaTemplate(null);
                this.baseTemplateCombo.setFocus();
                return false;
            }
            this.setErrorMessage(null);
            result = TemplateEditorUtilities.okAsTemplate(ZRLs.parseZRL((IPDHost)this.aHostProvider, (String)value), false, null);
            if (result != null) break block6;
            this.options.setaTemplate(ZRLs.parseZRL((IPDHost)this.aHostProvider.getSystem(), (String)value));
            return true;
        }
        try {
            this.setErrorMessage(result);
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(Messages.EditorOptionDialog_DSNERR_MSG);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.baseTemplateCombo.setFocus();
        this.options.setaTemplate(null);
        return false;
    }

    private boolean validateStartPosition() {
        BaseEditorOptions.BaseStartPosType startPositionType = BaseEditorOptions.BaseStartPosType.valueOf((String)this.startPositionTypeCombo.getText());
        String value = this.startPositionCombo.getText();
        if (startPositionType == BaseEditorOptions.BaseStartPosType.KEY) {
            if (value.isEmpty()) {
                this.setMessage(Messages.EditorOptionDialog_START_POS_KEYERR, 3);
                this.startPositionCombo.setFocus();
                this.options.setStartType(BaseEditorOptions.BaseStartPosType.NONE);
                this.options.setaStartPosition(null);
                return false;
            }
            this.options.setStartType(startPositionType);
            this.options.setaStartPosition(value);
            return true;
        }
        if (startPositionType == BaseEditorOptions.BaseStartPosType.RBA || startPositionType == BaseEditorOptions.BaseStartPosType.RECORD_NUMBER) {
            if (ExportDialog.isValidInteger(value)) {
                Integer.parseInt(value);
                this.options.setStartType(startPositionType);
                this.options.setaStartPosition(value);
                return true;
            }
            if (startPositionType == BaseEditorOptions.BaseStartPosType.RBA) {
                this.setMessage(Messages.EditorOptionDialog_START_POS_RBAERR, 3);
            } else {
                this.setMessage(Messages.EditorOptionDialog_START_POS_RECNUMERR, 3);
            }
            this.options.setStartType(BaseEditorOptions.BaseStartPosType.NONE);
            this.options.setaStartPosition(null);
            this.startPositionCombo.setFocus();
            return false;
        }
        this.options.setStartType(BaseEditorOptions.BaseStartPosType.NONE);
        this.options.setaStartPosition(null);
        return true;
    }

    private boolean validateEncoding() {
        String value = this.encodingCombo.getText();
        if (value.isEmpty()) {
            this.options.setEncodingForSession(this.aHostProvider.getSystem().getCodePage());
        } else {
            if (!EncodingUtils.isValidCodePage((String)(value = EncodingUtils.parseCodePage((String)value)))) {
                this.setMessage(MessageFormat.format(Messages.EditorOptionDialog_ENCODING_NOT_SUPPORTED, value), 3);
                this.encodingCombo.setFocus();
                return false;
            }
            this.options.setEncodingForSession(value);
        }
        return true;
    }

    private boolean validateDbcsEncoding() {
        String value = this.dbcsEncodingCombo.getText();
        if (value.isEmpty()) {
            this.options.setDbcsEncodingForSession("cp930");
        } else {
            if (!EncodingUtils.isValidCodePage((String)(value = EncodingUtils.parseCodePage((String)value)))) {
                this.setMessage(MessageFormat.format(Messages.EditorOptionDialog_GRAPHIC_ENCODING_NOT_SUPPORTED, value), 3);
                this.dbcsEncodingCombo.setFocus();
                return false;
            }
            this.options.setDbcsEncodingForSession(value);
        }
        return true;
    }

    private boolean validateIoExitName() {
        String value = this.ioExitCombo.getText().trim().toUpperCase();
        if (value.isEmpty()) {
            this.options.setIoExitName(null);
        } else if (Member.isParseable((String)value, (boolean)false, (String)this.aHostProvider.getSystem().getCodePage())) {
            this.options.setIoExitName(value);
        } else {
            this.setErrorMessage(Messages.ExportDialog_6);
            this.ioExitCombo.setFocus();
            return false;
        }
        return true;
    }

    private boolean validateProcessingOptions() {
        if (!this.recordLimitCombo.getText().isEmpty()) {
            if (!ExportDialog.isValidInteger(this.recordLimitCombo.getText())) {
                this.setMessage(Messages.EditorOptionDialog_RECORD_LIMIT_ERR, 3);
                this.recordLimitCombo.setFocus();
                return false;
            }
            this.options.setRecordLimit(this.recordLimitCombo.getText());
        } else {
            this.options.setRecordLimit(null);
        }
        if (this.recordSamplingButton.getSelection()) {
            String includePhysicalRecordValue = this.includePhysicalRecordsCombo.getText();
            String skipPhysicalRecordValue = this.skipPhysicalRecordCombo.getText();
            if (!ExportDialog.isValidInteger(includePhysicalRecordValue)) {
                this.setMessage(Messages.EditorOptionDialog_INC_PHYRICAL_REC_ERR, 3);
                this.includePhysicalRecordsCombo.setFocus();
                return false;
            }
            if (!ExportDialog.isValidInteger(skipPhysicalRecordValue)) {
                this.setMessage(Messages.EditorOptionDialog_SKIP_PHYRICAL_REC_ERR, 3);
                this.skipPhysicalRecordCombo.setFocus();
                return false;
            }
            this.options.setRecordSampling(true);
            this.options.setIncludePhysicalRecords(includePhysicalRecordValue);
            this.options.setSkipPhysicalRecords(skipPhysicalRecordValue);
        } else {
            this.options.setRecordSampling(false);
            this.options.setIncludePhysicalRecords(null);
            this.options.setSkipPhysicalRecords(null);
        }
        if (!this.binaryReclenCombo.getText().isEmpty()) {
            String lengthValue = this.binaryReclenCombo.getText();
            if (lengthValue.isEmpty() || !ExportDialog.isValidInteger(lengthValue)) {
                this.setMessage(Messages.EditorOptionDialog_BIN_RECL_ERR, 3);
                this.binaryReclenCombo.setFocus();
                return false;
            }
            this.options.setBinaryLength(lengthValue);
        } else {
            this.options.setBinaryLength(null);
        }
        this.setErrorMessage(null);
        return true;
    }

    private static boolean isValidInteger(String value) {
        if (!value.isEmpty()) {
            try {
                Integer.parseInt(value);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public BaseEditorOptions getOptions() {
        return this.options;
    }
}

