/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.Export2DesktopData;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.io.File;
import java.text.MessageFormat;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class ExportAbstractDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2025. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private Combo outputFileCombo;
    private Button outputFileLookupButton;
    private Button xmlOutputButton;
    private Button csvOutputButton;
    private Button printHeaderButton;
    private Label csvDelimiterLabel;
    private Combo csvDelimiterCombo;
    private Button includeFillersButton;
    private Button includeRedefinesButton;
    private Button includeLeadingBlanksButton;
    private Button includeTrailingBlanksButton;
    private Button encapsulateButton;
    private Button singleQuotesButton;
    private Button asisEncapsulationButton;
    private Button unmaskCharactersButton;
    private ExportOutputType outputType = ExportOutputType.CSV;
    private String outputFileName;
    private boolean printHeader;
    private String delimiter;
    private boolean includeFillers;
    private boolean includeRedefines;
    private boolean includeLeadingBlanks;
    private boolean includeTrailingBlanks;
    private boolean encapsulate;
    private boolean singleQuotes;
    private boolean asisEncapsulation;
    private boolean unmaskCharacters;
    private Export2DesktopData initData;

    public void setInitData(Export2DesktopData initData) {
        this.initData = initData;
        this.outputType = initData.getType();
        this.outputFileName = initData.getOutputFileName();
        this.printHeader = initData.isPrintHeader();
        this.delimiter = initData.getDelimiter();
        this.includeFillers = initData.isIncludeFillers();
        this.includeRedefines = initData.isIncludeRedefines();
        this.includeLeadingBlanks = initData.isIncludeLeadingBlanks();
        this.includeTrailingBlanks = initData.isIncludeTrailingBlanks();
        this.encapsulate = initData.isEncapsulate();
        this.singleQuotes = initData.isSingleQuotes();
        this.asisEncapsulation = initData.isAsisEncapsulation();
        this.unmaskCharacters = initData.isUnMaskCharacters();
    }

    protected void initialiseValues() {
        if (this.initData == null) {
            return;
        }
        if (this.initData.getOutputFileName() != null && this.initData.getOutputFileName().length() > 0) {
            this.outputFileCombo.setText(this.initData.getOutputFileName());
        }
        this.printHeaderButton.setSelection(this.initData.isPrintHeader());
        if (this.initData.getType() == ExportOutputType.CSV) {
            this.csvOutputButton.setSelection(true);
            this.xmlOutputButton.setSelection(false);
            this.printHeaderButton.setEnabled(true);
            this.csvDelimiterLabel.setEnabled(true);
            this.csvDelimiterCombo.setEnabled(true);
            if (this.includeFillersButton != null) {
                this.includeFillersButton.setEnabled(true);
                this.includeFillersButton.setSelection(this.initData.isIncludeFillers());
            }
            if (this.includeRedefinesButton != null) {
                this.includeRedefinesButton.setEnabled(true);
                this.includeRedefinesButton.setSelection(this.initData.isIncludeRedefines());
            }
            this.includeLeadingBlanksButton.setEnabled(true);
            this.includeLeadingBlanksButton.setSelection(this.initData.isIncludeLeadingBlanks());
            this.includeTrailingBlanksButton.setEnabled(true);
            this.includeTrailingBlanksButton.setSelection(this.initData.isIncludeTrailingBlanks());
            this.encapsulateButton.setEnabled(true);
            this.encapsulateButton.setSelection(this.initData.isEncapsulate());
            this.singleQuotesButton.setEnabled(true);
            this.singleQuotesButton.setSelection(this.initData.isSingleQuotes());
            this.asisEncapsulationButton.setEnabled(true);
            this.asisEncapsulationButton.setSelection(this.initData.isAsisEncapsulation());
            this.unmaskCharactersButton.setEnabled(true);
            this.unmaskCharactersButton.setSelection(this.initData.isUnMaskCharacters());
        } else {
            this.csvOutputButton.setSelection(false);
            this.xmlOutputButton.setSelection(true);
            this.printHeaderButton.setEnabled(false);
            this.csvDelimiterLabel.setEnabled(false);
            this.csvDelimiterCombo.setEnabled(false);
            this.includeFillersButton.setEnabled(false);
            this.includeRedefinesButton.setEnabled(false);
            this.includeLeadingBlanksButton.setEnabled(false);
            this.includeTrailingBlanksButton.setEnabled(false);
            this.encapsulateButton.setEnabled(false);
            this.singleQuotesButton.setEnabled(false);
            this.asisEncapsulationButton.setEnabled(false);
            this.unmaskCharactersButton.setEnabled(false);
        }
    }

    protected void createOutputDetailsGroup(Composite parent, final boolean isBase) {
        Group outputGroup = GUI.group((Composite)parent, (String)Messages.ExportAbstractDialog_0, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)outputGroup, (String)Messages.ExportAbstractDialog_1, (Object)GUI.grid.d.left1());
        this.outputFileCombo = GUI.combo.editable((Composite)outputGroup, (Object)GUI.grid.d.fillH((int)1));
        this.outputFileCombo.setToolTipText(Messages.ExportAbstractDialog_2);
        new ComboValueSaver(this.outputFileCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "outputFile");
        if (this.outputFileCombo.getItemCount() < 1) {
            this.outputFileCombo.setText(ExportAbstractDialog.generateDefaultCSVPath());
        } else {
            this.outputFileCombo.select(0);
        }
        this.outputFileCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportAbstractDialog.this.setErrorMessage(null);
            }
        });
        this.outputFileLookupButton = GUI.button.push((Composite)outputGroup, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/search.gif"), (String)Messages.ExportAbstractDialog_3, (Object)GUI.grid.d.left1());
        this.outputFileLookupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
                String fileName = dialog.open();
                if (fileName == null) {
                    return;
                }
                ExportAbstractDialog.this.outputFileCombo.setText(fileName);
            }
        });
        Composite outputTypeCompositeOut = GUI.composite((Composite)outputGroup, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)3));
        Composite outputTypeComposite = GUI.composite((Composite)outputTypeCompositeOut, (Layout)GUI.grid.l.noMargins((int)2, (boolean)false), (Object)GUI.grid.d.vert((int)128, (boolean)false, (int)2));
        GUI.label.left((Composite)outputTypeComposite, (String)Messages.ExportAbstractDialog_4, (Object)GUI.grid.d.left1());
        Composite exportTypeComposite = GUI.composite((Composite)outputTypeComposite, (Layout)GUI.grid.l.margins((int)3, (boolean)true), (Object)GUI.grid.d.vert((int)128, (boolean)false, (int)3));
        this.csvOutputButton = GUI.button.radio((Composite)exportTypeComposite, (String)Messages.ExportAbstractDialog_5, (Object)GUI.grid.d.left1());
        this.csvOutputButton.setSelection(true);
        this.csvOutputButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportAbstractDialog.this.printHeaderButton.setEnabled(true);
                ExportAbstractDialog.this.csvDelimiterLabel.setEnabled(true);
                ExportAbstractDialog.this.csvDelimiterCombo.setEnabled(true);
                if (isBase) {
                    ExportAbstractDialog.this.includeFillersButton.setEnabled(true);
                    ExportAbstractDialog.this.includeRedefinesButton.setEnabled(true);
                    ExportAbstractDialog.this.unmaskCharactersButton.setEnabled(true);
                }
                ExportAbstractDialog.this.includeLeadingBlanksButton.setEnabled(true);
                ExportAbstractDialog.this.includeTrailingBlanksButton.setEnabled(true);
                ExportAbstractDialog.this.encapsulateButton.setEnabled(true);
                ExportAbstractDialog.this.singleQuotesButton.setEnabled(true);
                ExportAbstractDialog.this.asisEncapsulationButton.setEnabled(true);
                ExportAbstractDialog.this.formatLocationExtension();
            }
        });
        this.xmlOutputButton = GUI.button.radio((Composite)exportTypeComposite, (String)Messages.ExportAbstractDialog_9, (Object)GUI.grid.d.fillH((int)2));
        this.xmlOutputButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportAbstractDialog.this.printHeaderButton.setEnabled(false);
                ExportAbstractDialog.this.csvDelimiterLabel.setEnabled(false);
                ExportAbstractDialog.this.csvDelimiterCombo.setEnabled(false);
                if (isBase) {
                    ExportAbstractDialog.this.includeFillersButton.setEnabled(false);
                    ExportAbstractDialog.this.includeRedefinesButton.setEnabled(false);
                }
                ExportAbstractDialog.this.includeLeadingBlanksButton.setEnabled(false);
                ExportAbstractDialog.this.includeTrailingBlanksButton.setEnabled(false);
                ExportAbstractDialog.this.encapsulateButton.setEnabled(false);
                ExportAbstractDialog.this.singleQuotesButton.setEnabled(false);
                ExportAbstractDialog.this.asisEncapsulationButton.setEnabled(false);
                ExportAbstractDialog.this.unmaskCharactersButton.setSelection(false);
                ExportAbstractDialog.this.unmaskCharactersButton.setEnabled(false);
            }
        });
        Group cvsGroup = GUI.group((Composite)parent, (String)Messages.ExportAbstractDialog_13, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.csvDelimiterLabel = GUI.label.left((Composite)cvsGroup, (String)Messages.ExportAbstractDialog_30, (Object)GUI.grid.d.left1());
        this.csvDelimiterCombo = GUI.combo.editable((Composite)cvsGroup, (Object)GUI.grid.d.fillH((int)1));
        this.csvDelimiterCombo.setToolTipText(Messages.ExportAbstractDialog_31);
        new ComboValueSaver(this.csvDelimiterCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "csvDelimiter");
        this.csvDelimiterCombo.select(0);
        this.csvDelimiterCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportAbstractDialog.this.setErrorMessage(null);
            }
        });
        this.csvDelimiterCombo.setText(",");
        this.printHeaderButton = GUI.button.checkbox((Composite)cvsGroup, (String)Messages.ExportAbstractDialog_6, (Object)GUI.grid.d.fillH((int)1));
        this.printHeaderButton.setToolTipText(Messages.ExportAbstractDialog_7);
        this.printHeaderButton.setSelection(true);
        if (isBase) {
            this.includeFillersButton = GUI.button.checkbox((Composite)cvsGroup, (String)Messages.ExportAbstractDialog_14, (Object)GUI.grid.d.fillH((int)1));
            this.includeFillersButton.setToolTipText(Messages.ExportAbstractDialog_15);
            this.includeFillersButton.setSelection(false);
            this.includeRedefinesButton = GUI.button.checkbox((Composite)cvsGroup, (String)Messages.ExportAbstractDialog_16, (Object)GUI.grid.d.fillH((int)1));
            this.includeRedefinesButton.setToolTipText(Messages.ExportAbstractDialog_17);
            this.includeRedefinesButton.setSelection(false);
        }
        this.includeLeadingBlanksButton = GUI.button.checkbox((Composite)cvsGroup, (String)Messages.ExportAbstractDialog_20, (Object)GUI.grid.d.fillH((int)1));
        this.includeLeadingBlanksButton.setToolTipText(Messages.ExportAbstractDialog_21);
        this.includeLeadingBlanksButton.setSelection(false);
        this.includeTrailingBlanksButton = GUI.button.checkbox((Composite)cvsGroup, (String)Messages.ExportAbstractDialog_22, (Object)GUI.grid.d.fillH((int)1));
        this.includeTrailingBlanksButton.setToolTipText(Messages.ExportAbstractDialog_23);
        this.includeTrailingBlanksButton.setSelection(false);
        this.encapsulateButton = GUI.button.checkbox((Composite)cvsGroup, (String)Messages.ExportAbstractDialog_26, (Object)GUI.grid.d.fillH((int)1));
        this.encapsulateButton.setToolTipText(Messages.ExportAbstractDialog_27);
        this.encapsulateButton.setSelection(false);
        this.singleQuotesButton = GUI.button.checkbox((Composite)cvsGroup, (String)Messages.ExportAbstractDialog_28, (Object)GUI.grid.d.fillH((int)1));
        this.singleQuotesButton.setToolTipText(Messages.ExportAbstractDialog_29);
        this.singleQuotesButton.setSelection(false);
        this.asisEncapsulationButton = GUI.button.checkbox((Composite)cvsGroup, (String)Messages.ExportAbstractDialog_18, (Object)GUI.grid.d.fillH((int)1));
        this.asisEncapsulationButton.setToolTipText(Messages.ExportAbstractDialog_19);
        this.asisEncapsulationButton.setSelection(false);
        this.unmaskCharactersButton = GUI.button.checkbox((Composite)cvsGroup, (String)Messages.ExportAbstractDialog_34, (Object)GUI.grid.d.fillH((int)1));
        this.unmaskCharactersButton.setToolTipText(Messages.ExportAbstractDialog_35);
        this.unmaskCharactersButton.setEnabled(false);
        this.unmaskCharactersButton.setSelection(false);
        this.formatLocationExtension();
    }

    private static String generateDefaultCSVPath() {
        String userHome = System.getProperty("user.home");
        if (userHome != null) {
            return userHome + File.separatorChar + Messages.ExportData_defaultExportFileName + Messages.ExportAbstractDialog_CSV;
        }
        return "";
    }

    private void formatLocationExtension() {
        String ext = this.csvOutputButton.getSelection() ? Messages.ExportAbstractDialog_CSV : Messages.ExportAbstractDialog_XML;
        String otherExt = this.csvOutputButton.getSelection() ? Messages.ExportAbstractDialog_XML : Messages.ExportAbstractDialog_CSV;
        String loc = this.outputFileCombo.getText();
        String locLowerCase = loc.trim().toLowerCase();
        if (!locLowerCase.endsWith(ext) && locLowerCase.endsWith(otherExt)) {
            this.outputFileCombo.setText(loc.substring(0, loc.length() - Messages.ExportAbstractDialog_CSV.length()) + ext);
        }
    }

    protected boolean validate(boolean isBase) {
        this.setErrorMessage(null);
        if (!this.validateOutputFile()) {
            return false;
        }
        if (this.csvOutputButton.getSelection()) {
            this.outputType = ExportOutputType.CSV;
            if (!this.validateDelimiter()) {
                return false;
            }
        } else {
            this.outputType = ExportOutputType.XML;
        }
        this.printHeader = this.printHeaderButton.getSelection();
        if (isBase) {
            this.includeFillers = this.includeFillersButton.getSelection();
            this.includeRedefines = this.includeRedefinesButton.getSelection();
        }
        this.asisEncapsulation = this.asisEncapsulationButton.getSelection();
        this.unmaskCharacters = this.unmaskCharactersButton.getSelection();
        this.includeLeadingBlanks = this.includeLeadingBlanksButton.getSelection();
        this.includeTrailingBlanks = this.includeTrailingBlanksButton.getSelection();
        this.encapsulate = this.encapsulateButton.getSelection();
        this.singleQuotes = this.singleQuotesButton.getSelection();
        return true;
    }

    protected boolean validInteger(String value) {
        try {
            int intValue = Integer.parseInt(value);
            return intValue > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean validateOutputFile() {
        this.outputFileName = "";
        Object value = this.outputFileCombo.getText().trim();
        if (((String)value).isEmpty()) {
            this.outputFileCombo.setFocus();
            this.setErrorMessage(Messages.ExportAbstractDialog_10);
            return false;
        }
        File outFile = new File((String)value);
        if (outFile.isDirectory()) {
            this.outputFileCombo.setFocus();
            this.setErrorMessage(Messages.ExportAbstractDialog_11);
            return false;
        }
        if (((String)value).indexOf(46) == -1) {
            value = this.csvOutputButton.getSelection() ? (String)value + ".csv" : (String)value + ".xml";
        }
        if (!ExportAbstractDialog.checkFileOverwrite((String)value)) {
            return false;
        }
        this.outputFileName = value;
        return true;
    }

    public static boolean checkFileOverwrite(String fileName) {
        File aFile = new File(fileName);
        return !aFile.exists() || PDDialogs.openQuestionThreadSafe((String)MessageFormat.format(Messages.ExportAbstractDialog_12, fileName));
    }

    private boolean validateDelimiter() {
        this.delimiter = ",";
        String value = this.csvDelimiterCombo.getText();
        if (value == null || value.isEmpty()) {
            this.csvDelimiterCombo.setFocus();
            this.setErrorMessage(Messages.ExportAbstractDialog_32);
            return false;
        }
        if (value.indexOf(39) >= 0 || value.indexOf(34) >= 0) {
            this.csvDelimiterCombo.setFocus();
            this.setErrorMessage(Messages.ExportAbstractDialog_33);
            return false;
        }
        this.delimiter = value;
        return true;
    }

    public ExportOutputType getExportType() {
        return this.outputType;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public boolean printHeader() {
        return this.printHeader;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public boolean includeFillers() {
        return this.includeFillers;
    }

    public boolean includeRedefines() {
        return this.includeRedefines;
    }

    public boolean includeLeadingBlanks() {
        return this.includeLeadingBlanks;
    }

    public boolean includeTrailingBlanks() {
        return this.includeTrailingBlanks;
    }

    public boolean encapsulate() {
        return this.encapsulate;
    }

    public boolean singleQuotes() {
        return this.singleQuotes;
    }

    public boolean asisEncapsulation() {
        return this.asisEncapsulation;
    }

    public boolean isUnmaskCharacters() {
        return this.unmaskCharacters;
    }

    public Export2DesktopData getExportData() {
        return new Export2DesktopData(this.getOutputFileName(), this.getExportType(), this.printHeader(), this.getDelimiter(), this.includeFillers(), this.includeRedefines(), this.includeLeadingBlanks(), this.includeTrailingBlanks(), this.encapsulate(), this.singleQuotes(), this.asisEncapsulation(), this.unmaskCharacters);
    }

    public static enum ExportOutputType {
        CSV,
        XML;

    }
}

