/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.Db2Database;
import com.ibm.etools.fm.core.model.db2.Db2Object;
import com.ibm.etools.fm.core.model.db2.Db2ObjectQuery;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.ui.dialog.lookup.Db2SubsystemLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.Db2TableLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.util.UIValidator;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import java.lang.reflect.Field;
import java.util.Objects;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class Db2ObjectQueryDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final boolean editing;
    private IPDHost host;
    private Db2ObjectQuery<?> query;
    private Db2Subsystem initialDb2Subsystem;
    private String initialOwnerPattern = "";
    private String initialNamePattern = "";
    private String initialDatabasePattern = "";
    private Class<? extends Db2Object> initialObjectType;
    private Combo wSubsystem;
    private Button wSubsystemLookup;
    private Combo wOwnerPattern;
    private Button wOwnerLookup;
    private Combo wNamePattern;
    private Button wNameLookup;
    private Combo wDatabasePattern;
    private Button wDatabaseLookup;
    private Button wTypeDatabase;
    private Button wTypeTable;

    public Db2ObjectQueryDialog(IPDHost system, boolean editing) {
        this.host = Objects.requireNonNull(system);
        this.editing = editing;
    }

    public Db2ObjectQuery<?> getQuery() {
        return this.query;
    }

    public void setQuery(Db2ObjectQuery<?> query) {
        this.host = query.getSystem();
        this.initialDb2Subsystem = query.getSubsystem();
        this.initialOwnerPattern = query.getOwnerPattern();
        this.initialNamePattern = query.getNamePattern();
        this.initialDatabasePattern = query.getDatabasePattern();
        this.initialObjectType = query.getType();
        this.query = query;
    }

    public void setInitialDb2Subsystem(Db2Subsystem initialDb2Subsystem) {
        this.initialDb2Subsystem = initialDb2Subsystem;
    }

    public void setInitialOwnerPattern(String initialOwnerPattern) {
        this.initialOwnerPattern = initialOwnerPattern;
    }

    public void setInitialNamePattern(String initialTable) {
        this.initialNamePattern = initialTable;
    }

    public void setInitialDatabasePattern(String initialDatabase) {
        this.initialDatabasePattern = initialDatabase;
    }

    public void setInitialObjectType(Class<? extends Db2Object> initialObjectType) {
        this.initialObjectType = initialObjectType;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.getDialogTitle());
        this.setMessage(Messages.Db2ObjectQueryDialog_DEFAULT_MESSAGE);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillAll());
        GUI.label.left((Composite)composite, (String)Messages.LABEL__DB2_SUBSYSTEM, (Object)GUI.grid.d.left1());
        this.wSubsystem = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        this.wSubsystem.addVerifyListener(UIValidator.FORCE_UPPERCASE);
        new ComboValueSaver(this.wSubsystem, ((Object)((Object)this)).getClass().getCanonicalName() + "Db2Subsystem");
        this.wSubsystemLookup = LookupButton.createLookupButtonLeft1(composite);
        this.wSubsystemLookup.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                Db2SubsystemLookupDialog lookup = new Db2SubsystemLookupDialog(Db2ObjectQueryDialog.this.host);
                if (lookup.open() == 0) {
                    if (!Db2ObjectQueryDialog.this.wSubsystem.isDisposed()) {
                        Db2ObjectQueryDialog.this.wSubsystem.setText(((Db2Subsystem)lookup.getFirstSelectedObject()).getName());
                    }
                    Db2ObjectQueryDialog.this.checkComplete();
                }
            }
        });
        Listener queryLookupListener = new Listener(){

            public void handleEvent(Event event) {
                Db2TableLookupDialog lookup = new Db2TableLookupDialog(new Db2Subsystem(Db2ObjectQueryDialog.this.host, Db2ObjectQueryDialog.this.wSubsystem.getText()));
                lookup.setInitialOwnerPattern(Db2ObjectQueryDialog.this.wOwnerPattern.getText());
                lookup.setInitialNamePattern(Db2ObjectQueryDialog.this.wNamePattern.getText());
                lookup.setInitialDatabasePattern(Db2ObjectQueryDialog.this.wDatabasePattern.getText());
                if (lookup.open() == 0) {
                    Db2Table selected = (Db2Table)lookup.getFirstSelectedObject();
                    Db2ObjectQueryDialog.this.wOwnerPattern.setText(selected.getOwner());
                    Db2ObjectQueryDialog.this.wNamePattern.setText(selected.getName());
                    Db2ObjectQueryDialog.this.wDatabasePattern.setText(selected.getDatabaseName());
                    Db2ObjectQueryDialog.this.checkComplete();
                }
            }
        };
        GUI.label.left((Composite)composite, (String)Messages.Db2ObjectQueryDialog_OWNER, (Object)GUI.grid.d.left1());
        this.wOwnerPattern = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wOwnerPattern, ((Object)((Object)this)).getClass().getCanonicalName() + "Owner");
        this.wOwnerLookup = LookupButton.createLookupButtonLeft1(composite);
        this.wOwnerLookup.addListener(13, queryLookupListener);
        GUI.label.left((Composite)composite, (String)Messages.Db2ObjectQueryDialog_NAME, (Object)GUI.grid.d.left1());
        this.wNamePattern = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wNamePattern, ((Object)((Object)this)).getClass().getCanonicalName() + "Name");
        this.wNameLookup = LookupButton.createLookupButtonLeft1(composite);
        this.wNameLookup.addListener(13, queryLookupListener);
        GUI.label.left((Composite)composite, (String)Messages.Db2ObjectQueryDialog_DATABASE, (Object)GUI.grid.d.left1());
        this.wDatabasePattern = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wDatabasePattern, ((Object)((Object)this)).getClass().getCanonicalName() + "Database");
        this.wDatabaseLookup = LookupButton.createLookupButtonLeft1(composite);
        this.wDatabaseLookup.addListener(13, queryLookupListener);
        Group typeGroup = GUI.group((Composite)composite, (String)Messages.Db2ObjectQueryDialog_OBJECT_TYPE, (Layout)GUI.grid.l.margins((int)3, (boolean)true), (Object)GUI.grid.d.fillH((int)3));
        this.wTypeDatabase = GUI.button.radio((Composite)typeGroup, (String)Messages.Db2ObjectQueryDialog_TYPE_DATABASE, (Object)GUI.grid.d.fillH((int)1));
        this.wTypeTable = GUI.button.radio((Composite)typeGroup, (String)Messages.Db2ObjectQueryDialog_TYPE_TABLE, (Object)GUI.grid.d.fillH((int)1));
        this.setInitialValues();
        Listener checkCompleteListener = new Listener(){

            public void handleEvent(Event event) {
                Db2ObjectQueryDialog.this.checkComplete();
            }
        };
        this.wSubsystem.addListener(24, checkCompleteListener);
        this.wOwnerPattern.addListener(24, checkCompleteListener);
        this.wNamePattern.addListener(24, checkCompleteListener);
        this.wDatabasePattern.addListener(24, checkCompleteListener);
        this.wTypeDatabase.addListener(13, checkCompleteListener);
        this.wTypeTable.addListener(13, checkCompleteListener);
        if (this.wSubsystem.getText().isEmpty()) {
            this.wSubsystem.setFocus();
        } else if (this.wOwnerPattern.getText().isEmpty()) {
            this.wOwnerPattern.setFocus();
        } else if (this.wNamePattern.getText().isEmpty()) {
            this.wNamePattern.setFocus();
        } else if (!this.wTypeDatabase.getSelection()) {
            this.wDatabasePattern.setFocus();
        } else {
            this.wNamePattern.setFocus();
        }
        this.checkComplete();
        this.setComplete(true);
        return composite;
    }

    private void setInitialValues() {
        if (this.initialDb2Subsystem != null) {
            this.wSubsystem.setText(this.initialDb2Subsystem.getName());
        }
        if (this.initialOwnerPattern != null) {
            this.wOwnerPattern.setText(this.initialOwnerPattern);
        }
        if (this.initialNamePattern != null) {
            this.wNamePattern.setText(this.initialNamePattern);
        }
        if (this.initialDatabasePattern != null) {
            this.wDatabasePattern.setText(this.initialDatabasePattern);
        }
        this.wTypeDatabase.setSelection(Db2Database.class.equals(this.initialObjectType));
        this.wTypeTable.setSelection(Db2Table.class.equals(this.initialObjectType));
        this.wDatabasePattern.setEnabled(Db2Database.class.equals(this.initialObjectType));
    }

    private void checkComplete() {
        this.setComplete(true);
    }

    protected void setComplete(boolean complete) {
        this.wDatabasePattern.setEnabled(!this.wTypeDatabase.getSelection());
        boolean tableSelected = this.wTypeTable.getSelection();
        if (complete) {
            complete = complete && Db2Subsystem.isValidName((IPDHost)this.host, (String)this.wSubsystem.getText());
            this.wOwnerLookup.setEnabled(complete && tableSelected);
            this.wNameLookup.setEnabled(complete && tableSelected);
            this.wDatabaseLookup.setEnabled(complete && tableSelected);
            if (!complete) {
                this.setErrorMessage(Messages.Db2ObjectQueryDialog_INVALID_SUBSYSTEM);
            }
        }
        if (complete) {
            boolean bl = complete = complete && Db2ObjectQuery.isValidOwnerPattern((String)this.wOwnerPattern.getText());
            if (!complete) {
                this.setErrorMessage(Messages.Db2ObjectQueryDialog_INVALID_OWNER);
            }
        }
        if (complete) {
            boolean bl = complete = complete && Db2ObjectQuery.isValidNamePattern((String)this.wNamePattern.getText());
            if (!complete) {
                this.setErrorMessage(Messages.Db2ObjectQueryDialog_INVALID_NAME);
            }
        }
        if (complete) {
            boolean bl = complete = complete && Db2ObjectQuery.isValidDatabasePattern((String)this.wDatabasePattern.getText());
            if (!complete) {
                this.setErrorMessage(Messages.Db2ObjectQueryDialog_INVALID_DATABASE);
            }
        }
        if (complete) {
            boolean bl = complete = complete && (this.wTypeDatabase.getSelection() || tableSelected);
            if (!complete) {
                this.setErrorMessage(Messages.Db2ObjectQueryDialog_CHOOSE_TYPE);
            }
        }
        if (complete) {
            if (this.wSubsystem != null && this.wDatabasePattern != null) {
                Db2Subsystem subsystem = new Db2Subsystem(this.host, this.wSubsystem.getText());
                if (this.wTypeDatabase.getSelection()) {
                    this.query = new Db2ObjectQuery(subsystem, Db2Database.class);
                } else if (this.wTypeTable.getSelection()) {
                    this.query = new Db2ObjectQuery(subsystem, Db2Table.class);
                    this.query.setDatabasePattern(this.wDatabasePattern.getText());
                }
                this.query.setOwnerPattern(this.wOwnerPattern.getText());
                this.query.setNamePattern(this.wNamePattern.getText());
            }
            this.setErrorMessage(null);
        }
        super.setComplete(complete);
    }

    private String getDialogTitle() {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        boolean isFilter = false;
        if (selection != null && selection.toString().contains(".rse.") && selection instanceof TreeSelection) {
            TreeSelection treeSelection = (TreeSelection)selection;
            Object object = treeSelection.getFirstElement();
            try {
                Field field = object.getClass().getSuperclass().getSuperclass().getDeclaredField("isNewFilterActionClicked");
                field.setAccessible(true);
                isFilter = (Boolean)field.get(object);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        String title = "";
        if (this.editing) {
            this.setTitle(Messages.Db2ObjectQueryDialog_TITLE_MODIFY);
        } else {
            title = isFilter ? Messages.NewDB2Filter : Messages.Db2ObjectQueryDialog_TITLE_ADD;
        }
        return title;
    }
}

