/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetQuery;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.util.UIValidator;
import com.ibm.etools.fm.ui.widget.TypeComposite;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class DataSetQueryDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private IPDHost host;
    private DataSetQuery query;
    private String initialQuery;
    private Combo wQuery;
    private TypeComposite<DataSetType> wTypes;
    private final boolean editing;

    public DataSetQueryDialog(IPDHost system, boolean editing) {
        this.host = Objects.requireNonNull(system);
        this.editing = editing;
    }

    public void setQuery(DataSetQuery query) {
        this.query = Objects.requireNonNull(query);
        this.host = query.getSystem();
    }

    public DataSetQuery getQuery() {
        return this.query;
    }

    public void setInitialQuery(String initialQuery) {
        this.initialQuery = initialQuery;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.editing ? Messages.DataSetQueryDialog_TITLE_EDITING : Messages.DataSetQueryDialog_TITLE_ADDING);
        this.setMessage(Messages.DataSetQueryDialog_MSG);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillAll());
        GUI.label.left((Composite)composite, (String)Messages.Label__QUERY, (Object)GUI.grid.d.left1());
        this.wQuery = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        this.wQuery.addVerifyListener(UIValidator.FORCE_UPPERCASE);
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1(composite), this.wQuery, (IHostProvider)this.host).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "Query").create();
        Group filterGroup = GUI.group((Composite)composite, (String)Messages.TYPE_FILTERING_OPTIONS, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)3));
        this.wTypes = new TypeComposite((Composite)filterGroup, 4, GUI.grid.d.fillAll(), DataSetType.STANDARD_VALUES);
        this.wTypes.setAllCheckboxLabel(Messages.DataSetTypeComposite_ALL_DATA_SET_TYPES);
        this.setInitialValues();
        this.wQuery.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                DataSetQueryDialog.this.setComplete(true);
            }
        });
        this.wTypes.addSelectionListener(new Listener(){

            public void handleEvent(Event event) {
                DataSetQueryDialog.this.setComplete(true);
            }
        });
        this.wQuery.setFocus();
        this.setComplete(true);
        return composite;
    }

    private void setInitialValues() {
        List standardValues = DataSetType.STANDARD_VALUES;
        if (this.query != null) {
            this.wQuery.setText(this.query.getQuery());
            List actualTypesFiltered = this.query.getTypesFiltered();
            this.wTypes.setSelectedTypes(actualTypesFiltered.isEmpty() ? standardValues : actualTypesFiltered);
        } else {
            this.wTypes.setSelectedTypes(standardValues);
        }
        if (this.initialQuery != null) {
            this.wQuery.setText(this.initialQuery);
        }
    }

    public boolean close() {
        boolean confirmed = true;
        if (this.getReturnCode() == 0 && this.query.isLikelyLongRunning()) {
            confirmed = PDDialogs.openQuestion((String)Messages.DataSetQueryDialog_WARNING, (String)Messages.DataSetQueryDialog_QUERY_MAY_TAKE_LONG_TIME);
        }
        return confirmed && super.close();
    }

    protected void setComplete(boolean complete) {
        List<DataSetType> selectedTypes = this.wTypes.getSelected();
        if (complete && !DataSetQuery.isValidQuery((String)this.wQuery.getText(), (String)this.host.getCodePage())) {
            complete = false;
            this.setErrorMessage(Messages.InvalidDataSetQuery);
        } else if (complete && selectedTypes.isEmpty()) {
            complete = false;
            this.setErrorMessage(Messages.DataSetQueryDialog_SPECIFY_MIN_1_DS_TYPE);
        } else if (complete) {
            if (this.wQuery != null && DataSetQuery.isValidQuery((String)this.wQuery.getText(), (String)this.host.getCodePage())) {
                this.query = DataSetQuery.create((IPDHost)this.host, (String)this.wQuery.getText());
                if (selectedTypes.size() == DataSetType.STANDARD_VALUES.size()) {
                    this.query.setTypesFiltered(new ArrayList());
                } else {
                    this.query.setTypesFiltered(selectedTypes);
                }
            }
            this.setErrorMessage(null);
        }
        super.setComplete(complete);
    }
}

