/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.CopybookPrintOptions;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.callback.IOnSelectionEvent;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.widget.SystemSelectionCombo;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.registery.RegistryLocator;
import java.util.HashSet;
import java.util.Objects;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CopybookPrintDialog
extends TitleAreaDialog
implements IHostProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2020. All rights reserved.";
    private PDLogger logger = PDLogger.get(CopybookPrintDialog.class);
    private String dialogTitle;
    private String dialogMsg;
    private CopybookPrintOptions options;
    private ComboViewer resourceNameComboViewer;
    private Button showArrayElementsButton;
    private Button showHexOffsetsButton;
    private Button showLengthInHexButton;
    private Button showTemplateCriteriaButton;

    public CopybookPrintDialog(Shell parentShell, IPDHost host, IZRL selectedResource) {
        super(parentShell);
        if (selectedResource != null && !host.equals(selectedResource.getSystem())) {
            throw new IllegalArgumentException();
        }
        this.options = new CopybookPrintOptions();
        this.options.setSystem(host);
        this.options.setResource(selectedResource);
        this.dialogTitle = Messages.CopybookPrintDialogTitle;
        this.dialogMsg = Messages.CopybookPrintDialogMessage;
        TrayDialog.setDialogHelpAvailable((boolean)false);
    }

    public CopybookPrintDialog(Shell parentShell, IPDHost host, CopybookPrintOptions opts) {
        this(parentShell, host, opts.getResource());
        this.options = opts;
        this.dialogTitle = Messages.CopybookPrintDialogTitle;
        this.dialogMsg = Messages.CopybookPrintDialogMessage;
        TrayDialog.setDialogHelpAvailable((boolean)false);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.dialogTitle);
        this.setTitle(this.dialogTitle);
        this.setMessage(this.dialogMsg);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.createResourceComposite(composite);
        this.createProcessingOptionsComposite(composite);
        this.updateUI();
        return composite;
    }

    private void createResourceComposite(Composite parent) {
        GridLayout margins = GUI.grid.l.margins((int)4, (boolean)false);
        margins.verticalSpacing = 0;
        margins.horizontalSpacing = 4;
        Group group = GUI.group((Composite)parent, (String)Messages.CopybookPrintDialogGroup, (Layout)margins, (Object)GUI.grid.d.fillAll());
        ComboViewer resourceSystemComboViewer = SystemSelectionCombo.createSystemLabelAndComboViewer((Composite)group, new HashSet<IPDHost>(RegistryLocator.instance().getHostRegistry().all()), this.options.getSystem());
        GUI.label.left((Composite)group, (String)"", (Object)GUI.grid.d.left1());
        resourceSystemComboViewer.getCombo().setEnabled(false);
        GUI.label.left((Composite)group, (String)"", (Object)GUI.grid.d.left1());
        GUI.label.left((Composite)group, (String)Messages.CopybookPrintDialogDataSetName, (Object)GUI.grid.d.left1());
        this.resourceNameComboViewer = CopybookPrintDialog.createComboViewer(GUI.combo.editable((Composite)group, (Object)GUI.grid.d.fillH((int)1)), Messages.EditorOptionDialog_RESOURCE_TIP, null, null, false, -1);
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)group), this.resourceNameComboViewer.getCombo(), (IHostProvider)this.getSystem()).types(ZRLs.getEditableResourceTypes((IPDHost)this.getSystem())).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                CopybookPrintDialog.this.options.setResource(zrl);
            }
        }).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "Resource").create();
        this.resourceNameComboViewer.getCombo().setText(this.options.getResource() != null ? this.options.getResource().getFormattedName() : "");
        this.resourceNameComboViewer.getCombo().setFocus();
    }

    private void createProcessingOptionsComposite(Composite parent) {
        GridLayout margins = GUI.grid.l.margins((int)2, (boolean)false);
        margins.verticalSpacing = 0;
        margins.horizontalSpacing = 4;
        Group group = GUI.group((Composite)parent, (String)Messages.CopybookPrintDialogProcessingOptions, (Layout)margins, (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)group, (String)Messages.CopybookPrintDialogShowArrayElements, (Object)GUI.grid.d.left1());
        this.showArrayElementsButton = GUI.button.checkbox((Composite)group, (String)"", (Object)GUI.grid.d.left1());
        this.showArrayElementsButton.setToolTipText(Messages.CopybookPrintDialogShowArrayElementsTooltip);
        GUI.label.left((Composite)group, (String)Messages.CopybookPrintDialogShowHexOffsets, (Object)GUI.grid.d.left1());
        this.showHexOffsetsButton = GUI.button.checkbox((Composite)group, (String)"", (Object)GUI.grid.d.left1());
        this.showHexOffsetsButton.setToolTipText(Messages.CopybookPrintDialogShowHexOffsetsTooltip);
        GUI.label.left((Composite)group, (String)Messages.CopybookPrintDialogShowLengthInHex, (Object)GUI.grid.d.left1());
        this.showLengthInHexButton = GUI.button.checkbox((Composite)group, (String)"", (Object)GUI.grid.d.left1());
        this.showLengthInHexButton.setToolTipText(Messages.CopybookPrintDialogShowLengthInHexTooltip);
        GUI.label.left((Composite)group, (String)Messages.CopybookPrintDialogShowTemplateCriteria, (Object)GUI.grid.d.left1());
        this.showTemplateCriteriaButton = GUI.button.checkbox((Composite)group, (String)"", (Object)GUI.grid.d.left1());
        this.showTemplateCriteriaButton.setToolTipText(Messages.CopybookPrintDialogShowTemplateCriteriaTooltip);
    }

    public void updateUI() {
        this.updateCheckButtonSelectionIfButtonNotNull(this.showArrayElementsButton, this.options.getShowArrayElements());
        this.updateCheckButtonSelectionIfButtonNotNull(this.showHexOffsetsButton, this.options.getShowHexOffsets());
        this.updateCheckButtonSelectionIfButtonNotNull(this.showLengthInHexButton, this.options.getShowLengthInHex());
        this.updateCheckButtonSelectionIfButtonNotNull(this.showTemplateCriteriaButton, this.options.getShowTemplateCriteria());
    }

    private void updateCheckButtonSelectionIfButtonNotNull(Button button2, boolean value) {
        if (button2 != null) {
            button2.setSelection(value);
            button2.notifyListeners(13, new Event());
        } else {
            this.logger.trace((Object)"Copybook Print: button is null.");
        }
    }

    private static ComboViewer createComboViewer(Combo combo2, String toolTip, String cvsId, String[] customItems, boolean customAtTop, int selectIndex) {
        Objects.requireNonNull(combo2, "Must provide a non-null parent combo.");
        ComboViewer cv = new ComboViewer(combo2);
        combo2.setToolTipText(toolTip);
        if (cvsId != null) {
            new ComboValueSaver(combo2, cvsId);
        }
        if (customItems != null) {
            ComboValueSaver.getInstance((Combo)combo2).setCustomItems(customItems, customAtTop);
        }
        if (selectIndex >= 0) {
            combo2.select(selectIndex);
        }
        return cv;
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonBar = GUI.composite((Composite)parent, (Layout)GUI.grid.l.customMargins((int)3, (boolean)false, (int)10, (int)15), (Object)new GridData(0x1000008, 4, true, true));
        this.createButtonsForButtonBar(buttonBar);
        return buttonBar;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridData data = new GridData();
        data.widthHint = 100;
        Button printButton = GUI.button.push((Composite)parent, (String)Messages.CopybookPrintButton, (Object)data, (String)Messages.CopybookPrintButtonTooltip);
        printButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                CopybookPrintDialog.this.handlePrintPressed();
            }
        });
        GUI.button.push((Composite)parent, (String)Messages.CopybookPrintCancelButton, (Object)data).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                CopybookPrintDialog.this.logger.trace((Object)"Cancel pressed.");
                CopybookPrintDialog.this.cancelPressed();
            }
        });
        this.getShell().setDefaultButton(printButton);
    }

    private void handlePrintPressed() {
        this.logger.trace((Object)"Print pressed.");
        this.validateAndClose();
    }

    private boolean validateAndClose() {
        if (!this.validateResourceName()) {
            return false;
        }
        if (!this.validateProcessingOptions()) {
            return false;
        }
        boolean isClose = this.close();
        this.logger.trace((Object)("isClose=" + isClose));
        return isClose;
    }

    private boolean validateResourceName() {
        if (this.resourceNameComboViewer.getCombo().getText().trim().isEmpty()) {
            this.setMessage(Messages.EditorOptionDialog_DSNERR_MSG, 3);
            this.resourceNameComboViewer.getCombo().setFocus();
            return false;
        }
        String value = this.resourceNameComboViewer.getCombo().getText();
        IPDHost host = this.options.getSystem();
        if (!ZRLs.isParseable((IPDHost)host, (String)value)) {
            this.setErrorMessage(Messages.EditorOptionDialog_DSNERR_MSG);
            this.resourceNameComboViewer.getCombo().setFocus();
            return false;
        }
        IZRL aZrl = ZRLs.parseZRL((IPDHost)host, (String)value);
        if (ZRLs.isSupportedResourceType((IPDHost)this.getSystem(), (IZRL)aZrl)) {
            this.options.setResource(aZrl);
            return true;
        }
        this.setErrorMessage(Messages.EditorOptionDialog_3);
        this.resourceNameComboViewer.getCombo().setFocus();
        return false;
    }

    public void setErrorMessage(String newErrorMessage) {
        if (!this.getShell().isDisposed()) {
            super.setErrorMessage(newErrorMessage);
        } else {
            this.logger.error((Throwable)new Exception("Attempted to set error message, when shell disposed: " + newErrorMessage));
        }
    }

    private boolean validateProcessingOptions() {
        this.options.setShowArrayElements(this.showArrayElementsButton.getSelection());
        this.options.setShowHexOffsets(this.showHexOffsetsButton.getSelection());
        this.options.setShowLengthInHex(this.showLengthInHexButton.getSelection());
        this.options.setShowTemplateCriteria(this.showTemplateCriteriaButton.getSelection());
        return true;
    }

    public IPDHost getSystem() {
        return this.options.getSystem();
    }

    public CopybookPrintOptions getCopybookPrintOptions() {
        return this.options;
    }
}

