/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.dialog;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.cics.CicsAppl;
import com.ibm.etools.fm.core.model.cics.CicsFile;
import com.ibm.etools.fm.core.model.cics.CicsFileQuery;
import com.ibm.etools.fm.core.model.cics.CicsResource;
import com.ibm.etools.fm.core.model.cics.CicsResourceQuery;
import com.ibm.etools.fm.core.model.cics.CicsTemporaryStorage;
import com.ibm.etools.fm.core.model.cics.CicsTemporaryStorageQuery;
import com.ibm.etools.fm.core.model.cics.CicsTransientData;
import com.ibm.etools.fm.core.model.cics.CicsTransientDataQuery;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.ResourceLookupDialog;
import com.ibm.etools.fm.ui.util.UIValidator;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.util.ArrayUtils;
import java.lang.reflect.Field;
import java.util.Objects;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class CicsResourceQueryDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final boolean editing;
    private IPDHost host;
    private CicsResourceQuery<? extends CicsResource> query;
    private CicsAppl initialCICSAppl;
    private CICS_RESOURCE_TYPE initialResourceType = CICS_RESOURCE_TYPE.CICS_FILE;
    private String initialQuery = "";
    private Combo wCICSApplID;
    private Button wCICSApplIDLookup;
    private Combo wResourceType;
    private Combo wQuery;
    private Button wQueryLookup;
    private Listener lookupListener = new Listener(){

        public void handleEvent(Event event) {
            ResourceLookupDialog lookup = new ResourceLookupDialog(CicsResourceQueryDialog.this.host, CicsAppl.class, CicsFile.class, CicsTransientData.class, CicsTemporaryStorage.class);
            CICS_RESOURCE_TYPE type = CICS_RESOURCE_TYPE.values()[CicsResourceQueryDialog.this.wResourceType.getSelectionIndex() < 0 ? 0 : CicsResourceQueryDialog.this.wResourceType.getSelectionIndex()];
            String initialFilter = type.getPrefix() + CicsResourceQueryDialog.this.wCICSApplID.getText();
            if (event.widget == CicsResourceQueryDialog.this.wQueryLookup && CicsResourceQueryDialog.this.wCICSApplID.getText().length() > 0) {
                initialFilter = initialFilter + ":" + CicsResourceQueryDialog.this.wQuery.getText();
            }
            lookup.setInitialFilter(initialFilter);
            if (lookup.open() == 0) {
                IZRL resource = lookup.getSelectedResource();
                if (resource instanceof CicsResource) {
                    CicsResourceQueryDialog.this.wCICSApplID.setText(((CicsResource)resource).getCICSAppl().getName());
                    CicsResourceQueryDialog.this.wResourceType.select(ArrayUtils.findIndexOf((Object)((Object)CICS_RESOURCE_TYPE.fromResourceOrQuery(resource)), (Object[])CICS_RESOURCE_TYPE.values(), (int)0));
                    CicsResourceQueryDialog.this.wQuery.setText(resource.getName());
                } else if (resource instanceof CicsAppl) {
                    CicsResourceQueryDialog.this.wCICSApplID.setText(resource.getName());
                    CicsResourceQueryDialog.this.wQuery.setText("*");
                }
            }
        }
    };

    public CicsResourceQueryDialog(IPDHost system, boolean editing) {
        this.host = Objects.requireNonNull(system, "Must provide a non-null system");
        this.editing = editing;
    }

    public CicsResourceQuery<? extends CicsResource> getQuery() {
        return this.query;
    }

    public void setQuery(CicsResourceQuery<? extends CicsResource> query) {
        this.host = query.getSystem();
        this.initialCICSAppl = query.getCICSAppl();
        this.initialResourceType = CICS_RESOURCE_TYPE.fromResourceOrQuery(query);
        this.initialQuery = query.getQuery();
        this.query = query;
    }

    public void setInitialCICSAppl(CicsAppl initialCICSAppl) {
        this.initialCICSAppl = initialCICSAppl;
    }

    public CicsAppl getInitialCICSAppl() {
        return this.initialCICSAppl;
    }

    public void setInitialResourceType(CICS_RESOURCE_TYPE initialResourceType) {
        this.initialResourceType = initialResourceType;
    }

    public void setInitialQuery(String initialQuery) {
        this.initialQuery = initialQuery;
    }

    protected Control createDialogArea(Composite parent) {
        String title = this.getDialogTitle();
        this.setTitle(title);
        this.setMessage(Messages.CICS_RESOURCE_DIALOG_MESSAGE);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillAll());
        GUI.label.left((Composite)composite, (String)Messages.CICS_SYSTEM_LABEL, (Object)GUI.grid.d.left1());
        this.wCICSApplID = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        this.wCICSApplID.addVerifyListener(UIValidator.FORCE_UPPERCASE);
        new ComboValueSaver(this.wCICSApplID, ((Object)((Object)this)).getClass().getCanonicalName() + "CICSApplID");
        this.wCICSApplIDLookup = LookupButton.createLookupButtonLeft1(composite);
        this.wCICSApplIDLookup.addListener(13, this.lookupListener);
        GUI.label.left((Composite)composite, (String)Messages.CICSResourceQueryDialog_RESOURCE, (Object)GUI.grid.d.left1());
        this.wResourceType = GUI.combo.readOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1), (Object[])CICS_RESOURCE_TYPE.values());
        GUI.grid.padding((Composite)composite, (int)1);
        GUI.label.left((Composite)composite, (String)Messages.Label__QUERY, (Object)GUI.grid.d.left1());
        this.wQuery = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wQuery, ((Object)((Object)this)).getClass().getCanonicalName() + "Query");
        this.wQueryLookup = LookupButton.createLookupButtonLeft1(composite);
        this.wQueryLookup.addListener(13, this.lookupListener);
        this.setInitialValues();
        Listener checkCompleteListener = new Listener(){

            public void handleEvent(Event event) {
                CicsResourceQueryDialog.this.checkComplete();
            }
        };
        this.wCICSApplID.addListener(24, checkCompleteListener);
        this.wResourceType.addListener(24, checkCompleteListener);
        this.wQuery.addListener(24, checkCompleteListener);
        if (this.wCICSApplID.getText().isEmpty()) {
            this.wCICSApplID.setFocus();
        } else {
            this.wQuery.setFocus();
        }
        this.checkComplete();
        this.setComplete(true);
        return composite;
    }

    private String getDialogTitle() {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        boolean isFilter = false;
        if (selection != null && selection.toString().contains(".rse.") && selection instanceof TreeSelection) {
            TreeSelection treeSelection = (TreeSelection)selection;
            Object object = treeSelection.getFirstElement();
            try {
                Field field = object.getClass().getSuperclass().getSuperclass().getDeclaredField("isNewFilterActionClicked");
                field.setAccessible(true);
                isFilter = (Boolean)field.get(object);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        String title = "";
        title = this.editing ? Messages.CICS_RESOURCE_EDIT_QUERY : (isFilter ? Messages.NewCICSFilter : Messages.CICS_RESOURCE_ADD_QUERY);
        return title;
    }

    private void setInitialValues() {
        if (this.initialCICSAppl != null) {
            this.wCICSApplID.setText(this.initialCICSAppl.getName());
        }
        this.wResourceType.select(ArrayUtils.findIndexOf((Object)((Object)this.initialResourceType), (Object[])CICS_RESOURCE_TYPE.values(), (int)0));
        if (this.initialQuery != null) {
            this.wQuery.setText(this.initialQuery);
        }
    }

    private void checkComplete() {
        this.setComplete(true);
    }

    protected void setComplete(boolean complete) {
        if (complete) {
            complete = complete && CicsAppl.isValidName((String)this.wCICSApplID.getText(), (String)this.host.getCodePage());
            this.wQueryLookup.setEnabled(complete);
            if (!complete) {
                this.setErrorMessage(Messages.CICS_RESOURCE_DIALOG_INVALID_APPLID);
            }
        }
        if (complete) {
            boolean bl = complete = complete && this.wResourceType.getSelectionIndex() >= 0;
            if (!complete) {
                this.setErrorMessage(Messages.CICSResourceQueryDialog_SELECT_RESOURCE);
            }
        }
        if (complete) {
            CicsAppl tempAppl = this.getInitialCICSAppl();
            if (tempAppl == null) {
                tempAppl = CicsAppl.create((IPDHost)this.host, (String)this.wCICSApplID.getText());
            }
            boolean bl = complete = complete && CICS_RESOURCE_TYPE.values()[this.wResourceType.getSelectionIndex()].isValidQuery(tempAppl, this.wQuery.getText());
            if (!complete) {
                this.setErrorMessage(Messages.CICS_RESOURCE_DIALOG_INVALID_QUERRY_MESSAGE);
            }
        }
        if (complete) {
            if (this.wCICSApplID != null && this.wResourceType != null && this.wQuery != null) {
                CICS_RESOURCE_TYPE type = CICS_RESOURCE_TYPE.values()[this.wResourceType.getSelectionIndex()];
                CicsAppl cicsAppl = CicsAppl.create((IPDHost)this.host, (String)this.wCICSApplID.getText());
                this.query = type.createQuery(cicsAppl, this.wQuery.getText());
            }
            this.setErrorMessage(null);
        }
        super.setComplete(complete);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum CICS_RESOURCE_TYPE {
        CICS_FILE{

            public String toString() {
                return Messages.CICSResourceQueryDialog_CICS_FILE;
            }

            @Override
            protected String getPrefix() {
                return "FI:";
            }

            @Override
            public boolean isValidQuery(CicsAppl cicsAppl, String query) {
                return CicsFileQuery.isValidQuery((CicsAppl)cicsAppl, (String)query);
            }

            public CicsFileQuery createQuery(CicsAppl cicsSystem, String query) {
                return CicsFileQuery.create((CicsAppl)cicsSystem, (String)query);
            }
        }
        ,
        CICS_TD{

            public String toString() {
                return Messages.CICSResourceQueryDialog_CICS_TD;
            }

            @Override
            protected String getPrefix() {
                return "TD:";
            }

            @Override
            public boolean isValidQuery(CicsAppl cicsAppl, String query) {
                return CicsTransientDataQuery.isValidQuery((IPDHost)cicsAppl.getSystem(), (String)query);
            }

            public CicsTransientDataQuery createQuery(CicsAppl cicsSystem, String query) {
                return CicsTransientDataQuery.create((CicsAppl)cicsSystem, (String)query);
            }
        }
        ,
        CICS_TS{

            public String toString() {
                return Messages.CICSResourceQueryDialog_CICS_TS;
            }

            @Override
            protected String getPrefix() {
                return "TS:";
            }

            @Override
            public boolean isValidQuery(CicsAppl cicsAppl, String query) {
                return CicsTemporaryStorageQuery.isValidQuery((String)query);
            }

            public CicsTemporaryStorageQuery createQuery(CicsAppl cicsSystem, String query) {
                return CicsTemporaryStorageQuery.create((CicsAppl)cicsSystem, (String)query);
            }
        };


        public static CICS_RESOURCE_TYPE fromResourceOrQuery(Object item) {
            Objects.requireNonNull(item, "Must provide a non-null item.");
            if (item instanceof CicsFile || item instanceof CicsFileQuery) {
                return CICS_FILE;
            }
            if (item instanceof CicsTransientData || item instanceof CicsTransientDataQuery) {
                return CICS_TD;
            }
            if (item instanceof CicsTemporaryStorage || item instanceof CicsTemporaryStorageQuery) {
                return CICS_TS;
            }
            logger.debug((Object)("CICS_RESOURCE_TYPE cannot convert: " + item.getClass().getCanonicalName()));
            return null;
        }

        public abstract CicsResourceQuery<? extends CicsResource> createQuery(CicsAppl var1, String var2);

        protected abstract String getPrefix();

        public abstract boolean isValidQuery(CicsAppl var1, String var2);
    }
}

