/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.console;

import com.ibm.pdtools.common.component.core.util.GUI;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;

public class StringSelectionDialog
extends FilteredItemsSelectionDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private Comparator<?> comparator = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    };
    private List<String> items;
    private final IDialogSettings dialogSettings;
    private Text itemPreview;

    protected StringSelectionDialog(IDialogSettings settings) {
        super(Display.getDefault().getActiveShell());
        this.dialogSettings = Objects.requireNonNull(settings, "Must provide a non-null settings");
        this.setDetailsLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element == null) {
                    return "";
                }
                Object str = element.toString();
                int newLinePos = ((String)str).indexOf("\r\n");
                if (newLinePos != -1) {
                    str = ((String)str).substring(0, newLinePos) + "...";
                }
                return str;
            }
        });
    }

    public void setItems(List<String> items) {
        this.items = items;
    }

    protected Control createExtendedContentArea(Composite parent) {
        GridData ld = GUI.grid.d.fillH((int)1);
        ld.heightHint = 100;
        this.itemPreview = GUI.text.areaReadOnly((Composite)parent, (Object)ld);
        return parent;
    }

    protected void handleSelected(StructuredSelection selection) {
        super.handleSelected(selection);
        Object firstElement = this.getSelectedItems().getFirstElement();
        this.itemPreview.setText(firstElement == null ? "" : firstElement.toString());
    }

    protected IDialogSettings getDialogSettings() {
        return this.dialogSettings;
    }

    protected IStatus validateItem(Object item) {
        return new Status(0, "com.ibm.etools.fm.ui", item.toString());
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new StringItemsFilter();
    }

    protected Comparator<?> getItemsComparator() {
        return this.comparator;
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        for (String item : this.items) {
            contentProvider.add((Object)item, itemsFilter);
            progressMonitor.worked(1);
        }
        progressMonitor.done();
    }

    public String getElementName(Object item) {
        return item.toString();
    }

    private class StringItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        public StringItemsFilter() {
            super((FilteredItemsSelectionDialog)StringSelectionDialog.this, new SearchPattern(3));
        }

        public boolean matchItem(Object item) {
            Object pattern = this.patternMatcher.getPattern();
            if (((String)pattern).indexOf("*") != 0 & ((String)pattern).indexOf("?") != 0 & ((String)pattern).indexOf(".") != 0) {
                pattern = "*" + (String)pattern;
                this.patternMatcher.setPattern((String)pattern);
            }
            return this.patternMatcher.matches(item.toString());
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }
    }
}

