/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.console;

import com.ibm.etools.fm.ui.console.FmIOConsoleOutputStream;
import com.ibm.etools.fm.ui.console.FmIOConsolePartition;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;

public final class PartitionStreamTokenScanner
implements ITokenScanner {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(PartitionStreamTokenScanner.class);
    private Map<FmIOConsoleOutputStream, IToken> streamTokens = new HashMap<FmIOConsoleOutputStream, IToken>();
    private IDocument document;
    private int regionOffset;
    private int regionLength;
    private ITypedRegion partition;
    private int tokenOffset;
    private int tokenLength;

    public void setStreamTokenData(FmIOConsoleOutputStream stream, Object data) {
        this.streamTokens.put(Objects.requireNonNull(stream, "Must provide a non-null stream"), (IToken)new Token(Objects.requireNonNull(data, "Must provide a non-null data")));
    }

    public void setRange(IDocument document, int offset, int length) {
        this.document = document;
        this.regionOffset = offset;
        this.regionLength = length;
        this.partition = null;
        this.tokenOffset = 0;
        this.tokenLength = 0;
    }

    public IToken nextToken() {
        FmIOConsolePartition fmPartition;
        IToken token;
        if (this.tokenOffset + this.tokenLength >= this.regionOffset + this.regionLength) {
            this.tokenOffset = this.regionOffset + this.regionLength;
            this.tokenLength = 0;
            return Token.EOF;
        }
        try {
            this.partition = this.document.getPartition(this.partition == null ? this.regionOffset : this.partition.getOffset() + this.partition.getLength());
        }
        catch (BadLocationException e) {
            logger.error((Throwable)e);
            return Token.EOF;
        }
        this.tokenOffset = this.partition.getOffset();
        this.tokenLength = this.partition.getLength();
        if (this.partition instanceof FmIOConsolePartition && (token = this.streamTokens.get((fmPartition = (FmIOConsolePartition)this.partition).getStream())) != null) {
            return token;
        }
        return new Token(null);
    }

    public int getTokenOffset() {
        return this.tokenOffset;
    }

    public int getTokenLength() {
        return this.tokenLength;
    }
}

