/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.console;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;

public class FmIOConsoleViewer
extends TextConsoleViewer {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private boolean fAutoScroll = true;
    private IDocumentListener fDocumentListener;

    public FmIOConsoleViewer(Composite parent, TextConsole console) {
        super(parent, console);
    }

    public boolean isAutoScroll() {
        return this.fAutoScroll;
    }

    public void setAutoScroll(boolean scroll) {
        this.fAutoScroll = scroll;
    }

    protected void handleVerifyEvent(VerifyEvent e) {
        block11: {
            IDocument doc = this.getDocument();
            String[] legalLineDelimiters = doc.getLegalLineDelimiters();
            String eventString = e.text;
            try {
                int length;
                IConsoleDocumentPartitioner partitioner = (IConsoleDocumentPartitioner)doc.getDocumentPartitioner();
                if (!partitioner.isReadOnly(e.start)) {
                    boolean isCarriageReturn = false;
                    int i = 0;
                    while (i < legalLineDelimiters.length) {
                        if (e.text.equals(legalLineDelimiters[i])) {
                            isCarriageReturn = true;
                            break;
                        }
                        ++i;
                    }
                    if (!isCarriageReturn) {
                        super.handleVerifyEvent(e);
                        return;
                    }
                }
                if (e.start == (length = doc.getLength())) {
                    super.handleVerifyEvent(e);
                    break block11;
                }
                try {
                    doc.replace(length, 0, eventString);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                e.doit = false;
            }
            finally {
                StyledText text2 = (StyledText)e.widget;
                text2.setCaretOffset(text2.getCharCount());
            }
        }
    }

    public void setReadOnly() {
        ConsolePlugin.getStandardDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                StyledText text2 = FmIOConsoleViewer.this.getTextWidget();
                if (text2 != null && !text2.isDisposed()) {
                    text2.setEditable(false);
                }
            }
        });
    }

    public boolean isReadOnly() {
        return !this.getTextWidget().getEditable();
    }

    public void setDocument(IDocument document) {
        IDocument oldDocument = this.getDocument();
        super.setDocument(document);
        if (oldDocument != null) {
            oldDocument.removeDocumentListener(this.getDocumentListener());
        }
        if (document != null) {
            document.addDocumentListener(this.getDocumentListener());
        }
    }

    private IDocumentListener getDocumentListener() {
        if (this.fDocumentListener == null) {
            this.fDocumentListener = new IDocumentListener(){

                public void documentAboutToBeChanged(DocumentEvent event) {
                }

                public void documentChanged(DocumentEvent event) {
                    if (FmIOConsoleViewer.this.fAutoScroll) {
                        FmIOConsoleViewer.this.revealEndOfDocument();
                    }
                }
            };
        }
        return this.fDocumentListener;
    }
}

