/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.console;

import com.ibm.etools.fm.ui.console.FmIOConsoleViewer;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsolePage;
import org.eclipse.ui.console.TextConsoleViewer;

public class FmIOConsolePage
extends TextConsolePage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private boolean fReadOnly;
    private IPropertyChangeListener fPropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if (property.equals(IConsoleConstants.P_CONSOLE_OUTPUT_COMPLETE)) {
                FmIOConsolePage.this.setReadOnly();
            }
        }
    };

    public FmIOConsolePage(TextConsole console, IConsoleView view2) {
        super(console, view2);
        console.addPropertyChangeListener(this.fPropertyChangeListener);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        if (this.fReadOnly) {
            FmIOConsoleViewer viewer = (FmIOConsoleViewer)this.getViewer();
            viewer.setReadOnly();
        }
    }

    protected TextConsoleViewer createViewer(Composite parent) {
        return new FmIOConsoleViewer(parent, (TextConsole)this.getConsole());
    }

    public void setAutoScroll(boolean scroll) {
        FmIOConsoleViewer viewer = (FmIOConsoleViewer)this.getViewer();
        if (viewer != null) {
            viewer.setAutoScroll(scroll);
        }
    }

    public void setReadOnly() {
        this.fReadOnly = true;
        FmIOConsoleViewer viewer = (FmIOConsoleViewer)this.getViewer();
        if (viewer != null) {
            viewer.setReadOnly();
        }
    }

    protected void contextMenuAboutToShow(IMenuManager menuManager) {
        super.contextMenuAboutToShow(menuManager);
        FmIOConsoleViewer viewer = (FmIOConsoleViewer)this.getViewer();
        if (!viewer.isReadOnly()) {
            menuManager.remove(ActionFactory.CUT.getId());
            menuManager.remove(ActionFactory.PASTE.getId());
        }
    }

    public void dispose() {
        this.getConsole().removePropertyChangeListener(this.fPropertyChangeListener);
        super.dispose();
    }
}

