/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.console;

import com.ibm.etools.fm.ui.console.FmIOConsole;
import com.ibm.etools.fm.ui.console.FmIOConsolePartitioner;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleConstants;

public class FmIOConsoleOutputStream
extends OutputStream {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private boolean closed = false;
    private FmIOConsolePartitioner partitioner;
    private FmIOConsole console;
    private boolean activateOnWrite = false;
    private Color color;
    private int fontStyle;
    private String fEncoding;
    private String fDefaultEncoding = WorkbenchEncoding.getWorkbenchDefaultEncoding();
    private boolean fNeedsEncoding = false;
    private boolean prependCR;

    FmIOConsoleOutputStream(FmIOConsole console) {
        this.console = console;
        this.partitioner = (FmIOConsolePartitioner)console.getPartitioner();
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(int newFontStyle) {
        if (newFontStyle != this.fontStyle) {
            int old = this.fontStyle;
            this.fontStyle = newFontStyle;
            this.console.firePropertyChange(this, IConsoleConstants.P_FONT_STYLE, old, this.fontStyle);
        }
    }

    public boolean isActivateOnWrite() {
        return this.activateOnWrite;
    }

    public void setActivateOnWrite(boolean activateOnWrite) {
        this.activateOnWrite = activateOnWrite;
    }

    public void setColor(Color newColor) {
        Color old = this.color;
        if (old == null || !old.equals((Object)newColor)) {
            this.color = newColor;
            this.console.firePropertyChange(this, IConsoleConstants.P_STREAM_COLOR, old, newColor);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            throw new IOException("Output Stream is closed");
        }
        if (this.prependCR) {
            this.prependCR = false;
            this.notifyParitioner("\r");
        }
        this.console.streamClosed(this);
        this.closed = true;
        this.partitioner = null;
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Output Stream is closed");
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.fNeedsEncoding) {
            this.encodedWrite(new String(b, off, len, this.fEncoding));
        } else {
            this.encodedWrite(new String(b, off, len));
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    public synchronized void write(String str) throws IOException {
        if (this.fNeedsEncoding) {
            byte[] defaultBytes = str.getBytes();
            str = new String(defaultBytes, this.fEncoding);
        }
        this.encodedWrite(str);
    }

    private void encodedWrite(String encodedString) throws IOException {
        if (this.closed) {
            throw new IOException("Output Stream is closed");
        }
        if (this.prependCR) {
            encodedString = "\r" + (String)encodedString;
            this.prependCR = false;
        }
        if (((String)encodedString).endsWith("\r")) {
            this.prependCR = true;
            encodedString = ((String)encodedString).substring(0, ((String)encodedString).length() - 1);
        }
        this.notifyParitioner((String)encodedString);
    }

    private void notifyParitioner(String encodedString) throws IOException {
        try {
            this.partitioner.streamAppended(this, encodedString);
            if (this.activateOnWrite) {
                this.console.activate();
            } else {
                ConsolePlugin.getDefault().getConsoleManager().warnOfContentChange((IConsole)this.console);
            }
        }
        catch (IOException e) {
            if (!this.closed) {
                this.close();
            }
            throw e;
        }
    }

    public void setEncoding(String encoding) {
        this.fEncoding = encoding;
        this.fNeedsEncoding = this.fEncoding != null && !this.fEncoding.equals(this.fDefaultEncoding);
    }
}

