/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.console;

import com.ibm.etools.fm.ui.console.FmIOConsoleInputStream;
import com.ibm.etools.fm.ui.console.FmIOConsoleOutputStream;
import com.ibm.etools.fm.ui.console.FmIOConsolePage;
import com.ibm.etools.fm.ui.console.FmIOConsolePartitioner;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.part.IPageBookViewPage;

public class FmIOConsole
extends TextConsole {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(FmIOConsole.class);
    private FmIOConsolePartitioner partitioner;
    private FmIOConsoleInputStream inputStream;
    private List<Closeable> openStreams;
    private String fEncoding = WorkbenchEncoding.getWorkbenchDefaultEncoding();

    public FmIOConsole(String name, String consoleType, ImageDescriptor imageDescriptor, boolean autoLifecycle) {
        this(name, consoleType, imageDescriptor, null, autoLifecycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FmIOConsole(String name, String consoleType, ImageDescriptor imageDescriptor, String encoding, boolean autoLifecycle) {
        super(name, consoleType, imageDescriptor, autoLifecycle);
        if (encoding != null) {
            this.fEncoding = encoding;
        }
        this.openStreams = new ArrayList<Closeable>();
        this.inputStream = new FmIOConsoleInputStream(this);
        List<Closeable> list = this.openStreams;
        synchronized (list) {
            this.openStreams.add(this.inputStream);
        }
        this.partitioner = new FmIOConsolePartitioner(this.inputStream, this);
        this.partitioner.connect(this.getDocument());
    }

    public FmIOConsole(String name, String consoleType, ImageDescriptor imageDescriptor) {
        this(name, consoleType, imageDescriptor, true);
    }

    public FmIOConsole(String name, ImageDescriptor imageDescriptor) {
        this(name, null, imageDescriptor);
    }

    public IPageBookViewPage createPage(IConsoleView view2) {
        return new FmIOConsolePage(this, view2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FmIOConsoleOutputStream newOutputStream() {
        FmIOConsoleOutputStream outputStream = new FmIOConsoleOutputStream(this);
        outputStream.setEncoding(this.fEncoding);
        List<Closeable> list = this.openStreams;
        synchronized (list) {
            this.openStreams.add(outputStream);
        }
        return outputStream;
    }

    public FmIOConsoleInputStream getInputStream() {
        return this.inputStream;
    }

    protected IConsoleDocumentPartitioner getPartitioner() {
        return this.partitioner;
    }

    public int getHighWaterMark() {
        return this.partitioner.getHighWaterMark();
    }

    public int getLowWaterMark() {
        return this.partitioner.getLowWaterMark();
    }

    public void setWaterMarks(int low, int high) {
        if (low >= 0 && low >= high) {
            throw new IllegalArgumentException("High water mark must be greater than low water mark");
        }
        this.partitioner.setWaterMarks(low, high);
    }

    private void checkFinished() {
        if (this.openStreams.isEmpty()) {
            this.partitioner.streamsClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamClosed(FmIOConsoleOutputStream stream) {
        List<Closeable> list = this.openStreams;
        synchronized (list) {
            this.openStreams.remove(stream);
            this.checkFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamClosed(FmIOConsoleInputStream stream) {
        List<Closeable> list = this.openStreams;
        synchronized (list) {
            this.openStreams.remove(stream);
            this.checkFinished();
        }
    }

    public void clearConsole() {
        if (this.partitioner != null) {
            this.partitioner.clearBuffer();
        }
    }

    protected void dispose() {
        super.dispose();
        this.partitioner.disconnect();
        Object[] allStreams = this.openStreams.toArray();
        int i = 0;
        while (i < allStreams.length) {
            Object stream = allStreams[i];
            if (stream instanceof FmIOConsoleInputStream) {
                FmIOConsoleInputStream is = (FmIOConsoleInputStream)stream;
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            } else if (stream instanceof FmIOConsoleOutputStream) {
                FmIOConsoleOutputStream os = (FmIOConsoleOutputStream)stream;
                try {
                    os.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++i;
        }
        this.inputStream = null;
    }

    public String getEncoding() {
        return this.fEncoding;
    }
}

