/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.console;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;

public class FmBrowserInformationControl
extends AbstractInformationControl
implements IInformationControlExtension2 {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(FmBrowserInformationControl.class);
    private static boolean fgIsAvailable = false;
    private static boolean fgAvailabilityChecked = false;
    private static Point fgScrollBarSize;
    private Browser fBrowser;
    private boolean fBrowserHasContent;
    private TextLayout fTextLayout;
    private boolean fCompleted = false;
    private final String fSymbolicFontName;

    private static boolean isAvailable(Composite parent) {
        if (!fgAvailabilityChecked) {
            try {
                try {
                    Browser browser = new Browser(parent, 0);
                    browser.dispose();
                    fgIsAvailable = true;
                    Slider sliderV = new Slider(parent, 512);
                    Slider sliderH = new Slider(parent, 256);
                    int width = sliderV.computeSize((int)-1, (int)-1).x;
                    int height = sliderH.computeSize((int)-1, (int)-1).y;
                    fgScrollBarSize = new Point(width, height);
                    sliderV.dispose();
                    sliderH.dispose();
                }
                catch (SWTError er) {
                    logger.error((Object)"Browser is not available", (Throwable)er);
                    fgIsAvailable = false;
                    fgAvailabilityChecked = true;
                }
            }
            finally {
                fgAvailabilityChecked = true;
            }
        }
        return fgIsAvailable;
    }

    public FmBrowserInformationControl(Shell parent, String symbolicFontName, boolean resizable) {
        super(parent, resizable);
        this.fSymbolicFontName = symbolicFontName;
        this.create();
    }

    public FmBrowserInformationControl(Shell parent, String symbolicFontName, String statusFieldText) {
        super(parent, statusFieldText);
        this.fSymbolicFontName = symbolicFontName;
        this.create();
    }

    protected void createContent(Composite parent) {
        if (!FmBrowserInformationControl.isAvailable(parent)) {
            return;
        }
        this.fBrowser = new Browser(parent, 0);
        this.fBrowser.setJavascriptEnabled(false);
        Display display = this.getShell().getDisplay();
        this.fBrowser.setForeground(display.getSystemColor(28));
        this.fBrowser.setBackground(display.getSystemColor(29));
        this.fBrowser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                if (!"about:blank".equals(event.location)) {
                    try {
                        logger.trace((Object)("Opening browser to " + event.location));
                        IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser(42, null, "Browser", "");
                        browser.openURL(new URL(event.location));
                        event.doit = false;
                    }
                    catch (PartInitException e) {
                        logger.error((Throwable)e);
                    }
                    catch (MalformedURLException e) {
                        logger.error((Throwable)e);
                    }
                }
            }

            public void changed(LocationEvent event) {
            }
        });
        this.fBrowser.addProgressListener((ProgressListener)new ProgressAdapter(){

            public void completed(ProgressEvent event) {
                FmBrowserInformationControl.this.fCompleted = true;
            }
        });
        this.fBrowser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                event.required = true;
            }
        });
        this.fBrowser.setMenu(new Menu((Decorations)this.getShell(), 0));
        this.createTextLayout();
    }

    public static void insertStyles(StringBuffer buffer, String[] styles) {
        if (styles == null || styles.length == 0) {
            return;
        }
        StringBuffer styleBuf = new StringBuffer(10 * styles.length);
        int i = 0;
        while (i < styles.length) {
            styleBuf.append(" style=\"");
            styleBuf.append(styles[i]);
            styleBuf.append('\"');
            ++i;
        }
        int index = buffer.indexOf("<body ");
        if (index != -1) {
            buffer.insert(index + 5, styleBuf);
            return;
        }
        index = buffer.indexOf("<body>");
        if (index != -1) {
            buffer.insert(index + 5, ' ');
            buffer.insert(index + 6, styleBuf);
            return;
        }
    }

    public void setInformation(String content) {
        boolean bl = this.fBrowserHasContent = content != null && content.length() > 0;
        if (!this.fBrowserHasContent) {
            content = "<html><body ></html>";
        }
        boolean RTL = (this.getShell().getStyle() & 0x4000000) != 0;
        boolean resizable = this.isResizable();
        String[] styles = null;
        styles = RTL && resizable ? new String[]{"direction:rtl;", "overflow:scroll;", "word-wrap:break-word;"} : (RTL && !resizable ? new String[]{"direction:rtl;", "overflow:hidden;", "word-wrap:break-word;"} : (!resizable ? new String[]{"overflow:hidden;"} : new String[]{"overflow:scroll;"}));
        StringBuffer buffer = new StringBuffer(content);
        FmBrowserInformationControl.insertStyles(buffer, styles);
        content = buffer.toString();
        this.fCompleted = false;
        this.fBrowser.setText(content);
    }

    public void setInput(Object input) {
        this.setInformation(input == null ? null : input.toString());
    }

    public void setVisible(boolean visible) {
        Shell shell = this.getShell();
        if (shell.isVisible() == visible) {
            return;
        }
        if (!visible) {
            super.setVisible(false);
            this.setInput(null);
            return;
        }
        Display display = shell.getDisplay();
        display.timerExec(100, new Runnable(){

            @Override
            public void run() {
                FmBrowserInformationControl.this.fCompleted = true;
            }
        });
        while (!this.fCompleted) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        shell = this.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        if ("win32".equals(SWT.getPlatform())) {
            shell.moveAbove(null);
        }
        super.setVisible(true);
    }

    public void setSize(int width, int height) {
        this.fBrowser.setRedraw(false);
        try {
            super.setSize(width, height);
        }
        finally {
            this.fBrowser.setRedraw(true);
        }
    }

    private void createTextLayout() {
        this.fTextLayout = new TextLayout((Device)this.fBrowser.getDisplay());
        String symbolicFontName = this.fSymbolicFontName == null ? "org.eclipse.jface.dialogfont" : this.fSymbolicFontName;
        Font font = JFaceResources.getFont((String)symbolicFontName);
        this.fTextLayout.setFont(font);
        this.fTextLayout.setWidth(-1);
        font = JFaceResources.getFontRegistry().getBold(symbolicFontName);
        this.fTextLayout.setText("    ");
        int tabWidth = this.fTextLayout.getBounds().width;
        this.fTextLayout.setTabs(new int[]{tabWidth});
        this.fTextLayout.setText("");
    }

    protected void handleDispose() {
        if (this.fTextLayout != null) {
            this.fTextLayout.dispose();
            this.fTextLayout = null;
        }
        this.fBrowser = null;
        super.handleDispose();
    }

    public Point computeSizeHint() {
        return new Point(-1, -1);
    }

    public Rectangle computeTrim() {
        Rectangle trim = super.computeTrim();
        if (this.isResizable()) {
            boolean RTL;
            boolean bl = RTL = (this.getShell().getStyle() & 0x4000000) != 0;
            if (RTL) {
                trim.x -= FmBrowserInformationControl.fgScrollBarSize.x;
            }
            trim.width += FmBrowserInformationControl.fgScrollBarSize.x;
            trim.height += FmBrowserInformationControl.fgScrollBarSize.y;
        }
        return trim;
    }

    public void setForegroundColor(Color foreground) {
        super.setForegroundColor(foreground);
        this.fBrowser.setForeground(foreground);
    }

    public void setBackgroundColor(Color background) {
        super.setBackgroundColor(background);
        this.fBrowser.setBackground(background);
    }

    public boolean hasContents() {
        return this.fBrowserHasContent;
    }

    public String toString() {
        String style = (this.getShell().getStyle() & 0x10) == 0 ? "fixed" : "resizeable";
        return super.toString() + " -  style: " + style;
    }

    public Point computeSizeConstraints(int widthInChars, int heightInChars) {
        if (this.fSymbolicFontName == null) {
            return null;
        }
        GC gc = new GC((Drawable)this.fBrowser);
        Font font = this.fSymbolicFontName == null ? JFaceResources.getDialogFont() : JFaceResources.getFont((String)this.fSymbolicFontName);
        gc.setFont(font);
        int width = gc.getFontMetrics().getAverageCharWidth();
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        return new Point(widthInChars * width, heightInChars * height);
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new FmBrowserInformationControl(parent, FmBrowserInformationControl.this.fSymbolicFontName, FmBrowserInformationControl.this.isResizable());
            }
        };
    }
}

