/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.console;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.HostVersion;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2SubsystemProvider;
import com.ibm.etools.fm.core.model.db2.cmd.Db2CommandInformation;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.core.socket.func.db2.XSQL;
import com.ibm.etools.fm.core.socket.func.db2.XSQLParser;
import com.ibm.etools.fm.core.socket.io.CommonConnectionFM;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunctionParser;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.console.CommonConsole;
import com.ibm.etools.fm.ui.console.CommonConsolePage;
import com.ibm.etools.fm.ui.console.CommonConsoleViewer;
import com.ibm.etools.fm.ui.console.Db2CommandHtmlHelpBuilder;
import com.ibm.etools.fm.ui.console.Db2CommandKeywordProcessor;
import com.ibm.etools.fm.ui.console.Db2CommandScanner;
import com.ibm.etools.fm.ui.console.Db2SqlConsoleContext;
import com.ibm.etools.fm.ui.console.Db2SqlConsoleProcessInputJob;
import com.ibm.etools.fm.ui.console.FmBrowserInformationControl;
import com.ibm.etools.fm.ui.console.FmIOConsolePartition;
import com.ibm.etools.fm.ui.console.FmIOConsolePartitioner;
import com.ibm.etools.fm.ui.console.IFmConsoleConstants;
import com.ibm.etools.fm.ui.console.NonModalConsoleDialog;
import com.ibm.etools.fm.ui.console.PartitionStreamTokenScanner;
import com.ibm.etools.fm.ui.console.SQLRecordCountDialog;
import com.ibm.etools.fm.ui.util.SafeColorRegistry;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.logging.ThrowableRenderer;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import com.ibm.pdtools.common.component.ui.util.EclipseUtils;
import com.ibm.pdtools.common.component.ui.util.ImageLoader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.osgi.service.prefs.Preferences;

public class Db2SqlConsole
extends CommonConsole
implements Db2SubsystemProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2025. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String DB2_CONSOLE_TYPE = "com.ibm.etools.fm.ui.console.Db2SqlConsole";
    private static volatile Db2CommandInformation cmdInfo = null;
    private ImageLoader imgLoader = new ImageLoader(File.separator + "icons" + File.separator + "console" + File.separator);
    private Db2SqlConsoleContext context;
    private boolean continueExecution;
    private int countRect = 1;
    private int rowCount = 1;
    private boolean finishedExecution;

    public Db2SqlConsole(Db2Subsystem db2SubSys, ImageDescriptor imageDescriptor) {
        super((Db2SubsystemProvider)db2SubSys, MessageFormat.format(Messages.Db2SqlConsole_SQL_CONSOLE_FOR_X_ON_Y, db2SubSys.getName(), db2SubSys.getSystem().getConnectionName()), DB2_CONSOLE_TYPE, imageDescriptor);
        this.imgLoader.setDefaultImage(null);
        FmIOConsolePartitioner partitioner = (FmIOConsolePartitioner)this.getDocument().getDocumentPartitioner();
        partitioner.setInputPartitionFinalizationStrategy(new Db2SqlConsoleProcessInputJob.Db2SqlConsoleInputPartitionFinalizationStrategy());
    }

    @Override
    protected CommonConsolePage<CommonConsoleViewer> createPageForCommonConsole(IConsoleView view2) {
        CommonConsolePage<CommonConsoleViewer> page = new CommonConsolePage<CommonConsoleViewer>((TextConsole)this, view2){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected CommonConsoleViewer createViewer(Composite parent) {
                Class<Db2SqlConsole> clazz = Db2SqlConsole.class;
                synchronized (Db2SqlConsole.class) {
                    if (cmdInfo == null) {
                        cmdInfo = new Db2CommandInformation();
                        try {
                            cmdInfo.loadFromPath("db2sqlstatements.xml");
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    final Db2CommandInformation cmdInfo = Db2SqlConsole.cmdInfo;
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    CommonConsoleViewer viewer = new CommonConsoleViewer(parent, (TextConsole)this.getConsole());
                    final CommonConsole.ExposedContentAssistant assistant = new CommonConsole.ExposedContentAssistant();
                    assistant.setInformationControlCreator(new IInformationControlCreator(){

                        public IInformationControl createInformationControl(Shell parent) {
                            return new FmBrowserInformationControl(parent, null, true);
                        }
                    });
                    viewer.configure(new SourceViewerConfiguration(){

                        public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
                            Db2CommandKeywordProcessor proc = new Db2CommandKeywordProcessor(cmdInfo);
                            Object baseUrl = FMUIPlugin.getDefault().getPreferenceStore().getString("fm.console.db2.infocenter_url").trim();
                            baseUrl = (String)baseUrl + "?topic=%2Fcom.ibm.db2z10.doc.sqlref%2Fsrc%2Ftpc%2Fdb2z_sql_";
                            proc.setUrlBuilder(new Db2CommandHtmlHelpBuilder((String)baseUrl));
                            proc.setPartitionType(FmIOConsolePartition.INPUT_PARTITION_TYPE);
                            proc.setHistoryProvider(Db2SqlConsole.this.getHistoryProvider());
                            proc.setImageLoader((this).Db2SqlConsole.this.imgLoader);
                            assistant.setContentAssistProcessor(proc, FmIOConsolePartition.INPUT_PARTITION_TYPE);
                            assistant.setContentAssistProcessor(proc, FmIOConsolePartition.OUTPUT_PARTITION_TYPE);
                            return assistant;
                        }

                        public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
                            PresentationReconciler reconciler = new PresentationReconciler();
                            Db2CommandScanner scanner = new Db2CommandScanner();
                            scanner.setDb2CmdInfo(cmdInfo);
                            scanner.setTokenData(Db2CommandScanner.Db2TokenKey.WHITESPACE, new TextAttribute(null, SafeColorRegistry.instance().get(IFmConsoleConstants.WHITESPACE_BACKGROUND), 0));
                            scanner.setTokenData(Db2CommandScanner.Db2TokenKey.COMMAND, new TextAttribute(SafeColorRegistry.instance().get(IFmConsoleConstants.DB2_COMMAND), null, 1));
                            DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)scanner);
                            reconciler.setDamager((IPresentationDamager)dr, FmIOConsolePartition.INPUT_PARTITION_TYPE);
                            reconciler.setRepairer((IPresentationRepairer)dr, FmIOConsolePartition.INPUT_PARTITION_TYPE);
                            PartitionStreamTokenScanner partitionScanner = new PartitionStreamTokenScanner();
                            partitionScanner.setStreamTokenData(Db2SqlConsole.this.getStdOut(), new TextAttribute(SafeColorRegistry.instance().get(IFmConsoleConstants.OUTPUT_COLOR)));
                            partitionScanner.setStreamTokenData(Db2SqlConsole.this.getStdErr(), new TextAttribute(SafeColorRegistry.instance().get(IFmConsoleConstants.ERROR_COLOR)));
                            partitionScanner.setStreamTokenData(Db2SqlConsole.this.getStdPrompt(), new TextAttribute(SafeColorRegistry.instance().get(IFmConsoleConstants.PROMPT_COLOR)));
                            DefaultDamagerRepairer outputDr = new DefaultDamagerRepairer((ITokenScanner)partitionScanner);
                            reconciler.setDamager((IPresentationDamager)outputDr, FmIOConsolePartition.OUTPUT_PARTITION_TYPE);
                            reconciler.setRepairer((IPresentationRepairer)outputDr, FmIOConsolePartition.OUTPUT_PARTITION_TYPE);
                            return reconciler;
                        }
                    });
                    StyledText textWidget = viewer.getTextWidget();
                    textWidget.addVerifyKeyListener(Db2SqlConsole.this.getConsoleVerifyKeyListener(viewer, null));
                    return viewer;
                }
            }
        };
        this.context = new Db2SqlConsoleContext(view2.getSite());
        this.context.enable();
        return page;
    }

    @Override
    protected Job getInputProcessingJob() {
        Db2SqlConsoleProcessInputJob job = new Db2SqlConsoleProcessInputJob(this.getInputStream());
        job.setIOHandler(this);
        return job;
    }

    @Override
    public void handleInput(String input, IHowIsGoing monitor) throws IOException {
        Objects.requireNonNull(input, "Must provide a non-null input");
        try {
            this.getHistoryProvider().addInput(input);
            EclipseUtils.retestEclipseProperty((String)"com.ibm.etools.fm.ui.console", (String)"hasCommandsInHistory");
            HostVersion hostVersion = HostVersion.getInstance();
            hostVersion.setHost(this.getSystem());
            int version = hostVersion.getVersion();
            XSQL xsql = null;
            if (Db2SqlConsole.useNewXSQLforSelect(input, version)) {
                IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("com.ibm.etools.fm.ui");
                Preferences recCount = preferences.node(SQLRecordCountDialog.PREF_NODE);
                String text2 = recCount.get(SQLRecordCountDialog.PREF_NODE_KEY, "");
                if ("".equals(text2.trim())) {
                    xsql = new XSQL();
                    try {
                        String countStatement = "SELECT COUNT(*) FROM TABLE";
                        xsql.setSql(countStatement + "( " + input.replace(";", "") + ")");
                        this.doExecutionWithOldXSQLCmd(monitor, xsql, true);
                        if (this.continueExecution) {
                            xsql.setSql(input.substring(0, input.length() - 1));
                            this.doExecutionWithOldXSQLCmd(monitor, xsql, false);
                        }
                        return;
                    }
                    catch (Exception ex) {
                        xsql.setSql(input.substring(0, input.length() - 1));
                        this.doExecutionWithOldXSQLCmd(monitor, xsql, false);
                    }
                } else {
                    xsql = new XSQL("" + this.countRect, text2);
                    xsql.setSql(input.substring(0, input.length() - 1));
                    this.rowCount = Integer.parseInt(text2);
                    this.doExecutionWithNewSQLCmd(monitor, xsql);
                }
            } else {
                xsql = new XSQL();
                xsql.setSql(input.substring(0, input.length() - 1));
                this.doExecutionWithOldXSQLCmd(monitor, xsql, false);
            }
        }
        catch (InterruptedException e) {
            this.getStdErr().write(Messages.Console_INTERRUPTED + "\n");
        }
    }

    private static boolean useNewXSQLforSelect(String input, int version) {
        return version >= 150102 && input.trim().substring(0, 7).equalsIgnoreCase("SELECT ");
    }

    private void doExecutionWithOldXSQLCmd(IHowIsGoing monitor, XSQL xsql, boolean countQuery) throws IOException, InterruptedException {
        this.setExecuting(true);
        if (!countQuery) {
            this.getStdOut().write(Messages.Console_EXECUTING);
        }
        try {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (CommonConnectionFM conn = this.getConnection(monitor);){
                    Result result = UtilityFunctionRunner.executeAndParse((CommonConnectionFM)conn, (UtilityFunction)xsql, (UtilityFunctionParser)new XSQLParser(this.getSystem()), (IHowIsGoing)monitor);
                    if (!countQuery) {
                        this.getStdOut().write(" ");
                        this.getStdOut().write(Messages.Console_DONE);
                        this.getStdOut().write("\n");
                    }
                    if (result.hasError()) {
                        this.getStdErr().write(result.getMessagesCombined().toString().trim() + "\n");
                    } else {
                        this.executeCountQueryAndWarnUser((Result<String[][]>)result, countQuery);
                        if (!countQuery) {
                            PrintWriter writer = new PrintWriter(this.getStdOut());
                            Db2SqlConsole.dumpTableToWriter((Result<String[][]>)result, writer);
                            writer.flush();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (CommunicationException e) {
                logger.error((Object)"Failed to execute DB2 console sql: ", (Throwable)e);
                this.getStdErr().write("\n" + MessageFormat.format(Messages.Db2SqlConsole_ERROR_EXECUTING_CMD_X, ThrowableRenderer.renderShortForm((Throwable)e).toString().trim()));
                this.setExecuting(false);
            }
        }
        finally {
            this.setExecuting(false);
        }
    }

    private void executeCountQueryAndWarnUser(final Result<String[][]> result, boolean countQuery) {
        if (!countQuery) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                String count = ((String[][])result.getOutput())[1][0];
                int countValue = Integer.parseInt(count);
                boolean status = true;
                if (countValue > 250) {
                    status = MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"", (String)MessageFormat.format(Messages.SQL_FETCH_COUNT_SHOW, count));
                }
                Db2SqlConsole.this.continueExecution = status;
            }
        });
    }

    private void doExecutionWithNewSQLCmd(IHowIsGoing monitor, XSQL xsql) throws IOException, InterruptedException {
        this.setExecuting(true);
        this.getStdOut().write(Messages.Console_EXECUTING);
        try {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (CommonConnectionFM conn = this.getConnection(monitor);){
                    Result result = UtilityFunctionRunner.executeAndParse((CommonConnectionFM)conn, (UtilityFunction)xsql, (UtilityFunctionParser)new XSQLParser(this.getSystem()), (IHowIsGoing)monitor);
                    this.getStdOut().write(" ");
                    this.getStdOut().write(Messages.Console_DONE);
                    this.getStdOut().write("\n");
                    if (result.hasError()) {
                        this.getStdErr().write(result.getMessagesCombined().toString().trim() + "\n");
                    } else {
                        PrintWriter writer = new PrintWriter(this.getStdOut());
                        this.finishedExecution = Db2SqlConsole.dumpTableToWriter((Result<String[][]>)result, writer);
                        if (Db2SqlConsole.containsFetch(xsql.getPostHeaderData())) {
                            this.finishedExecution = true;
                        }
                        if (!this.finishedExecution) {
                            writer.append("Fetched " + (((String[][])result.getOutput()).length - 1) + " rows...");
                            writer.append("\n");
                        }
                        writer.flush();
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (Db2SqlConsole.this.finishedExecution) {
                                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"", (String)Messages.SQL_FINISHED_EXECUTION);
                                    Db2SqlConsole.this.continueExecution = false;
                                } else {
                                    NonModalConsoleDialog dialog = new NonModalConsoleDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                                    Db2SqlConsole.this.continueExecution = false;
                                    if (dialog.open() == 0) {
                                        Db2SqlConsole.this.continueExecution = true;
                                    }
                                }
                            }
                        });
                        while (this.continueExecution) {
                            if (this.countRect > 1) {
                                this.countRect += this.rowCount;
                                postHeaderData = xsql.getPostHeaderData();
                                xsql = new XSQL("" + this.countRect, "" + this.rowCount);
                                xsql.setPostHeaderData(postHeaderData);
                            } else {
                                this.countRect = this.rowCount + 1;
                                postHeaderData = xsql.getPostHeaderData();
                                xsql = new XSQL("" + this.countRect, "" + this.rowCount);
                                xsql.setPostHeaderData(postHeaderData);
                            }
                            this.doExecutionWithNewSQLCmd(monitor, xsql);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (CommunicationException e) {
                logger.error((Object)"Failed to execute DB2 console sql: ", (Throwable)e);
                this.getStdErr().write("\n" + MessageFormat.format(Messages.Db2SqlConsole_ERROR_EXECUTING_CMD_X, ThrowableRenderer.renderShortForm((Throwable)e).toString().trim()));
                this.countRect = 1;
                this.setExecuting(false);
            }
        }
        finally {
            this.countRect = 1;
            this.setExecuting(false);
        }
    }

    public static boolean containsFetch(String sql) {
        Pattern pattern = Pattern.compile("\\bfetch\\b", 2);
        Matcher matcher = pattern.matcher(sql);
        return matcher.find();
    }

    public static boolean dumpTableToWriter(Result<String[][]> tableResult, PrintWriter writer) {
        Objects.requireNonNull(tableResult, "Must provide a non-null tableResult.");
        String messagesCombined = tableResult.getMessagesCombined().toString().trim();
        String[][] table = (String[][])tableResult.getOutput();
        if (!messagesCombined.isEmpty()) {
            writer.append(messagesCombined);
            writer.append("\n");
        }
        if (table.length <= 1) {
            if (messagesCombined.isEmpty()) {
                writer.append(Messages.Db2SqlConsole_SUCCESS_NO_OUPUT);
                writer.append("\n");
            }
            return true;
        }
        int[] colWidths = new int[table[0].length];
        int col = 0;
        while (col < colWidths.length) {
            colWidths[col] = 0;
            int row = 0;
            while (row < table.length) {
                if (table[row][col] == null) {
                    table[row][col] = Messages.Db2SqlConsole_NULL_VALUE;
                }
                colWidths[col] = Math.max(colWidths[col], table[row][col].length());
                ++row;
            }
            ++col;
        }
        int row = 0;
        while (row < table.length) {
            int col2 = 0;
            while (col2 < table[row].length) {
                if (col2 > 0) {
                    writer.append(" | ");
                }
                writer.append(table[row][col2]);
                int padCount = colWidths[col2] - table[row][col2].length();
                writer.append(StringUtils.repeat((String)" ", (int)padCount));
                ++col2;
            }
            writer.append("\n");
            if (row == 0) {
                col2 = 0;
                while (col2 < colWidths.length) {
                    if (col2 > 0) {
                        writer.append("-+-");
                    }
                    writer.append(StringUtils.repeat((String)"-", (int)colWidths[col2]));
                    ++col2;
                }
                writer.append("\n");
            }
            ++row;
        }
        return false;
    }

    @Override
    protected String getPromptText() {
        return this.getSubsystem().getName() + " SQL";
    }

    @Override
    protected void dispose() {
        this.imgLoader.dispose();
        this.context.disable();
        super.dispose();
    }

    public Db2Subsystem getSubsystem() {
        return (Db2Subsystem)this.getEndpoint();
    }
}

