/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.console;

import com.ibm.etools.fm.core.model.db2.cmd.Db2Command;
import com.ibm.etools.fm.core.model.db2.cmd.Db2CommandInformation;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;

public class Db2CommandScanner
implements ITokenScanner {
    public static final int NO_ERROR = -1;
    private static final Pattern PATTERN_WHITESPACE = Pattern.compile("^(\\s+)");
    private static final Pattern PATTERN_KEYWORD_SEPARATOR = Pattern.compile("^(\\s+|,)");
    private static final Pattern PATTERN_KEYWORD = Pattern.compile("^([a-zA-Z0-9]+)");
    private static final Pattern PATTERN_PARAMETER_INSIDE_CONTAINER = Pattern.compile("^[^\\)]+");
    private static final Pattern PATTERN_PARAMETER_OUTSIDE_CONTAINER = Pattern.compile("^[^\\s,]+");
    private static final Pattern PATTERN_PARAMETER_CONTAINER_OPEN_BRACKET = Pattern.compile("^\\(");
    private static final Pattern PATTERN_PARAMETER_CONTAINER_EQUALS = Pattern.compile("^=");
    private static final Pattern PATTERN_PARAMETER_CONTAINER_CLOSE_BRACKET = Pattern.compile("^\\)");
    protected IToken fDefaultReturnToken;
    protected IDocument fDocument;
    protected char[][] fDelimiters;
    protected int fInitialOffset;
    protected int fOffset;
    protected int fRangeEnd;
    protected int fTokenOffset;
    protected CharSequence fDocumentAdapter = null;
    protected final List<Map.Entry<Pattern, Db2Command>> patternsToCmds = new ArrayList<Map.Entry<Pattern, Db2Command>>();
    private final Map<Db2TokenKey, IToken> tokens = new HashMap<Db2TokenKey, IToken>();
    private Db2Command scannedCommand = null;
    private String scannedCommandAlias = null;
    private List<Db2Command> partialCommands = new ArrayList<Db2Command>();
    private String lastScannedKeyword = null;
    private int errorPosition = -1;
    private Db2TokenKey previousTokenKey = null;
    private boolean insideParamContainer;
    private boolean expectingParam;

    public Db2CommandScanner() {
        Db2TokenKey[] db2TokenKeyArray = Db2TokenKey.values();
        int n = db2TokenKeyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Db2TokenKey key = db2TokenKeyArray[n2];
            this.setTokenData(key, (Object)key);
            ++n2;
        }
    }

    public void setDb2CmdInfo(Db2CommandInformation info) {
        Objects.requireNonNull(info, "Must provide a non-null info");
        this.patternsToCmds.clear();
        for (Db2Command cmd : info.getCommands()) {
            this.patternsToCmds.add((Map.Entry<Pattern, Db2Command>)new ImmutablePair((Object)Db2CommandScanner.getPatternForCommand(cmd.getName()), (Object)cmd));
            for (String alias : cmd.getAliases()) {
                this.patternsToCmds.add((Map.Entry<Pattern, Db2Command>)new ImmutablePair((Object)Db2CommandScanner.getPatternForCommand(alias), (Object)cmd));
            }
        }
        Collections.sort(this.patternsToCmds, new Comparator<Map.Entry<Pattern, Db2Command>>(){

            @Override
            public int compare(Map.Entry<Pattern, Db2Command> o1, Map.Entry<Pattern, Db2Command> o2) {
                return -o1.getValue().getName().compareTo(o2.getValue().getName());
            }
        });
    }

    private static Pattern getPatternForCommand(String cmd) {
        String pattern = "^" + StringUtils.escapeRegex((String)cmd);
        return Pattern.compile(pattern, 2);
    }

    public void setRange(IDocument document, int offset, int length) {
        if (document == null) {
            throw new IllegalArgumentException();
        }
        int documentLength = document.getLength();
        Db2CommandScanner.checkRange(offset, length, documentLength);
        this.fDocument = document;
        this.fInitialOffset = offset;
        this.fOffset = offset;
        this.fRangeEnd = offset + length;
        String[] delimiters = this.fDocument.getLegalLineDelimiters();
        this.fDelimiters = new char[delimiters.length][];
        int i = 0;
        while (i < delimiters.length) {
            this.fDelimiters[i] = delimiters[i].toCharArray();
            ++i;
        }
        if (this.fDefaultReturnToken == null) {
            this.fDefaultReturnToken = new Token(null);
        }
        this.fDocumentAdapter = new DocumentCharSequenceAdapter(document);
        this.scannedCommand = null;
        this.scannedCommandAlias = null;
        this.errorPosition = -1;
        this.insideParamContainer = false;
        this.expectingParam = false;
    }

    private static void checkRange(int offset, int length, int documentLength) {
        Assert.isLegal((offset > -1 ? 1 : 0) != 0);
        Assert.isLegal((length > -1 ? 1 : 0) != 0);
        Assert.isLegal((offset + length <= documentLength ? 1 : 0) != 0);
    }

    public IToken nextToken() {
        this.previousTokenKey = this.nextTokenImpl();
        if (this.previousTokenKey == Db2TokenKey.EOF) {
            return Token.EOF;
        }
        if (this.previousTokenKey == Db2TokenKey.DEFAULT) {
            return this.fDefaultReturnToken;
        }
        return this.getToken(this.previousTokenKey);
    }

    private Db2TokenKey nextTokenImpl() {
        this.partialCommands.clear();
        this.fTokenOffset = this.fOffset;
        if (this.fOffset >= this.fRangeEnd) {
            return Db2TokenKey.EOF;
        }
        Matcher whiteSpaceMatcher = PATTERN_WHITESPACE.matcher(this.fDocumentAdapter);
        if (this.errorPosition == -1 && this.scannedCommand == null) {
            whiteSpaceMatcher.region(this.fOffset, this.fRangeEnd);
            if (whiteSpaceMatcher.lookingAt()) {
                this.fOffset = whiteSpaceMatcher.end();
                return Db2TokenKey.WHITESPACE;
            }
        }
        Matcher kwsMatcher = PATTERN_KEYWORD_SEPARATOR.matcher(this.fDocumentAdapter);
        Matcher paramContainerStartBracketMatcher = PATTERN_PARAMETER_CONTAINER_OPEN_BRACKET.matcher(this.fDocumentAdapter);
        Matcher paramContainerStartEqualsMatcher = PATTERN_PARAMETER_CONTAINER_EQUALS.matcher(this.fDocumentAdapter);
        if (this.errorPosition == -1 && this.scannedCommand == null) {
            int scannedCommandNewOffset = -1;
            int partialCommandNewOffset = -1;
            for (Map.Entry<Pattern, Db2Command> entry : this.patternsToCmds) {
                Pattern pattern;
                Db2Command cmd = entry.getValue();
                Pattern cmdPattern = pattern = entry.getKey();
                Matcher cmdMatcher = cmdPattern.matcher(this.fDocumentAdapter);
                cmdMatcher.region(this.fOffset, this.fRangeEnd);
                if (cmdMatcher.lookingAt()) {
                    if (cmdMatcher.end() != this.fRangeEnd && !kwsMatcher.region(cmdMatcher.end(), cmdMatcher.end() + 1).matches() && !paramContainerStartBracketMatcher.region(cmdMatcher.end(), cmdMatcher.end() + 1).matches() && !paramContainerStartEqualsMatcher.region(cmdMatcher.end(), cmdMatcher.end() + 1).matches()) continue;
                    this.scannedCommand = cmd;
                    this.scannedCommandAlias = null;
                    for (String alias : cmd.getAliases()) {
                        Pattern aliasPattern = Db2CommandScanner.getPatternForCommand(alias);
                        if (!aliasPattern.pattern().equals(pattern.pattern())) continue;
                        if (!this.partialCommands.contains(cmd)) {
                            this.partialCommands.add(cmd);
                        }
                        this.scannedCommandAlias = alias;
                    }
                    scannedCommandNewOffset = cmdMatcher.end();
                    continue;
                }
                if (!cmdMatcher.hitEnd()) continue;
                if (!this.partialCommands.contains(cmd)) {
                    this.partialCommands.add(cmd);
                }
                partialCommandNewOffset = this.fRangeEnd;
            }
            if (partialCommandNewOffset != -1 || scannedCommandNewOffset != -1) {
                if (partialCommandNewOffset > scannedCommandNewOffset) {
                    this.scannedCommand = null;
                }
                this.fOffset = Math.max(partialCommandNewOffset, scannedCommandNewOffset);
                return Db2TokenKey.COMMAND;
            }
        }
        if (this.errorPosition == -1 && this.scannedCommand != null) {
            kwsMatcher.region(this.fOffset, this.fRangeEnd);
            if (kwsMatcher.lookingAt()) {
                this.fOffset = kwsMatcher.end();
                return Db2TokenKey.KEYWORD_SEPARATOR;
            }
        }
        if (this.errorPosition == -1 && this.scannedCommand != null && this.previousTokenKey == Db2TokenKey.KEYWORD_SEPARATOR) {
            Matcher kwMatcher = PATTERN_KEYWORD.matcher(this.fDocumentAdapter);
            kwMatcher.region(this.fOffset, this.fRangeEnd);
            if (kwMatcher.lookingAt()) {
                this.lastScannedKeyword = this.fDocumentAdapter.subSequence(this.fOffset, kwMatcher.end()).toString();
                this.fOffset = kwMatcher.end();
                return Db2TokenKey.KEYWORD;
            }
        }
        if (this.errorPosition == -1 && this.scannedCommand != null && (this.previousTokenKey == Db2TokenKey.KEYWORD || this.previousTokenKey == Db2TokenKey.COMMAND || this.previousTokenKey == Db2TokenKey.KEYWORD_SEPARATOR)) {
            paramContainerStartBracketMatcher.region(this.fOffset, this.fRangeEnd);
            if (paramContainerStartBracketMatcher.lookingAt()) {
                this.fOffset = paramContainerStartBracketMatcher.end();
                this.insideParamContainer = true;
                this.expectingParam = true;
                return Db2TokenKey.PARAMETER_CONTAINER;
            }
            paramContainerStartEqualsMatcher.region(this.fOffset, this.fRangeEnd);
            if (paramContainerStartEqualsMatcher.lookingAt()) {
                this.fOffset = paramContainerStartEqualsMatcher.end();
                this.expectingParam = true;
                return Db2TokenKey.PARAMETER_CONTAINER;
            }
        }
        if (this.errorPosition == -1 && this.scannedCommand != null && this.expectingParam) {
            if (this.insideParamContainer) {
                Matcher paramInsideMatcher = PATTERN_PARAMETER_INSIDE_CONTAINER.matcher(this.fDocumentAdapter);
                paramInsideMatcher.region(this.fOffset, this.fRangeEnd);
                if (paramInsideMatcher.lookingAt()) {
                    this.fOffset = paramInsideMatcher.end();
                    this.expectingParam = false;
                    return Db2TokenKey.PARAMETER;
                }
            } else {
                Matcher paramOutsideMatcher = PATTERN_PARAMETER_OUTSIDE_CONTAINER.matcher(this.fDocumentAdapter);
                paramOutsideMatcher.region(this.fOffset, this.fRangeEnd);
                if (paramOutsideMatcher.lookingAt()) {
                    this.fOffset = paramOutsideMatcher.end();
                    this.expectingParam = false;
                    return Db2TokenKey.PARAMETER;
                }
            }
        }
        if (this.errorPosition == -1 && this.scannedCommand != null && this.insideParamContainer) {
            Matcher paramContainerCloseBracketMatcher = PATTERN_PARAMETER_CONTAINER_CLOSE_BRACKET.matcher(this.fDocumentAdapter);
            paramContainerCloseBracketMatcher.region(this.fOffset, this.fRangeEnd);
            if (paramContainerCloseBracketMatcher.lookingAt()) {
                this.fOffset = paramContainerCloseBracketMatcher.end();
                this.insideParamContainer = false;
                return Db2TokenKey.PARAMETER_CONTAINER;
            }
        }
        if (this.errorPosition == -1) {
            this.errorPosition = this.fOffset;
        }
        ++this.fOffset;
        return Db2TokenKey.DEFAULT;
    }

    private IToken getToken(Db2TokenKey token) {
        return this.tokens.get((Object)token);
    }

    public void setTokenData(Db2TokenKey tokenKey, Object data) {
        Objects.requireNonNull(tokenKey, "Must provide a non-null tokenKey");
        Objects.requireNonNull(data, "Must provide a non-null data");
        this.tokens.put(tokenKey, (IToken)new Token(data));
    }

    public int getTokenOffset() {
        return this.fTokenOffset;
    }

    public int getTokenLength() {
        if (this.fOffset < this.fRangeEnd) {
            return this.fOffset - this.getTokenOffset();
        }
        return this.fRangeEnd - this.getTokenOffset();
    }

    public int getErrorPosition() {
        return this.errorPosition;
    }

    public Db2Command getScannedCommand() {
        return this.scannedCommand;
    }

    public String getScannedCommandAlias() {
        return this.scannedCommandAlias;
    }

    public List<Db2Command> getPartialCommands() {
        Collections.sort(this.partialCommands, new Comparator<Db2Command>(){

            @Override
            public int compare(Db2Command o1, Db2Command o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return new ArrayList<Db2Command>(this.partialCommands);
    }

    public String getLastScannedKeyword() {
        return this.lastScannedKeyword;
    }

    public static enum Db2TokenKey {
        WHITESPACE,
        COMMAND,
        KEYWORD_SEPARATOR,
        KEYWORD,
        PARAMETER,
        PARAMETER_CONTAINER,
        PARAMETER_SEPARATOR,
        EOF,
        DEFAULT;

    }

    private static class DocumentCharSequenceAdapter
    implements CharSequence {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private IDocument doc;

        public DocumentCharSequenceAdapter(IDocument document) {
            this.doc = document;
        }

        @Override
        public int length() {
            return this.doc.getLength();
        }

        @Override
        public char charAt(int index) {
            try {
                return this.doc.getChar(index);
            }
            catch (BadLocationException x) {
                throw new IndexOutOfBoundsException(x.getLocalizedMessage());
            }
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            try {
                return this.doc.get(start, end - start);
            }
            catch (BadLocationException x) {
                throw new IndexOutOfBoundsException(x.getLocalizedMessage());
            }
        }
    }
}

