/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.console;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.cmd.Db2Command;
import com.ibm.etools.fm.core.model.db2.cmd.Db2CommandInformation;
import com.ibm.etools.fm.core.model.db2.cmd.Db2CommandKeyword;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.console.ConsoleHistoryProvider;
import com.ibm.etools.fm.ui.console.Db2CommandScanner;
import com.ibm.etools.fm.ui.console.Db2ContentProposalType;
import com.ibm.etools.fm.ui.console.FmIOConsolePartition;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.ui.util.ImageLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.swt.graphics.Image;

public class Db2CommandKeywordProcessor
implements IContentAssistProcessor {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(Db2CommandKeywordProcessor.class);
    private final Db2CommandScanner scanner;
    private final Db2CommandInformation info;
    private String partitionType = null;
    private ConsoleHistoryProvider historyProvider;
    private ImageLoader imgLoader;
    private IHtmlHelpBuilder htmlBuilder;

    public Db2CommandKeywordProcessor(Db2CommandInformation info) {
        this.info = Objects.requireNonNull(info, "Must provide a non-null info");
        this.scanner = new Db2CommandScanner();
        this.scanner.setDb2CmdInfo(info);
    }

    public void setUrlBuilder(IHtmlHelpBuilder urlBuilder) {
        this.htmlBuilder = urlBuilder;
    }

    public void setPartitionType(String partitionType) {
        this.partitionType = partitionType;
    }

    public void setHistoryProvider(ConsoleHistoryProvider history) {
        this.historyProvider = history;
    }

    public void setImageLoader(ImageLoader imgLoader) {
        this.imgLoader = imgLoader;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int cursorPos) {
        boolean matchingPartition;
        String endOfDocContentType;
        ITypedRegion cursorPartition;
        IDocument doc = viewer.getDocument();
        int endOfDocOffset = doc.getLength();
        try {
            cursorPartition = doc.getPartition(cursorPos);
            endOfDocContentType = doc.getContentType(endOfDocOffset);
        }
        catch (BadLocationException e) {
            logger.error((Throwable)e);
            return new ICompletionProposal[0];
        }
        boolean bl = matchingPartition = this.partitionType == null || this.partitionType.equals(cursorPartition.getType());
        if (cursorPartition instanceof FmIOConsolePartition) {
            FmIOConsolePartition ioConsolePartition = (FmIOConsolePartition)cursorPartition;
            if (matchingPartition && ioConsolePartition.isReadOnly()) {
                return new ICompletionProposal[0];
            }
        }
        if (matchingPartition) {
            int length = cursorPos - cursorPartition.getOffset();
            return this.computeCompletionProposalsForDoc(doc, cursorPartition.getOffset(), length);
        }
        if (this.partitionType.equals(endOfDocContentType)) {
            return this.computeCompletionProposals(viewer, endOfDocOffset);
        }
        return this.computeCompletionProposalsForDoc(doc, endOfDocOffset, 0);
    }

    public ICompletionProposal[] computeCompletionProposalsForDoc(IDocument doc, int docOffset, int length) {
        Db2Command scannedCommand = null;
        String scannedCommandAlias = null;
        List<Object> proposedCommands = new ArrayList();
        this.scanner.setRange(doc, docOffset, length);
        IToken token = this.scanner.nextToken();
        int lastTokenLength = 0;
        int lastTokenOffset = 0;
        IToken lastToken = token;
        while (!token.isEOF()) {
            proposedCommands = this.scanner.getPartialCommands();
            scannedCommand = this.scanner.getScannedCommand();
            scannedCommandAlias = this.scanner.getScannedCommandAlias();
            lastTokenOffset = this.scanner.getTokenOffset();
            lastTokenLength = this.scanner.getTokenLength();
            lastToken = token;
            token = this.scanner.nextToken();
        }
        int replacementOffset = docOffset;
        int replacementLength = 0;
        if (Db2CommandScanner.Db2TokenKey.COMMAND.equals(lastToken.getData()) || Db2CommandScanner.Db2TokenKey.KEYWORD.equals(lastToken.getData())) {
            replacementOffset = lastTokenOffset;
            replacementLength = lastTokenLength;
        } else if (!lastToken.isEOF()) {
            replacementOffset = lastTokenOffset + lastTokenLength;
        }
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        if (this.scanner.getErrorPosition() == -1) {
            CompletionProposal proposal;
            if (scannedCommand == null || Db2CommandScanner.Db2TokenKey.COMMAND == lastToken.getData() && scannedCommandAlias != null && lastTokenOffset + lastTokenLength == docOffset + length || scannedCommand != null && proposedCommands.size() > 0) {
                if (proposedCommands.isEmpty()) {
                    proposedCommands = this.info.getCommands();
                }
                Image img = this.getImage(Db2ContentProposalType.COMMAND);
                if (scannedCommand != null && scannedCommandAlias == null) {
                    String string = scannedCommand.getName();
                    Object html = null;
                    if (this.htmlBuilder != null) {
                        html = this.htmlBuilder.getHtmlHelp(scannedCommand);
                    }
                    CompletionProposal proposal2 = new CompletionProposal(string, replacementOffset, replacementLength, string.length(), img, scannedCommand.getDisplayName(), null, (String)html);
                    proposals.add(proposal2);
                }
                for (Db2Command db2Command : proposedCommands) {
                    String cmdName = db2Command.getName();
                    String html = null;
                    if (this.htmlBuilder != null) {
                        html = this.htmlBuilder.getHtmlHelp(db2Command);
                    }
                    proposal = new CompletionProposal(cmdName, replacementOffset, replacementLength, cmdName.length(), img, db2Command.getDisplayName(), null, html);
                    proposals.add(proposal);
                }
            }
            if (scannedCommand != null && (Db2CommandScanner.Db2TokenKey.KEYWORD_SEPARATOR == lastToken.getData() || Db2CommandScanner.Db2TokenKey.KEYWORD == lastToken.getData())) {
                TreeSet kws = new TreeSet(scannedCommand.getAllKeywords());
                String string = Db2CommandKeywordProcessor.getStr(doc, lastTokenOffset, lastTokenLength);
                for (Db2CommandKeyword kw : kws) {
                    String kwName = kw.getName();
                    if (!lastToken.getData().equals((Object)Db2CommandScanner.Db2TokenKey.KEYWORD_SEPARATOR) && !kwName.toLowerCase().startsWith(string.toLowerCase())) continue;
                    proposal = new CompletionProposal(kwName, replacementOffset, replacementLength, kwName.length(), this.getImage(Db2ContentProposalType.KEYWORD), null, null, kw.getHtmlDescription());
                    proposals.add(proposal);
                }
            }
        }
        if (this.historyProvider != null) {
            List<String> inputHistory = this.historyProvider.getHistory();
            try {
                String string = doc.get(docOffset, length).trim().toLowerCase();
                Image image = this.getImage(Db2ContentProposalType.HISTORY);
                for (String input : inputHistory) {
                    String processedInput = input.trim().toLowerCase();
                    if (!processedInput.startsWith(string)) continue;
                    String displayString = input.replaceAll(Pattern.quote(FMUIPlugin.NEWLINE_CHARS), " ");
                    String info = MessageFormat.format(Messages.Db2CommandKeywordProcessor_INPUT_FROM_HISTORY, input);
                    CompletionProposal proposal = new CompletionProposal(input, docOffset, doc.getLength() - docOffset, input.length(), image, displayString, null, info);
                    proposals.add(proposal);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return proposals.toArray(new ICompletionProposal[0]);
    }

    private static String getStr(IDocument doc, int offset, int length) {
        try {
            return doc.get(offset, length);
        }
        catch (BadLocationException e) {
            logger.error((Throwable)e);
            return "";
        }
    }

    private Image getImage(Db2ContentProposalType proposalType) {
        if (this.imgLoader == null) {
            return null;
        }
        return this.imgLoader.getImageByName("com.ibm.etools.fm.ui", proposalType.name().toLowerCase());
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int cursorPos) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public static interface IHtmlHelpBuilder {
        public String getHtmlHelp(Db2Command var1);
    }
}

