/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.console;

import com.ibm.etools.fm.core.model.db2.cmd.Db2Command;
import com.ibm.etools.fm.core.model.db2.cmd.Db2CommandKeyword;
import com.ibm.etools.fm.ui.console.Db2CommandKeywordProcessor;
import java.util.Set;

public class Db2CommandHtmlHelpBuilder
implements Db2CommandKeywordProcessor.IHtmlHelpBuilder {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final String externalHelpBaseUrl;

    public Db2CommandHtmlHelpBuilder() {
        this(null);
    }

    public Db2CommandHtmlHelpBuilder(String externalHelpBaseUrl) {
        this.externalHelpBaseUrl = externalHelpBaseUrl;
    }

    @Override
    public String getHtmlHelp(Db2Command cmd) {
        Set allKws;
        StringBuilder html = new StringBuilder();
        html.append("<h4>");
        if (this.externalHelpBaseUrl != null) {
            html.append("<a href=\"");
            html.append(this.externalHelpBaseUrl);
            String cmdPortion = cmd.getHelpDetailLinkName();
            if (cmdPortion == null) {
                cmdPortion = cmd.getDisplayName().replaceAll("[^A-Za-z0-9]", "").toLowerCase();
            }
            html.append(cmdPortion);
            html.append(".htm\">");
        }
        html.append(cmd.getName());
        if (this.externalHelpBaseUrl != null) {
            html.append("</a>");
        }
        html.append("</h4>");
        if (cmd.getHelp() != null) {
            html.append("<p>");
            html.append(cmd.getHelp());
            html.append("</p>");
        }
        if ((allKws = cmd.getAllKeywords()).size() > 0) {
            html.append("<ul style=\"list-style-type: square;\">");
            for (Db2CommandKeyword kw : allKws) {
                html.append("\n<li><pre style=\"margin: 0px;\">");
                html.append(kw.getName());
                html.append("</pre></li>");
            }
            html.append("</ul>");
        }
        return html.toString();
    }
}

