/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.console;

import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.ui.console.Db2CommandConsole;
import com.ibm.etools.fm.ui.dialog.lookup.Db2SubsystemLookupDialog;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.dialog.SystemLookupDialog;
import java.io.File;
import java.util.Objects;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleFactory;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class Db2CommandConsoleFactory
implements IConsoleFactory {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(Db2CommandConsoleFactory.class);

    public static Db2CommandConsole openDb2CommandConsoleOnHost(IPDHost host) {
        Objects.requireNonNull(host, "Must provide a non-null host.");
        Db2SubsystemLookupDialog subSysDialog = new Db2SubsystemLookupDialog(host);
        if (subSysDialog.open() != 0) {
            logger.trace((Object)("User did not choose a subsystem for db2 command console from host " + String.valueOf(host)));
            return null;
        }
        return Db2CommandConsoleFactory.openDb2CommandConsoleFor((Db2Subsystem)subSysDialog.getFirstSelectedObject());
    }

    public static Db2CommandConsole openDb2CommandConsoleFor(Db2Subsystem db2SubSys) {
        Objects.requireNonNull(db2SubSys, "Must specify a non-null db2SubSys.");
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        Db2CommandConsole db2Console = null;
        IConsole[] iConsoleArray = manager.getConsoles();
        int n = iConsoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole existingConsole = iConsoleArray[n2];
            if (existingConsole instanceof Db2CommandConsole && db2SubSys.equals((Object)((Db2CommandConsole)existingConsole).getSubsystem())) {
                db2Console = (Db2CommandConsole)existingConsole;
                db2Console.activate();
                break;
            }
            ++n2;
        }
        if (db2Console == null) {
            db2Console = new Db2CommandConsole(db2SubSys, AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.etools.fm.ui", (String)("icons" + File.separator + "console" + File.separator + "db2CommandConsole.gif")));
            manager.addConsoles(new IConsole[]{db2Console});
        }
        manager.showConsoleView(db2Console);
        return db2Console;
    }

    public void openConsole() {
        SystemLookupDialog hostDialog = new SystemLookupDialog();
        if (hostDialog.open() != 0) {
            logger.trace((Object)"User did not select system for db2 command console");
            return;
        }
        Db2CommandConsoleFactory.openDb2CommandConsoleOnHost(hostDialog.getSelectedHost());
    }
}

