/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.console;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2SubsystemProvider;
import com.ibm.etools.fm.core.model.db2.cmd.Db2CommandInformation;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.core.socket.func.db2.XCMD;
import com.ibm.etools.fm.core.socket.func.db2.XCMDParser;
import com.ibm.etools.fm.core.socket.io.CommonConnectionFM;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunctionParser;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.console.CommonConsole;
import com.ibm.etools.fm.ui.console.CommonConsolePage;
import com.ibm.etools.fm.ui.console.CommonConsoleViewer;
import com.ibm.etools.fm.ui.console.Db2CommandConsoleContext;
import com.ibm.etools.fm.ui.console.Db2CommandHtmlHelpBuilder;
import com.ibm.etools.fm.ui.console.Db2CommandKeywordProcessor;
import com.ibm.etools.fm.ui.console.Db2CommandScanner;
import com.ibm.etools.fm.ui.console.FmBrowserInformationControl;
import com.ibm.etools.fm.ui.console.FmIOConsolePartition;
import com.ibm.etools.fm.ui.console.IFmConsoleConstants;
import com.ibm.etools.fm.ui.console.PartitionStreamTokenScanner;
import com.ibm.etools.fm.ui.util.SafeColorRegistry;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.logging.ThrowableRenderer;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.EclipseUtils;
import com.ibm.pdtools.common.component.ui.util.ImageLoader;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;

public class Db2CommandConsole
extends CommonConsole
implements Db2SubsystemProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String DB2_CONSOLE_TYPE = "com.ibm.etools.fm.ui.console.Db2CommandConsole";
    private static volatile Db2CommandInformation cmdInfo = null;
    private ImageLoader imgLoader = new ImageLoader(File.separator + "icons" + File.separator + "console" + File.separator);
    private Db2CommandConsoleContext context;

    public Db2CommandConsole(Db2Subsystem db2SubSys, ImageDescriptor imageDescriptor) {
        super((Db2SubsystemProvider)db2SubSys, MessageFormat.format(Messages.Db2CommandConsole_DB2_CONSOLE_FOR_X_ON_Y, db2SubSys.getName(), db2SubSys.getSystem().getConnectionName()), DB2_CONSOLE_TYPE, imageDescriptor);
        this.imgLoader.setDefaultImage(null);
    }

    @Override
    public CommonConsolePage<CommonConsoleViewer> createPageForCommonConsole(IConsoleView view2) {
        CommonConsolePage<CommonConsoleViewer> page = new CommonConsolePage<CommonConsoleViewer>((TextConsole)this, view2){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected CommonConsoleViewer createViewer(Composite parent) {
                Class<Db2CommandConsole> clazz = Db2CommandConsole.class;
                synchronized (Db2CommandConsole.class) {
                    if (cmdInfo == null) {
                        cmdInfo = new Db2CommandInformation();
                        try {
                            cmdInfo.loadFromPath("db2commands.xml");
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    final Db2CommandInformation cmdInfo = Db2CommandConsole.cmdInfo;
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    final CommonConsole.ExposedContentAssistant assistant = new CommonConsole.ExposedContentAssistant();
                    assistant.setInformationControlCreator(new IInformationControlCreator(){

                        public IInformationControl createInformationControl(Shell parent) {
                            return new FmBrowserInformationControl(parent, null, true);
                        }
                    });
                    CommonConsoleViewer viewer = new CommonConsoleViewer(parent, (TextConsole)this.getConsole());
                    viewer.configure(new SourceViewerConfiguration(){

                        public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
                            Db2CommandKeywordProcessor proc = new Db2CommandKeywordProcessor(cmdInfo);
                            Object baseUrl = FMUIPlugin.getDefault().getPreferenceStore().getString("fm.console.db2.infocenter_url").trim();
                            baseUrl = (String)baseUrl + "?topic=%2Fcom.ibm.db2z10.doc.comref%2Fsrc%2Ftpc%2Fdb2z_cmd_";
                            proc.setUrlBuilder(new Db2CommandHtmlHelpBuilder((String)baseUrl));
                            proc.setPartitionType(FmIOConsolePartition.INPUT_PARTITION_TYPE);
                            proc.setHistoryProvider(Db2CommandConsole.this.getHistoryProvider());
                            proc.setImageLoader((this).Db2CommandConsole.this.imgLoader);
                            assistant.setContentAssistProcessor(proc, FmIOConsolePartition.INPUT_PARTITION_TYPE);
                            assistant.setContentAssistProcessor(proc, FmIOConsolePartition.OUTPUT_PARTITION_TYPE);
                            return assistant;
                        }

                        public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
                            PresentationReconciler reconciler = new PresentationReconciler();
                            Db2CommandScanner scanner = new Db2CommandScanner();
                            scanner.setDb2CmdInfo(cmdInfo);
                            scanner.setTokenData(Db2CommandScanner.Db2TokenKey.WHITESPACE, new TextAttribute(null, SafeColorRegistry.instance().get(IFmConsoleConstants.WHITESPACE_BACKGROUND), 0));
                            scanner.setTokenData(Db2CommandScanner.Db2TokenKey.COMMAND, new TextAttribute(SafeColorRegistry.instance().get(IFmConsoleConstants.DB2_COMMAND), null, 1));
                            scanner.setTokenData(Db2CommandScanner.Db2TokenKey.KEYWORD_SEPARATOR, new TextAttribute(SafeColorRegistry.instance().get(IFmConsoleConstants.DB2_KEYWORD_SEPARATOR), null, 0));
                            scanner.setTokenData(Db2CommandScanner.Db2TokenKey.KEYWORD, new TextAttribute(SafeColorRegistry.instance().get(IFmConsoleConstants.DB2_KEYWORD), null, 1));
                            scanner.setTokenData(Db2CommandScanner.Db2TokenKey.PARAMETER, new TextAttribute(SafeColorRegistry.instance().get(IFmConsoleConstants.DB2_PARAMETER), null, 1));
                            scanner.setTokenData(Db2CommandScanner.Db2TokenKey.PARAMETER_CONTAINER, new TextAttribute(SafeColorRegistry.instance().get(IFmConsoleConstants.DB2_PARAMETER_CONTAINER), null, 0));
                            scanner.setTokenData(Db2CommandScanner.Db2TokenKey.PARAMETER_SEPARATOR, new TextAttribute(SafeColorRegistry.instance().get(IFmConsoleConstants.DB2_PARAMETER_CONTAINER), null, 0));
                            DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)scanner);
                            reconciler.setDamager((IPresentationDamager)dr, FmIOConsolePartition.INPUT_PARTITION_TYPE);
                            reconciler.setRepairer((IPresentationRepairer)dr, FmIOConsolePartition.INPUT_PARTITION_TYPE);
                            PartitionStreamTokenScanner partitionScanner = new PartitionStreamTokenScanner();
                            partitionScanner.setStreamTokenData(Db2CommandConsole.this.getStdOut(), new TextAttribute(SafeColorRegistry.instance().get(IFmConsoleConstants.OUTPUT_COLOR)));
                            partitionScanner.setStreamTokenData(Db2CommandConsole.this.getStdErr(), new TextAttribute(SafeColorRegistry.instance().get(IFmConsoleConstants.ERROR_COLOR)));
                            partitionScanner.setStreamTokenData(Db2CommandConsole.this.getStdPrompt(), new TextAttribute(SafeColorRegistry.instance().get(IFmConsoleConstants.PROMPT_COLOR)));
                            DefaultDamagerRepairer outputDr = new DefaultDamagerRepairer((ITokenScanner)partitionScanner);
                            reconciler.setDamager((IPresentationDamager)outputDr, FmIOConsolePartition.OUTPUT_PARTITION_TYPE);
                            reconciler.setRepairer((IPresentationRepairer)outputDr, FmIOConsolePartition.OUTPUT_PARTITION_TYPE);
                            return reconciler;
                        }

                        public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
                            return new String[]{FmIOConsolePartition.OUTPUT_PARTITION_TYPE, FmIOConsolePartition.INPUT_PARTITION_TYPE};
                        }
                    });
                    StyledText textWidget = viewer.getTextWidget();
                    textWidget.addVerifyKeyListener(Db2CommandConsole.this.getConsoleVerifyKeyListener(viewer, assistant));
                    return viewer;
                }
            }

            @Override
            public void dispose() {
                Db2CommandConsole.this.disposeOfPage(this);
                super.dispose();
            }
        };
        this.context = new Db2CommandConsoleContext(view2.getSite());
        this.context.enable();
        return page;
    }

    @Override
    public void handleInput(String input, IHowIsGoing monitor) throws IOException {
        Objects.requireNonNull(input, "Must provide a non-null input");
        try {
            this.getHistoryProvider().addInput(input);
            EclipseUtils.retestEclipseProperty((String)"com.ibm.etools.fm.ui.console", (String)"hasCommandsInHistory");
            XCMD xcmd = new XCMD();
            xcmd.setDb2Command(input);
            this.setExecuting(true);
            this.getStdOut().write(Messages.Console_EXECUTING);
            try {
                try {
                    Throwable throwable = null;
                    Object var5_8 = null;
                    try (CommonConnectionFM conn = this.getConnection(monitor);){
                        Result result = UtilityFunctionRunner.executeAndParse((CommonConnectionFM)conn, (UtilityFunction)xcmd, (UtilityFunctionParser)new XCMDParser(this.getSystem()), (IHowIsGoing)monitor);
                        this.getStdOut().write(" ");
                        this.getStdOut().write(Messages.Console_DONE);
                        this.getStdOut().write("\n");
                        if (result.hasError()) {
                            this.getStdErr().write(result.getMessagesCombined().toString().trim() + "\n");
                        } else {
                            this.getStdOut().write(((StringBuffer)result.getOutput()).toString().trim() + "\n");
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (CommunicationException e) {
                    logger.error((Object)"Failed to execute DB2 console command: ", (Throwable)e);
                    this.getStdErr().write("\n" + MessageFormat.format(Messages.Db2CommandConsole_ERROR_EXEC_COMMAND_X, ThrowableRenderer.renderShortForm((Throwable)e).toString().trim()));
                    this.setExecuting(false);
                }
            }
            finally {
                this.setExecuting(false);
            }
        }
        catch (InterruptedException e) {
            this.getStdErr().write(" " + Messages.Console_INTERRUPTED + "\n");
        }
    }

    @Override
    protected String getPromptText() {
        return this.getSubsystem().getName() + " CMD";
    }

    public Db2Subsystem getSubsystem() {
        return (Db2Subsystem)this.getEndpoint();
    }

    @Override
    protected void dispose() {
        this.imgLoader.dispose();
        this.context.disable();
        super.dispose();
    }
}

