/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.console;

import com.ibm.etools.fm.ui.console.CommonConsole;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import org.eclipse.core.expressions.PropertyTester;

public class ConsolePropertyTester
extends PropertyTester {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(ConsolePropertyTester.class);
    public static final String NAMESPACE = "com.ibm.etools.fm.ui.console";
    public static final String PROPERTY_HAS_HISTORY = "hasCommandsInHistory";
    public static final String PROPERTY_IS_EXECUTING = "isExecuting";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (PROPERTY_HAS_HISTORY.equals(property)) {
            return ConsolePropertyTester.hasCommandsInHistory(receiver);
        }
        if (PROPERTY_IS_EXECUTING.equals(property)) {
            return ConsolePropertyTester.isExecuting(receiver);
        }
        logger.trace((Object)("Can't test for property=" + property));
        return false;
    }

    private static boolean hasCommandsInHistory(Object receiver) {
        if (!(receiver instanceof CommonConsole)) {
            return false;
        }
        CommonConsole console = (CommonConsole)receiver;
        return console.getHistoryProvider().getHistorySize() > 0;
    }

    private static boolean isExecuting(Object receiver) {
        if (!(receiver instanceof CommonConsole)) {
            return false;
        }
        CommonConsole console = (CommonConsole)receiver;
        return console.isExecuting();
    }
}

