/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.console;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ConsoleHistoryProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final int DEFAULT_HISTORY_LIMIT = 100;
    private static final int historyLimit = 100;
    private List<String> inputHistory = new ArrayList<String>();
    private int currIndex = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getHistory() {
        List<String> list = this.inputHistory;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<String>(this.inputHistory));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHistorySize() {
        List<String> list = this.inputHistory;
        synchronized (list) {
            return this.inputHistory.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addInput(String input) {
        boolean added;
        Objects.requireNonNull(input, "Must provide a non-null input");
        List<String> list = this.inputHistory;
        synchronized (list) {
            block6: {
                if (this.inputHistory.size() <= 0 || !this.inputHistory.get(this.inputHistory.size() - 1).equals(input)) break block6;
                return false;
            }
            added = this.inputHistory.add(input);
            if (added) {
                this.currIndex = this.inputHistory.size();
            }
            while (this.inputHistory.size() > 100) {
                this.inputHistory.remove(0);
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String currentInput() {
        List<String> list = this.inputHistory;
        synchronized (list) {
            block4: {
                if (this.currIndex != this.inputHistory.size()) break block4;
                return "";
            }
            return this.inputHistory.get(this.currIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String prevInput() {
        List<String> list = this.inputHistory;
        synchronized (list) {
            --this.currIndex;
            if (this.currIndex < 0) {
                this.currIndex = 0;
            }
            return this.currentInput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String nextInput() {
        List<String> list = this.inputHistory;
        synchronized (list) {
            ++this.currIndex;
            if (this.currIndex > this.inputHistory.size()) {
                this.currIndex = this.inputHistory.size();
            }
            return this.currentInput();
        }
    }

    public int getLimit() {
        return 100;
    }

    public String toString() {
        return "CHP current: " + this.currentInput() + " - " + this.inputHistory.toString();
    }
}

