/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.console;

import com.ibm.etools.fm.ui.console.CommonConsole;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import com.ibm.pdtools.common.component.ui.util.EclipseUtils;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.menus.AbstractContributionFactory;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.services.IServiceLocator;

public class ConsoleCommandHistoryContributionFactory
extends AbstractContributionFactory {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int MAX_COMMANDS_SHOWN = 10;

    public ConsoleCommandHistoryContributionFactory() {
        super("menu:com.ibm.etools.fm.ui.commands.db2.console.historyPick", null);
    }

    public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
        Object console = EclipseUtils.getVariableValue((String)"com.ibm.etools.fm.activeConsole");
        if (!(console instanceof CommonConsole)) {
            PDLogger.get(((Object)((Object)this)).getClass()).trace((Object)"Can't get contribution items since value of com.ibm.etools.fm.activeConsole variable is not an instance of CommonConsole");
            return;
        }
        CommonConsole commonConsole = (CommonConsole)console;
        ArrayList<String> history = new ArrayList<String>(commonConsole.getHistoryProvider().getHistory());
        int histSize = history.size();
        int i = 0;
        while (i < Math.min(10, histSize)) {
            CommandHistoryPickAction action = new CommandHistoryPickAction(commonConsole, (String)history.get(histSize - i - 1));
            additions.addContributionItem((IContributionItem)new ActionContributionItem((IAction)action), null);
            ++i;
        }
    }

    private static class CommandHistoryPickAction
    extends Action {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private final String historyItem;
        private final CommonConsole commonConsole;

        public CommandHistoryPickAction(CommonConsole commonConsole, String historyItem) {
            super(StringUtils.NEWLINE_CHARACTERS.matcher(historyItem).replaceAll(" "));
            this.commonConsole = commonConsole;
            this.historyItem = historyItem;
        }

        public void run() {
            this.commonConsole.typeTextAsUser(this.historyItem);
        }
    }
}

