/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.console;

import com.ibm.etools.fm.core.Messages;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class CommonConsoleProcessInputJob
extends Job {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(CommonConsoleProcessInputJob.class);
    private final InputStream inputStream;
    private ConsoleIOHandler ioHandler;

    public CommonConsoleProcessInputJob(InputStream is) {
        super(Messages.CommonConsoleProcessInputJob_CONSOLE_INPUT_HANDLER);
        this.inputStream = Objects.requireNonNull(is, "Must provide a non-null is");
        this.setSystem(true);
    }

    public void setIOHandler(ConsoleIOHandler ioHandler) {
        this.ioHandler = Objects.requireNonNull(ioHandler, "Must provide a non-null ioHandler");
    }

    public ConsoleIOHandler getIoHandler() {
        return this.ioHandler;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
            byte[] buff = new byte[1024];
            int read = 0;
            while (read >= 0 && !monitor.isCanceled()) {
                boolean showPrompt;
                StringBuffer userInput = new StringBuffer();
                read = this.inputStream.read(buff);
                if (read > 0) {
                    userInput.append(new String(buff, 0, read));
                }
                if (!(showPrompt = this.processInput(userInput, howIsGoing)) || monitor.isCanceled()) continue;
                this.ioHandler.displayPrompt();
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        return Status.OK_STATUS;
    }

    protected boolean processInput(StringBuffer userInput, IHowIsGoing monitor) throws IOException {
        int newlinePos = userInput.indexOf("\n");
        while (newlinePos >= 0) {
            String inputLine = userInput.substring(0, newlinePos).trim();
            if (!inputLine.isEmpty()) {
                this.getIoHandler().handleInput(inputLine, monitor);
            }
            userInput = new StringBuffer(userInput.substring(newlinePos + 1));
            newlinePos = userInput.indexOf("\n");
        }
        return userInput.length() == 0;
    }

    public static interface ConsoleIOHandler {
        public void handleInput(String var1, IHowIsGoing var2) throws IOException;

        public void displayPrompt() throws IOException;
    }
}

