/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.console;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.console.CommonConsole;
import com.ibm.etools.fm.ui.console.StringSelectionDialog;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.handlers.HandlerUtil;

public class CommonConsoleHistoryPickHandler
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String COMMAND_ID = "com.ibm.etools.fm.ui.commands.db2.console.historyPick";
    public static final String PARAMETER_ITEM_ID = "com.ibm.etools.fm.ui.commands.db2.console.historyPick.item";

    protected void handle(ExecutionEvent event) throws ExecutionException {
        IConsole activeConsole;
        IWorkbenchPart activePart = HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        if (activePart instanceof IConsoleView && (activeConsole = ((IConsoleView)activePart).getConsole()) instanceof CommonConsole) {
            CommonConsole commonConsole = (CommonConsole)activeConsole;
            String settingsId = StringSelectionDialog.class.getCanonicalName() + commonConsole.getClass().getCanonicalName() + "History";
            IDialogSettings settings = FMUIPlugin.getDefault().getOrCreateDialogSettingsSection(settingsId);
            StringSelectionDialog dialog = new StringSelectionDialog(settings);
            dialog.setItems(commonConsole.getHistoryProvider().getHistory());
            dialog.setTitle(Messages.CommonConsoleHistoryPickHandler_SELECT_ITEM_CONSOLE_HISTORY);
            dialog.setInitialPattern("**");
            dialog.setListLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element == null) {
                        return "";
                    }
                    return StringUtils.NEWLINE_CHARACTERS.matcher(element.toString()).replaceAll(" ");
                }
            });
            if (dialog.open() == 0) {
                commonConsole.typeTextAsUser(dialog.getFirstResult().toString());
            }
        }
    }
}

