/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.console;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.Db2SubsystemProvider;
import com.ibm.etools.fm.core.socket.io.CommonConnectionFM;
import com.ibm.etools.fm.core.socket.io.ConnPoolManagerFM;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.console.CommonConsolePage;
import com.ibm.etools.fm.ui.console.CommonConsoleProcessInputJob;
import com.ibm.etools.fm.ui.console.CommonConsoleViewer;
import com.ibm.etools.fm.ui.console.ConsoleHistoryProvider;
import com.ibm.etools.fm.ui.console.FmIOConsole;
import com.ibm.etools.fm.ui.console.FmIOConsoleOutputStream;
import com.ibm.etools.fm.ui.console.FmIOConsolePartition;
import com.ibm.pdtools.common.component.core.model.PDHost;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventType;
import com.ibm.pdtools.common.component.jhost.registery.HostRegistry;
import com.ibm.pdtools.common.component.jhost.registery.RegistryLocator;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.EclipseUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.part.IPageBookViewPage;

public abstract class CommonConsole
extends FmIOConsole
implements CommonConsoleProcessInputJob.ConsoleIOHandler,
IHostProvider {
    private static Map<CommonConsole, List<CommonConsolePage<CommonConsoleViewer>>> consolePages = Collections.synchronizedMap(new HashMap());
    private final Db2SubsystemProvider endpoint;
    private Job processInputJob;
    private FmIOConsoleOutputStream stdOut;
    private FmIOConsoleOutputStream stdPrompt;
    private FmIOConsoleOutputStream stdErr;
    private ConsoleHistoryProvider historyProvider = new ConsoleHistoryProvider();
    private HostRegistry hostRegistry;
    private EListener<EntityEvent<IPDHost>> hostListener;
    private final AtomicBoolean isExecuting = new AtomicBoolean(false);

    private static List<CommonConsolePage<CommonConsoleViewer>> getPages(CommonConsole console) {
        List<CommonConsolePage<CommonConsoleViewer>> knownPages = consolePages.get(console);
        if (knownPages == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(knownPages);
    }

    public CommonConsole(Db2SubsystemProvider endpoint, String name, String consoleType, ImageDescriptor imageDescriptor) {
        super(name, consoleType, imageDescriptor);
        this.endpoint = endpoint;
        this.hostRegistry = RegistryLocator.instance().getHostRegistry();
        this.hostListener = new EListener<EntityEvent<IPDHost>>(){

            public void onEvent(EntityEvent<IPDHost> event) {
                if (((IPDHost)event.getEntity()).equals(CommonConsole.this.endpoint.getSystem()) && (event.getType() == EntityEventType.REMOVED || event.getType() == EntityEventType.CHANGED && PDHost.getPropertyHostPort().equals(event.getDetail()))) {
                    logger.trace((Object)"Host was removed or hostname/port was modified, closing console");
                    ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{CommonConsole.this});
                }
            }
        };
        this.hostRegistry.addListener(this.hostListener);
        this.stdOut = this.newOutputStream();
        this.stdPrompt = this.newOutputStream();
        this.stdErr = this.newOutputStream();
        this.processInputJob = this.getInputProcessingJob();
        final Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                display.timerExec(50, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CommonConsole.this.displayPrompt();
                        }
                        catch (IOException e) {
                            logger.error((Throwable)e);
                        }
                        (this).CommonConsole.this.processInputJob.schedule();
                    }
                });
            }
        });
    }

    protected Job getInputProcessingJob() {
        CommonConsoleProcessInputJob job = new CommonConsoleProcessInputJob(this.getInputStream());
        job.setIOHandler(this);
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IPageBookViewPage createPage(IConsoleView view2) {
        CommonConsolePage<CommonConsoleViewer> page = this.createPageForCommonConsole(view2);
        Map<CommonConsole, List<CommonConsolePage<CommonConsoleViewer>>> map = consolePages;
        synchronized (map) {
            List<CommonConsolePage<CommonConsoleViewer>> knownPages = consolePages.get(this);
            if (knownPages == null) {
                knownPages = new ArrayList<CommonConsolePage<CommonConsoleViewer>>();
                consolePages.put(this, knownPages);
            }
            knownPages.add(page);
        }
        return page;
    }

    protected abstract CommonConsolePage<CommonConsoleViewer> createPageForCommonConsole(IConsoleView var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeOfPage(CommonConsolePage<?> page) {
        Map<CommonConsole, List<CommonConsolePage<CommonConsoleViewer>>> map = consolePages;
        synchronized (map) {
            List<CommonConsolePage<CommonConsoleViewer>> knownPages = consolePages.get(this);
            knownPages.remove(page);
            if (knownPages.isEmpty()) {
                consolePages.remove(this);
            }
        }
    }

    @Override
    public void clearConsole() {
        super.clearConsole();
        try {
            this.displayPrompt();
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
    }

    @Override
    public void displayPrompt() throws IOException {
        this.getStdPrompt().write(this.getPromptText() + "> ");
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                CommonConsole.this.moveCursorToPosition(InputPartitionPosition.PARTITION_HOME, false, 200);
            }
        });
    }

    protected abstract String getPromptText();

    protected VerifyKeyListener getConsoleVerifyKeyListener(final CommonConsoleViewer viewer, final ExposedContentAssistant assistant) {
        return new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                boolean inInputPartition;
                boolean controlKeyDown = (event.stateMask & 0x40000) != 0;
                boolean shiftKeyDown = (event.stateMask & 0x20000) != 0;
                int cursorPos = viewer.getSelectedRange().x;
                FmIOConsolePartition cursorPartition = viewer.getFmConsolePartitionAt(cursorPos);
                boolean bl = inInputPartition = !cursorPartition.isReadOnly() || cursorPos == viewer.getDocument().getLength();
                if (event.keyCode == 9 && !controlKeyDown) {
                    if (!inInputPartition) {
                        CommonConsole.moveCursorToPosition(viewer, InputPartitionPosition.PARTITION_HOME, false);
                    } else if (assistant != null) {
                        assistant.completePrefix();
                    }
                    event.doit = false;
                } else if (event.keyCode == 0x1000007 && inInputPartition) {
                    CommonConsole.moveCursorToPosition(viewer, controlKeyDown ? InputPartitionPosition.PARTITION_HOME : InputPartitionPosition.LINE_HOME, shiftKeyDown);
                    event.doit = false;
                } else if (event.keyCode == 0x1000008 && inInputPartition) {
                    CommonConsole.moveCursorToPosition(viewer, controlKeyDown ? InputPartitionPosition.PARTITION_END : InputPartitionPosition.LINE_END, shiftKeyDown);
                    event.doit = false;
                } else if (event.keyCode == 0x1000001 && controlKeyDown && (assistant == null || !assistant.isProposalPopupActive())) {
                    int offset = viewer.getDocument().getLength();
                    int length = 0;
                    FmIOConsolePartition partition = viewer.getFmConsolePartitionAt(offset);
                    if (!partition.isReadOnly()) {
                        offset = partition.getOffset();
                        length = partition.getLength();
                    }
                    if (cursorPos < offset || cursorPos > offset + length) {
                        return;
                    }
                    String prevInput = CommonConsole.this.historyProvider.prevInput();
                    try {
                        viewer.getDocument().replace(offset, length, prevInput);
                        event.doit = false;
                    }
                    catch (BadLocationException e) {
                        logger.error((Throwable)e);
                    }
                } else if (event.keyCode == 0x1000002 && controlKeyDown && (assistant == null || !assistant.isProposalPopupActive())) {
                    int offset = viewer.getDocument().getLength();
                    int length = 0;
                    FmIOConsolePartition partition = viewer.getFmConsolePartitionAt(offset);
                    if (!partition.isReadOnly()) {
                        offset = partition.getOffset();
                        length = partition.getLength();
                    }
                    if (cursorPos < offset || cursorPos > offset + length) {
                        return;
                    }
                    String prevInput = CommonConsole.this.historyProvider.nextInput();
                    try {
                        viewer.getDocument().replace(offset, length, prevInput);
                        event.doit = false;
                    }
                    catch (BadLocationException e) {
                        logger.error((Throwable)e);
                    }
                }
            }
        };
    }

    public void typeTextAsUser(String text2) {
        List<CommonConsolePage<CommonConsoleViewer>> pages = CommonConsole.getPages(this);
        if (pages.isEmpty()) {
            logger.trace((Object)("Can't insert user text: console has no pages; text=" + text2));
            return;
        }
        CommonConsolePage<CommonConsoleViewer> latestFocussedPage = pages.get(0);
        long latestFocus = latestFocussedPage.getLastFocusTime();
        for (CommonConsolePage<CommonConsoleViewer> page : pages) {
            long pageLastFocus = page.getLastFocusTime();
            if (pageLastFocus <= latestFocus) continue;
            latestFocussedPage = page;
            latestFocus = pageLastFocus;
        }
        CommonConsoleViewer viewer = (CommonConsoleViewer)latestFocussedPage.getViewer();
        Point selRange = viewer.getSelectedRange();
        int offset = selRange.x;
        int len = selRange.y;
        IDocument doc = viewer.getDocument();
        FmIOConsolePartition partition = viewer.getFmConsolePartitionAt(offset);
        if (partition.isReadOnly() || partition.getOffset() + partition.getLength() < offset + len) {
            offset = doc.getLength();
            len = 0;
        }
        try {
            doc.replace(offset, len, text2);
        }
        catch (BadLocationException e) {
            logger.error((Throwable)e);
        }
        viewer.setSelectedRange(offset + text2.length(), 0);
    }

    public void moveCursorToPosition(final InputPartitionPosition pos, final boolean doSelection, int delay) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                List<CommonConsolePage<CommonConsoleViewer>> pages = CommonConsole.getPages(CommonConsole.this);
                for (CommonConsolePage<CommonConsoleViewer> commonConsolePage : pages) {
                    CommonConsole.moveCursorToPosition((CommonConsoleViewer)commonConsolePage.getViewer(), pos, doSelection);
                }
            }
        };
        if (delay == 0) {
            r.run();
        } else {
            Display.getDefault().timerExec(delay, r);
        }
    }

    private static void moveCursorToPosition(CommonConsoleViewer viewer, InputPartitionPosition pos, boolean doSelection) {
        int newSelOffset;
        Point currentSel = viewer.getSelectedRange();
        int selStart = currentSel.x;
        int selEnd = currentSel.x + currentSel.y;
        int cursorPos = -1;
        StyledText styledText = viewer.getTextWidget();
        if (styledText != null) {
            cursorPos = styledText.getCaretOffset();
        }
        if (cursorPos == selStart) {
            int tmp = selStart;
            selStart = selEnd;
            selEnd = tmp;
        }
        FmIOConsolePartition targetPartition = viewer.getFmConsolePartitionAt(viewer.getDocument().getLength());
        switch (pos) {
            case LINE_HOME: 
            case LINE_END: {
                if (targetPartition.isReadOnly()) {
                    newSelOffset = viewer.getDocument().getLength();
                    break;
                }
                String partitionText = targetPartition.getString();
                String[] lines = partitionText.split(Pattern.quote(FMUIPlugin.NEWLINE_CHARS));
                newSelOffset = targetPartition.getOffset();
                int i = 0;
                while (newSelOffset + lines[i].length() < selEnd) {
                    newSelOffset += lines[i].length() + FMUIPlugin.NEWLINE_CHARS.length();
                    ++i;
                }
                if (pos != InputPartitionPosition.LINE_END) break;
                newSelOffset += lines[i].length();
                break;
            }
            case PARTITION_HOME: {
                if (targetPartition.isReadOnly()) {
                    newSelOffset = viewer.getDocument().getLength();
                    break;
                }
                newSelOffset = targetPartition.getOffset();
                break;
            }
            case PARTITION_END: {
                newSelOffset = viewer.getDocument().getLength();
                break;
            }
            default: {
                throw new IllegalArgumentException(pos.name());
            }
        }
        selEnd = newSelOffset;
        if (!doSelection) {
            selStart = selEnd;
        }
        viewer.setSelectedRange(selStart, selEnd - selStart);
    }

    public FmIOConsoleOutputStream getStdOut() {
        return this.stdOut;
    }

    public FmIOConsoleOutputStream getStdPrompt() {
        return this.stdPrompt;
    }

    public FmIOConsoleOutputStream getStdErr() {
        return this.stdErr;
    }

    protected Db2SubsystemProvider getEndpoint() {
        return this.endpoint;
    }

    public IPDHost getSystem() {
        return this.endpoint.getSystem();
    }

    protected ConsoleHistoryProvider getHistoryProvider() {
        return this.historyProvider;
    }

    public boolean isExecuting() {
        return this.isExecuting.get();
    }

    protected void setExecuting(boolean isExecuting) {
        this.isExecuting.set(isExecuting);
        EclipseUtils.retestEclipseProperty((String)"com.ibm.etools.fm.ui.console", (String)"isExecuting");
    }

    protected synchronized CommonConnectionFM getConnection(IHowIsGoing monitor) throws InterruptedException, CommunicationException {
        final AtomicBoolean done = new AtomicBoolean(false);
        final AtomicReference connRef = new AtomicReference();
        final AtomicReference errorRef = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        Job prepConnectionJob = new Job(Messages.CommonConsole_CONNECTING_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                        boolean isClosed = false;
                        if (connRef.get() == null || (isClosed = ((CommonConnectionFM)connRef.get()).isClosed(howIsGoing))) {
                            if (isClosed) {
                                ((CommonConnectionFM)connRef.get()).unlock();
                                connRef.set(null);
                            }
                            connRef.set((CommonConnectionFM)ConnPoolManagerFM.instance().getConnection(CommonConsole.this.getSystem(), (IPDConnectEndpoint)CommonConsole.this.endpoint.getSubsystem(), howIsGoing));
                        }
                    }
                    catch (Exception e) {
                        errorRef.set(e);
                        done.set(true);
                        latch.countDown();
                    }
                }
                finally {
                    done.set(true);
                    latch.countDown();
                }
                return Status.OK_STATUS;
            }
        };
        prepConnectionJob.schedule();
        while (!done.get()) {
            latch.await(250L, TimeUnit.MILLISECONDS);
            if (!monitor.isCanceled()) continue;
            prepConnectionJob.cancel();
        }
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        Throwable e = (Throwable)errorRef.get();
        if (e instanceof InterruptedException) {
            logger.trace((Object)"Throwing interrupted exception");
            throw (InterruptedException)e;
        }
        if (e instanceof CommunicationException) {
            logger.trace((Object)"Throwing communication exception");
            throw (CommunicationException)e;
        }
        if (e != null) {
            throw new RuntimeException(e);
        }
        return (CommonConnectionFM)connRef.get();
    }

    @Override
    protected void dispose() {
        this.processInputJob.cancel();
        this.hostRegistry.removeListener(this.hostListener);
        super.dispose();
    }

    public static class ExposedContentAssistant
    extends ContentAssistant {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        public boolean isProposalPopupActive() {
            return super.isProposalPopupActive();
        }
    }

    public static enum InputPartitionPosition {
        LINE_HOME,
        LINE_END,
        PARTITION_HOME,
        PARTITION_END;

    }
}

