/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.api;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.ui.views.systems.handlers.OpenFormatted;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.BaseStartPosType;
import com.ibm.pdtools.common.component.core.model.PDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.PDHostJhost;
import com.ibm.pdtools.common.component.ui.dialog.SystemLookupDialog;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;

public class FormattedEditorAPIHandler
extends SkeletonHandler {
    public static final String PARAM_HOSTNAME = "param.hostname";
    public static final String PARAM_PORT = "param.port";
    public static final String PARAM_RESOURCE = "param.resource";
    public static final String PARAM_TEMPLATE = "param.template";
    public static final String PARAM_POSITION = "param.position";
    public static final String PARAM_POSITION_TYPE = "param.position.type";
    public static final String PARAM_CREATEHOST = "param.createhost";
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2014, 2017. All rights reserved.";
    public static final String ID = "com.ibm.etools.fm.ui.editor.openFormattedAPI";
    protected static final PDLogger logger = PDLogger.get(FormattedEditorAPIHandler.class);

    static void openFormattedEditor(String hostName, int port, String resource, String templateDataSetName, String position, BaseStartPosType positionType) {
        SystemLookupDialog dialog;
        List systems = PDHostJhost.findPDHosts((String)hostName, (int)port, (boolean)true);
        IPDHost system = null;
        if (systems.size() == 0) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.FileManagerFormattedEditorService_HostNotFound, hostName, port));
        }
        if (systems.size() == 1) {
            system = (IPDHost)systems.get(0);
        } else if (systems.size() > 1 && (dialog = SystemLookupDialog.getSystemLookupDialogForHosts((String)hostName)).open() == 0) {
            system = dialog.getSelectedHost();
        }
        if (system != null) {
            FormattedEditorAPIHandler.openFormattedEditor(system, resource, templateDataSetName, position, positionType);
        }
    }

    static void openFormattedEditorCreateHost(String hostName, int port, String resource, String templateDataSetName, String position, BaseStartPosType positionType) {
        PDHost system = PDHost.create((String)hostName, (String)hostName, (int)port);
        FormattedEditorAPIHandler.openFormattedEditor((IPDHost)system, resource, templateDataSetName, position, positionType);
    }

    private static void openFormattedEditor(IPDHost system, String resource, String templateDataSetName, String position, BaseStartPosType positionType) {
        Objects.requireNonNull(system, "Must provide a non-null system.");
        Objects.requireNonNull(resource, "Must provide a non-null resource.");
        logger.info((Object)MessageFormat.format("Opening formatted editor: system {0} resource: {1} ", system, resource));
        if (ZRLs.isParseable((IPDHost)system, (String)resource)) {
            if (templateDataSetName != null && ZRLs.isParseable((IPDHost)system, (String)templateDataSetName)) {
                OpenFormatted.showFormattedEditorDialog(system, ZRLs.parseZRL((IPDHost)system, (String)resource), (IZRL)Member.parse((IPDHost)system, (String)templateDataSetName), position, positionType);
            }
        } else {
            throw new IllegalArgumentException(MessageFormat.format(Messages.FileManagerFormattedEditorService_resourceBad, resource));
        }
        OpenFormatted.showFormattedEditorDialog(system, ZRLs.parseZRL((IPDHost)system, (String)resource), null, position, positionType);
    }

    protected void handle(ExecutionEvent event) throws ExecutionException {
        String host = event.getParameter(PARAM_HOSTNAME);
        String port = event.getParameter(PARAM_PORT);
        String resource = event.getParameter(PARAM_RESOURCE);
        String template = event.getParameter(PARAM_TEMPLATE);
        String position = event.getParameter(PARAM_POSITION);
        String positionType = event.getParameter(PARAM_POSITION_TYPE);
        String createHost = event.getParameter(PARAM_CREATEHOST);
        if (host != null && port != null && resource != null) {
            BaseStartPosType posType;
            int portNum = Integer.parseInt(port);
            BaseStartPosType baseStartPosType = posType = positionType == null ? null : BaseStartPosType.valueOf((String)positionType);
            if (createHost != null && "true".equals(createHost)) {
                FormattedEditorAPIHandler.openFormattedEditorCreateHost(host, portNum, resource, template, position, posType);
            } else {
                FormattedEditorAPIHandler.openFormattedEditor(host, portNum, resource, template, position, posType);
            }
        } else {
            PDDialogs.openErrorThreadSafe((String)Messages.FileManagerFormattedEditorService_MissingParameters, (String)event.getParameters().toString());
        }
    }
}

