/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui;

import com.ibm.etools.fm.core.FMCorePlugin;
import com.ibm.etools.fm.ui.console.ConsoleCommandHistoryContributionFactory;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.views.systems.handlers.ActionHistoryContributionFactory;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.PDFileSystemUtil;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.RunTempEntry;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.util.ArrayUtils;
import com.ibm.pdtools.common.component.ui.util.EclipseUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.AbstractContributionFactory;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class FMUIPlugin
extends AbstractUIPlugin {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private PDLogger _private_logger;
    public static final String PLUGIN_ID = "com.ibm.etools.fm.ui";
    public static final String LOOKUP_RESOURCE_ICON = "icons/search.gif";
    public static final String IMS_CUSTOMIZE_SUBSYSTEM_CONFIG_ICON = "icons/ims_customize_subsystem_config.gif";
    public static final String NEW_NAME_SUFFIX = "NEW";
    public static final String NEWLINE_CHARS = System.getProperty("line.separator");
    private static FMUIPlugin plugin = null;
    private ArrayList<IZRL> templateEditSessionList;
    private ArrayList<IZRL> dsEditSessionList;
    private ArrayList<RunTempEntry> runTempEntryList;
    private EListener<String> corePrefChangeListener = new EListener<String>(){

        public void onEvent(String event) {
            if ("fm.version.mismatch".equals(event)) {
                FMUIPlugin.this.getPreferenceStore().setValue("fm.version.mismatch", FMCorePlugin.isReportingVersionIncompatibility());
            }
        }
    };

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        reg.put("icons/excluded_icon.gif", FMUIPlugin.getImageDescriptor("icons/excluded_icon.gif"));
        reg.put("icons/SuppressRecord_1.gif", FMUIPlugin.getImageDescriptor("icons/SuppressRecord_1.gif"));
        reg.put("icons/unselected_icon.gif", FMUIPlugin.getImageDescriptor("icons/unselected_icon.gif"));
        reg.put("icons/sort.gif", FMUIPlugin.getImageDescriptor("icons/sort.gif"));
        reg.put("icons/convertto_hexdec2.gif", FMUIPlugin.getImageDescriptor("icons/convertto_hexdec2.gif"));
        reg.put("icons/applyTemplate.gif", FMUIPlugin.getImageDescriptor("icons/applyTemplate.gif"));
        reg.put("icons/run.gif", FMUIPlugin.getImageDescriptor("icons/run.gif"));
        reg.put("icons/windowup.gif", FMUIPlugin.getImageDescriptor("icons/windowup.gif"));
        reg.put("icons/windowdown.gif", FMUIPlugin.getImageDescriptor("icons/windowdown.gif"));
        reg.put("icons/windowright.gif", FMUIPlugin.getImageDescriptor("icons/windowright.gif"));
        reg.put("icons/windowleft.gif", FMUIPlugin.getImageDescriptor("icons/windowleft.gif"));
        reg.put(LOOKUP_RESOURCE_ICON, FMUIPlugin.getImageDescriptor(LOOKUP_RESOURCE_ICON));
        reg.put("icons/tgl_obj_1-2c.gif", FMUIPlugin.getImageDescriptor("icons/tgl_obj_1-2c.gif"));
        reg.put("icons/UnselectedRecord_1.gif", FMUIPlugin.getImageDescriptor("icons/UnselectedRecord_1.gif"));
        reg.put("icons/resetExclude.gif", FMUIPlugin.getImageDescriptor("icons/resetExclude.gif"));
        reg.put("icons/NewRecord.gif", FMUIPlugin.getImageDescriptor("icons/NewRecord.gif"));
        reg.put("icons/ChangedRecord.gif", FMUIPlugin.getImageDescriptor("icons/ChangedRecord.gif"));
        reg.put("icons/delete.gif", FMUIPlugin.getImageDescriptor("icons/delete.gif"));
        reg.put("icons/refresh.gif", FMUIPlugin.getImageDescriptor("icons/refresh.gif"));
        reg.put("icons/SelectedRecord_1.gif", FMUIPlugin.getImageDescriptor("icons/SelectedRecord_1.gif"));
        reg.put("icons/SuppressRecord_1.gif", FMUIPlugin.getImageDescriptor("icons/SuppressRecord_1.gif"));
        reg.put("icons/switch.gif", FMUIPlugin.getImageDescriptor("icons/switch.gif"));
        reg.put("icons/switch.gif", FMUIPlugin.getImageDescriptor("icons/switch.gif"));
        reg.put("icons/UnselectedRecord_2.gif", FMUIPlugin.getImageDescriptor("icons/UnselectedRecord_2.gif"));
        reg.put("icons/sqlErr.gif", FMUIPlugin.getImageDescriptor("icons/sqlErr.gif"));
        reg.put("icons/redit.gif", FMUIPlugin.getImageDescriptor("icons/redit.gif"));
        reg.put("icons/tree/action_history/formattededit.gif", FMUIPlugin.getImageDescriptor("icons/tree/action_history/formattededit.gif"));
        reg.put("icons/add.gif", FMUIPlugin.getImageDescriptor("icons/add.gif"));
        reg.put("icons/moveup.gif", FMUIPlugin.getImageDescriptor("icons/moveup.gif"));
        reg.put("icons/movedown.gif", FMUIPlugin.getImageDescriptor("icons/movedown.gif"));
        reg.put("icons/editfield.gif", FMUIPlugin.getImageDescriptor("icons/editfield.gif"));
        reg.put("icons/selectall.png", FMUIPlugin.getImageDescriptor("icons/selectall.png"));
        reg.put("icons/deselectall.png", FMUIPlugin.getImageDescriptor("icons/deselectall.png"));
        reg.put("icons/hierarchy.gif", FMUIPlugin.getImageDescriptor("icons/hierarchy.gif"));
        reg.put("icons/criteriaWiz.gif", FMUIPlugin.getImageDescriptor("icons/criteriaWiz.gif"));
        reg.put("icons/criteriaWriter.gif", FMUIPlugin.getImageDescriptor("icons/criteriaWriter.gif"));
        reg.put("icons/criteriaClear.gif", FMUIPlugin.getImageDescriptor("icons/criteriaClear.gif"));
        reg.put("icons/add.gif", FMUIPlugin.getImageDescriptor("icons/add.gif"));
        reg.put("icons/duplicate.gif", FMUIPlugin.getImageDescriptor("icons/duplicate.gif"));
        reg.put("icons/delete.gif", FMUIPlugin.getImageDescriptor("icons/delete.gif"));
        reg.put("icons/moveup.gif", FMUIPlugin.getImageDescriptor("icons/moveup.gif"));
        reg.put("icons/movedown.gif", FMUIPlugin.getImageDescriptor("icons/movedown.gif"));
        reg.put("icons/editfield.gif", FMUIPlugin.getImageDescriptor("icons/editfield.gif"));
        reg.put("icons/map.gif", FMUIPlugin.getImageDescriptor("icons/map.gif"));
        reg.put("icons/unmap.gif", FMUIPlugin.getImageDescriptor("icons/unmap.gif"));
        reg.put("icons/load_mapping.gif", FMUIPlugin.getImageDescriptor("icons/load_mapping.gif"));
        reg.put("icons/regenerate_mapping.gif", FMUIPlugin.getImageDescriptor("icons/regenerate_mapping.gif"));
        reg.put("icons/save_edit.gif", FMUIPlugin.getImageDescriptor("icons/save_edit.gif"));
        reg.put("icons/saveas_edit.gif", FMUIPlugin.getImageDescriptor("icons/saveas_edit.gif"));
        reg.put("icons/attributes.gif", FMUIPlugin.getImageDescriptor("icons/attributes.gif"));
        reg.put("icons/templateEditor.gif", FMUIPlugin.getImageDescriptor("icons/templateEditor.gif"));
        reg.put("icons/menus/createTemplate.gif", FMUIPlugin.getImageDescriptor("icons/menus/createTemplate.gif"));
        reg.put("icons/hold.gif", FMUIPlugin.getImageDescriptor("icons/hold.gif"));
        reg.put("icons/selection.gif", FMUIPlugin.getImageDescriptor("icons/selection.gif"));
        reg.put("icons/duplicate.gif", FMUIPlugin.getImageDescriptor("icons/duplicate.gif"));
        reg.put(LOOKUP_RESOURCE_ICON, FMUIPlugin.getImageDescriptor(LOOKUP_RESOURCE_ICON));
        reg.put(IMS_CUSTOMIZE_SUBSYSTEM_CONFIG_ICON, FMUIPlugin.getImageDescriptor(IMS_CUSTOMIZE_SUBSYSTEM_CONFIG_ICON));
        reg.put("icons/load.gif", FMUIPlugin.getImageDescriptor("icons/load.gif"));
        reg.put("icons/encoding.gif", FMUIPlugin.getImageDescriptor("icons/encoding.gif"));
        reg.put("icons/dates.gif", FMUIPlugin.getImageDescriptor("icons/dates.gif"));
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        Objects.requireNonNull(path, "Must provide a non-null path.");
        return FMUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public ISelection getSelection() {
        return this.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.dsEditSessionList = new ArrayList();
        this.templateEditSessionList = new ArrayList();
        this.runTempEntryList = new ArrayList();
        EclipseUtils.addMenuContributionFactory((AbstractContributionFactory)new ActionHistoryContributionFactory());
        EclipseUtils.addMenuContributionFactory((AbstractContributionFactory)new ConsoleCommandHistoryContributionFactory());
        FMCorePlugin.addPreferenceChangeListener(this.corePrefChangeListener);
        FMCorePlugin.setReportingVersionIncompatibility((boolean)FMUIPlugin.getDefault().getPreferenceStore().getBoolean("fm.version.mismatch"));
        FMCorePlugin.setDb2RtrimCreatorInWhere((boolean)FMUIPlugin.getDefault().getPreferenceStore().getBoolean("fm.db2.rtrim.creator.in.where"));
        FMCorePlugin.setDb2RtrimCreatorInTree((boolean)FMUIPlugin.getDefault().getPreferenceStore().getBoolean("fm.db2.rtrim.creator.in.tree"));
        FMCorePlugin.setDb2UppercaseTranslation((boolean)FMUIPlugin.getDefault().getPreferenceStore().getBoolean("fm.db2.object.uppercase.translation"));
        PDLogger.getBundleInfoLog((String)((Object)((Object)this)).getClass().getCanonicalName()).logBundleInfo(context.getBundle());
        PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

            public void postShutdown(IWorkbench arg0) {
            }

            public boolean preShutdown(IWorkbench workbench, boolean arg1) {
                IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
                int n = iWorkbenchWindowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IEditorReference[] iEditorReferenceArray = window.getActivePage().getEditorReferences();
                    int n3 = iEditorReferenceArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IEditorReference editorReference = iEditorReferenceArray[n4];
                        try {
                            FileEditorInput fileInput;
                            IPath fullPath;
                            IEditorInput editorInput = editorReference.getEditorInput();
                            if (editorInput instanceof FileEditorInput && (fullPath = (fileInput = (FileEditorInput)editorInput).getFile().getFullPath()).segmentCount() > 2 && fullPath.segment(0).equals("FM") && fullPath.segment(1).equals("TMP") && fullPath.segment(2).startsWith("tmp")) {
                                window.getActivePage().closeEditor(editorReference.getEditor(false), false);
                            }
                        }
                        catch (Exception e) {
                            FMUIPlugin.this.getLogger().error((Object)("Exception thrown while closing temporary editors. Exception: " + e.getMessage()));
                        }
                        ++n4;
                    }
                    ++n2;
                }
                return true;
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        FMTreeContentHolder.getInstance().saveQueries();
        plugin = null;
        FMCorePlugin.removePreferenceChangeListener(this.corePrefChangeListener);
        try {
            PDFileSystemUtil.deleteAllTemporaryFiles((String)"FM");
        }
        catch (NullPointerException e) {
            this.getLogger().error((Object)("Error: exception thrown while deleting temporary File Manager Files." + String.valueOf(e)));
        }
        super.stop(context);
    }

    public static FMUIPlugin getDefault() {
        return plugin;
    }

    public IDialogSettings getOrCreateDialogSettingsSection(String id) {
        IDialogSettings section = this.getDialogSettings().getSection(id);
        if (section == null) {
            section = this.getDialogSettings().addNewSection(id);
        }
        return section;
    }

    public String[] getDialogValues(String key) {
        String[] values = this.getDialogSettings().getArray(key);
        if (values == null) {
            return new String[0];
        }
        return values;
    }

    public void renewDialogValue(String key, String newValue) {
        if (newValue == null || newValue.isEmpty()) {
            return;
        }
        ArrayList<String> valueList = new ArrayList<String>(Arrays.asList(this.getDialogValues(key)));
        if (valueList.contains(newValue)) {
            valueList.remove(newValue);
        }
        valueList.add(0, newValue);
        this.getDialogSettings().put(key, ArrayUtils.getToStringArray((Object[])valueList.toArray()));
    }

    public boolean dsEditSessionExist(IZRL newResource) {
        int i = 0;
        while (i < this.dsEditSessionList.size()) {
            if (newResource.equals(this.dsEditSessionList.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addNewDSEditSession(IZRL newResource) {
        this.getLogger().trace((Object)("Adding data set edit session: " + String.valueOf(newResource) == null ? "" : newResource));
        this.dsEditSessionList.add(newResource);
    }

    public void removeDSEditSession(IZRL aResource) {
        this.getLogger().trace((Object)"Removing data set edit session");
        int i = 0;
        while (i < this.dsEditSessionList.size()) {
            if (this.dsEditSessionList.get(i).equals(aResource)) {
                this.dsEditSessionList.remove(i);
                return;
            }
            ++i;
        }
    }

    public void addRunTempEntry(UUID uniqueKey, IZRL aResource, IZRL template, String xmlContents) {
        try {
            if (this.runTempEntryExists(uniqueKey) == null) {
                RunTempEntry newEntry = new RunTempEntry(uniqueKey, aResource, template, xmlContents);
                this.runTempEntryList.add(newEntry);
            } else {
                this.runTempEntryExists(uniqueKey).updateXMLBuffer(xmlContents);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RunTempEntry runTempEntryExists(UUID uniqueKey) {
        try {
            int i = 0;
            while (i < this.runTempEntryList.size()) {
                RunTempEntry temp = this.runTempEntryList.get(i);
                if (temp.getUniqueKey().equals(uniqueKey)) {
                    return temp;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getTemplateXMLBuffer(UUID uniqueKey) {
        int i = 0;
        while (i < this.runTempEntryList.size()) {
            RunTempEntry temp = this.runTempEntryList.get(i);
            if (temp.getUniqueKey().equals(uniqueKey)) {
                return temp.getXMLBuffer();
            }
            ++i;
        }
        return null;
    }

    public void removeRunTempEntry(UUID uniqueKey) {
        int i = 0;
        while (i < this.runTempEntryList.size()) {
            if (this.runTempEntryList.get(i).getUniqueKey().equals(uniqueKey)) {
                this.runTempEntryList.remove(i);
                return;
            }
            ++i;
        }
    }

    public boolean templateEditSessionExist(IZRL newTemplate) {
        int i = 0;
        while (i < this.templateEditSessionList.size()) {
            if (newTemplate.equals(this.templateEditSessionList.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addNewTemplateEditSession(IZRL newTemplateToEdit) {
        this.getLogger().trace((Object)"Adding template edit session");
        this.templateEditSessionList.add(newTemplateToEdit);
    }

    public void removeTemplateEditSession(IZRL aTemplate) {
        this.getLogger().trace((Object)"Removing template edit session");
        int i = 0;
        while (i < this.templateEditSessionList.size()) {
            if (this.templateEditSessionList.get(i).equals(aTemplate)) {
                this.templateEditSessionList.remove(i);
                return;
            }
            ++i;
        }
    }

    private PDLogger getLogger() {
        if (this._private_logger == null) {
            this._private_logger = PDLogger.get(FMUIPlugin.class);
        }
        return this._private_logger;
    }
}

