/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.integration.handler;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import com.ibm.pdtools.common.component.ui.PDTCCui;
import com.ibm.pdtools.common.component.ui.dialog.PDDialogWithText;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class FMExtensionHandler
extends SkeletonHandler {
    private static final PDLogger logger = PDLogger.get(FMExtensionHandler.class);
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) {
        ISelection s = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (s != null) {
            this.getZRLsAndHandle();
        }
    }

    public void getZRLsAndHandle() {
        try {
            PDTCCui.getDefault().loadSysInfoTreeContents();
            this.handle(FMExtensionHandler.getSelectedZRL(false));
        }
        catch (Exception e) {
            PDDialogs.openErrorThreadSafe((String)Messages.FILE_MANAGER, (String)Messages.FileManagerExtensionAction_GENERIC_EXCEPTION_MSG, (String)e.getMessage(), (Throwable)e);
        }
    }

    protected abstract void handle(List<IZRL> var1);

    public static List<IZRL> getSelectedZRL(boolean allowMultipleSystem) {
        ArrayList<IZRL> found = new ArrayList<IZRL>();
        IAdapterManager adapterManager = Platform.getAdapterManager();
        ISelection selection = FMUIPlugin.getDefault().getSelection();
        if (selection == null) {
            return found;
        }
        IStructuredSelection strucSel = (IStructuredSelection)selection;
        Iterator iterator = strucSel.iterator();
        IPDHost host = null;
        while (iterator.hasNext()) {
            IZRL zrl;
            Object item = iterator.next();
            if (item instanceof IZRL) {
                zrl = (IZRL)item;
                if (host == null) {
                    host = zrl.getSystem();
                    logger.trace((Object)("Current system for RDz invocation is: " + String.valueOf(host)));
                } else if (!zrl.getSystem().equals(host) && !allowMultipleSystem) {
                    logger.trace((Object)("Ignoring item because it is on a different system: " + String.valueOf(zrl.getSystem())));
                    continue;
                }
                found.add(zrl);
                continue;
            }
            logger.trace((Object)("Attempting to adapt: " + String.valueOf(item) + " " + item.getClass().getCanonicalName()));
            if (adapterManager.hasAdapter(item, IZRL.class.getCanonicalName())) {
                zrl = null;
                try {
                    zrl = (IZRL)adapterManager.loadAdapter(item, IZRL.class.getCanonicalName());
                }
                catch (Throwable e) {
                    logger.error((Object)"Failed to load  adapter!", e);
                    String fttVersions = Arrays.toString(Platform.getBundles((String)"com.ibm.ftt.resources.zos", null));
                    logger.error((Object)fttVersions);
                    PDDialogWithText.openErrorThreadSafe((String)"Error", (String)"Failed to load adapter!", (String)(e.toString() + "\n" + PDLoggerJhost.filteredTrace((StackTraceElement[])e.getStackTrace()) + "\n The following might be related to this error: " + fttVersions + " FM: " + FMUIPlugin.getDefault().getBundle().getVersion().toString()));
                }
                if (zrl == null) {
                    logger.error((Object)("Failed to adapt item: " + String.valueOf(item)));
                    continue;
                }
                if (host == null) {
                    host = zrl.getSystem();
                    logger.trace((Object)("Current system for RDz invocation is: " + String.valueOf(zrl.getSystem())));
                } else if (!zrl.getSystem().equals(host) && !allowMultipleSystem) {
                    logger.trace((Object)("Ignoring item because it is on a different system: " + String.valueOf(zrl.getSystem())));
                    continue;
                }
                found.add(zrl);
                continue;
            }
            logger.debug((Object)("Unable to adapt " + String.valueOf(item)));
        }
        return found;
    }

    public static List<DataSetOrMember> getDataSetOrMemberOnly(List<IZRL> list) {
        ArrayList<DataSetOrMember> found = new ArrayList<DataSetOrMember>();
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) instanceof DataSetOrMember) {
                found.add((DataSetOrMember)list.get(i));
            }
            ++i;
        }
        return found;
    }

    public static void noDataSetOrMemberSelected() {
        PDDialogs.openInfoThreadSafe((String)Messages.FileManagerExtensionAction_NO_DATA_SET);
    }
}

