/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template2.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.db2.SessionTemplate2;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.template1.StringArrayElementTableLabelProvider;
import com.ibm.etools.fm.editor.template2.dialogs.LayoutAssistProposalProvider2;
import com.ibm.etools.fm.model.template.Criteriatype;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateFactory;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.model.template.util.TemplateSerializeUtils;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class FreeCriteriaEntryDialog2
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2022. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private Text criteriaEntryText = null;
    private Text templateNameText = null;
    private Text db2ObjectText = null;
    private Table layoutTable = null;
    private TableViewer layoutTableViewer = null;
    private LayoutAssistProposalProvider2 proposalProvider = null;
    private SessionTemplate2 session = null;
    private DataSetOrMember templateResource = null;
    private Layouttype aLayout = null;
    private String initialText = null;
    private String criteriaExpressionString = null;
    private TemplateType templateWithNewCriteria = null;
    private TemplateType currentTemplate = null;
    private boolean emptyCriteria = false;

    public FreeCriteriaEntryDialog2(SessionTemplate2 session, DataSetOrMember templateResource, TemplateType currentTemplate, String initialText) {
        this.session = session;
        this.templateResource = templateResource;
        this.currentTemplate = currentTemplate;
        this.aLayout = (Layouttype)currentTemplate.getLayout().get(0);
        this.initialText = initialText;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.FreeCriteriaEntryDialog_Title);
        this.setMessage(Messages.FreeCriteriaEntryDialog_Msg);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.createEntryTextComposite(composite);
        this.createLayoutComposite(composite);
        this.criteriaEntryText.setFocus();
        this.addContentProposal();
        return composite;
    }

    private void createEntryTextComposite(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label((Composite)composite, (String)Messages.FreeCriteriaEntryDialog_CriteriaEntryText, (Object)GUI.grid.d.left1(), (int)16384);
        this.criteriaEntryText = GUI.text.field((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        if (this.initialText != null) {
            this.criteriaEntryText.setText(this.initialText);
        }
    }

    private void addContentProposal() {
        if (this.proposalProvider != null) {
            this.proposalProvider.changeLayout(this.aLayout);
        } else {
            TextContentAdapter contentAdapter = new TextContentAdapter();
            this.proposalProvider = new LayoutAssistProposalProvider2(this.aLayout, (IZRL)this.templateResource);
            this.proposalProvider.setFiltering(true);
            KeyStroke ks = KeyStroke.getInstance((int)262144, (int)32);
            new ContentProposalAdapter((Control)this.criteriaEntryText, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)this.proposalProvider, ks, null);
        }
    }

    private void createLayoutComposite(Composite parent) {
        Group templateGroup = GUI.group((Composite)parent, (String)Messages.FreeCriteriaEntryDialog_LayoutInfoGroup, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        Composite templateComposite = GUI.composite((Composite)templateGroup, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label((Composite)templateComposite, (String)Messages.FreeCriteriaEntryDialog_TemplateName, (Object)GUI.grid.d.left1(), (int)16384);
        this.templateNameText = GUI.text.fieldReadOnly((Composite)templateComposite, (Object)GUI.grid.d.fillH((int)1));
        this.templateNameText.setText(this.templateResource.getFormattedName());
        GUI.label((Composite)templateComposite, (String)Messages.CriteriaSpecDialog_DB2_ObjectName, (Object)GUI.grid.d.left1(), (int)16384);
        this.db2ObjectText = GUI.text.fieldReadOnly((Composite)templateComposite, (Object)GUI.grid.d.fillH((int)1));
        this.db2ObjectText.setText(this.session.getFromTemplateOptioons().getTable().getFormattedName());
        GridData tableGridData = GUI.grid.d.fillAll();
        tableGridData.heightHint = 300;
        Composite tableComposite = GUI.composite((Composite)templateGroup, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)tableGridData);
        this.layoutTable = new Table(tableComposite, 68356);
        this.layoutTable.setHeaderVisible(true);
        this.layoutTable.setLinesVisible(true);
        this.layoutTable.setLayoutData((Object)GUI.grid.d.fillAll());
        this.layoutTableViewer = new TableViewer(this.layoutTable);
        this.layoutTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        FreeCriteriaEntryDialog2.createMappingTableColumns(this.layoutTableViewer);
        this.layoutTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                FreeCriteriaEntryDialog2.this.insertSymbolToCriteriaEntryText();
            }
        });
        this.populateTable(this.layoutTableViewer, this.aLayout);
        this.layoutTable.select(0);
    }

    private void insertSymbolToCriteriaEntryText() {
        Symboltype aSymbol = (Symboltype)this.aLayout.getSymbol().get(this.layoutTable.getSelectionIndex());
        String value = "#" + aSymbol.getDb2col();
        String currentValue = this.criteriaEntryText.getText();
        int caretPos = this.criteriaEntryText.getCaretPosition();
        if (caretPos > -1 && caretPos < currentValue.length()) {
            String begin = currentValue.substring(0, caretPos);
            String end = currentValue.substring(caretPos);
            this.criteriaEntryText.setText(begin + value + end);
            this.criteriaEntryText.setSelection((begin + value).length(), (begin + value).length());
        } else {
            this.criteriaEntryText.append(value);
        }
    }

    private static void createMappingTableColumns(TableViewer viewer) {
        FormattedEditorUtility.createTableViewerColumn("", 30, viewer, 0x1000000);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_COLUMN_NUMBER, 80, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_COLUMN_NAME, 200, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_DATA_TYPE, 200, viewer, 16384);
        viewer.setLabelProvider((IBaseLabelProvider)new StringArrayElementTableLabelProvider());
    }

    private void populateTable(TableViewer aTableViewer, Layouttype aLayout) {
        ArrayList<String[]> fieldList = new ArrayList<String[]>();
        for (Symboltype aSymbol : aLayout.getSymbol()) {
            String status = "";
            String ref = "" + aSymbol.getDb2col();
            String field = aSymbol.getName(this.templateResource != null ? this.templateResource.getSystem() : null);
            String type = aSymbol.getDb2typ();
            fieldList.add(new String[]{status, ref, field, type});
        }
        aTableViewer.setInput(fieldList);
    }

    protected void okPressed() {
        this.setErrorMessage(null);
        if (!this.validateCriteria()) {
            if (this.emptyCriteria) {
                super.okPressed();
            } else {
                this.criteriaEntryText.setFocus();
            }
            return;
        }
        this.criteriaExpressionString = this.criteriaEntryText.getText().trim();
        super.okPressed();
    }

    public String getCriteriaExpression() {
        return this.criteriaExpressionString;
    }

    private boolean validateCriteria() {
        StringBuffer newTemplateContents;
        block8: {
            String criteriaExpression;
            block7: {
                try {
                    this.templateWithNewCriteria = null;
                    criteriaExpression = this.criteriaEntryText.getText().trim();
                    if (!criteriaExpression.isEmpty()) break block7;
                    this.emptyCriteria = true;
                    return false;
                }
                catch (Exception e) {
                    String errMsg = MessageFormat.format(Messages.FreeCriteriaEntryDialog_ExceptionWhileValidation, this.templateResource.getFormattedName(), this.criteriaEntryText.getText().trim());
                    logger.error((Object)errMsg, (Throwable)e);
                    PDDialogs.openErrorThreadSafe((String)errMsg);
                    return false;
                }
            }
            TemplateType newTemplate = TemplateFactory.eINSTANCE.createTemplateType();
            Layouttype newLayout = TemplateFactory.eINSTANCE.createLayouttype();
            newLayout.setId(this.aLayout.getId());
            Criteriatype newCriteria = TemplateFactory.eINSTANCE.createCriteriatype();
            newCriteria.setExp(criteriaExpression);
            newCriteria.setByfield(false);
            newTemplate.setFmix(this.currentTemplate.isFmix());
            newLayout.getCriteria().add((Object)newCriteria);
            newTemplate.getLayout().add((Object)newLayout);
            final StringBuffer xmlTemplate = TemplateSerializeUtils.save((TemplateType)newTemplate, (IZRL)this.templateResource);
            final Result result = new Result();
            newTemplateContents = new StringBuffer();
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(Messages.FreeCriteriaEntryDialog_CheckCriteriaWithHost, 1);
                        IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                        StringBuffer newXmlTemplate = FreeCriteriaEntryDialog2.this.session.updateTemplate(xmlTemplate, howIsGoing, result, true, false);
                        newTemplateContents.append(newXmlTemplate);
                    }
                });
            }
            catch (Exception e) {
                String errMsg = MessageFormat.format(Messages.FreeCriteriaEntryDialog_ExceptionWhileValidation, this.templateResource.getFormattedName(), this.criteriaEntryText.getText().trim());
                logger.error((Object)errMsg, (Throwable)e);
                PDDialogs.openErrorThreadSafe((String)errMsg);
                return false;
            }
            if (result.isSuccessfulWithoutWarnings()) break block8;
            PDDialogs.openErrorThreadSafe((String)Messages.FreeCriteriaEntryDialog_CriteriaValidationErr, (String)result.dumpOutputAndMessages(true));
            this.setErrorMessage(Messages.FreeCriteriaEntryDialog_CriteriaValidationErrShort);
            return false;
        }
        this.templateWithNewCriteria = TemplateSerializeUtils.load((StringBuffer)newTemplateContents, (IZRL)this.templateResource);
        return true;
    }

    public boolean isEmptyCriteria() {
        return this.emptyCriteria;
    }

    public TemplateType getTemplateWithNewCriteria() {
        return this.templateWithNewCriteria;
    }
}

