/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template2.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.SessionTemplate2;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.template1.StringArrayElementTableLabelProvider;
import com.ibm.etools.fm.editor.template2.dialogs.CriteriaElement2;
import com.ibm.etools.fm.model.template.ConnType;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Oper2Type;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class FieldCriteriaSpecificationDialog2
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private Text templateNameText = null;
    private Text db2ObjectText = null;
    private Table layoutTable = null;
    private TableViewer layoutTableViewer = null;
    private Combo connectorCombo = null;
    private Combo operatorCombo = null;
    private Combo valueCombo = null;
    private IZRL templateResource = null;
    private TemplateType currentTemplate = null;
    private boolean allowConnectorChange = false;
    private SessionTemplate2 session = null;
    private CriteriaElement2 specifiedCriteria = null;

    public FieldCriteriaSpecificationDialog2(IZRL templateResource, TemplateType currentTemplate, boolean allowConnectorChange, SessionTemplate2 session) {
        this.templateResource = templateResource;
        this.currentTemplate = currentTemplate;
        this.allowConnectorChange = allowConnectorChange;
        this.specifiedCriteria = null;
        this.session = session;
    }

    public FieldCriteriaSpecificationDialog2(IZRL templateResource, TemplateType currentTemplate, boolean allowConnectorChange, SessionTemplate2 session, CriteriaElement2 aCriteria) {
        this.templateResource = templateResource;
        this.currentTemplate = currentTemplate;
        this.allowConnectorChange = allowConnectorChange;
        this.session = session;
        this.specifiedCriteria = aCriteria;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.FieldCriteriaSpecDialog_Title);
        this.setMessage(Messages.FieldCriteriaSpecDialog_Msg);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.createLayoutComposite(composite);
        this.createCriteriaComposite(composite);
        this.populateTable(this.layoutTableViewer, (Layouttype)this.currentTemplate.getLayout().get(0));
        this.layoutTable.select(0);
        this.initFieldCriteria();
        this.validateInput();
        return composite;
    }

    private void createLayoutComposite(Composite parent) {
        Composite templateComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label((Composite)templateComposite, (String)Messages.FieldCriteriaSpecDialog_TemplateName, (Object)GUI.grid.d.left1(), (int)16384);
        this.templateNameText = GUI.text.fieldReadOnly((Composite)templateComposite, (Object)GUI.grid.d.fillH((int)1));
        this.templateNameText.setText(this.templateResource.getFormattedName());
        GUI.label((Composite)templateComposite, (String)Messages.CriteriaSpecDialog_DB2_ObjectName, (Object)GUI.grid.d.left1(), (int)16384);
        this.db2ObjectText = GUI.text.fieldReadOnly((Composite)templateComposite, (Object)GUI.grid.d.fillH((int)1));
        this.db2ObjectText.setText(this.session.getFromTemplateOptioons().getTable().getFormattedName());
        GridData tableGridData = GUI.grid.d.fillAll();
        tableGridData.heightHint = 300;
        Composite tableComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)tableGridData);
        this.layoutTable = new Table(tableComposite, 68356);
        this.layoutTable.setHeaderVisible(true);
        this.layoutTable.setLinesVisible(true);
        this.layoutTable.setLayoutData((Object)GUI.grid.d.fillAll());
        this.layoutTableViewer = new TableViewer(this.layoutTable);
        this.layoutTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        FieldCriteriaSpecificationDialog2.createMappingTableColumns(this.layoutTableViewer);
        this.layoutTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FieldCriteriaSpecificationDialog2.this.validateInput();
            }
        });
    }

    private static void createMappingTableColumns(TableViewer viewer) {
        FormattedEditorUtility.createTableViewerColumn("", 30, viewer, 0x1000000);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_COLUMN_NUMBER, 60, viewer, 131072);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_COLUMN_NAME, 300, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_DATA_TYPE, 200, viewer, 16384);
        viewer.setLabelProvider((IBaseLabelProvider)new StringArrayElementTableLabelProvider());
    }

    private void populateTable(TableViewer aTableViewer, Layouttype aLayout) {
        ArrayList<String[]> fieldList = new ArrayList<String[]>();
        for (Symboltype aSymbol : aLayout.getSymbol()) {
            String status = "";
            String db2Col = "" + aSymbol.getDb2col();
            String field = aSymbol.getName(this.templateResource.getSystem());
            String db2Type = aSymbol.getDb2typ();
            fieldList.add(new String[]{status, db2Col, field, db2Type});
        }
        aTableViewer.setInput(fieldList);
    }

    private void createCriteriaComposite(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label((Composite)composite, (String)Messages.FieldCriteriaSpecDialog_connector, (Object)GUI.grid.d.left1(), (int)16384);
        this.connectorCombo = GUI.combo.readOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1), (Object[])ConnType.values());
        this.connectorCombo.select(1);
        this.connectorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FieldCriteriaSpecificationDialog2.this.validateInput();
            }
        });
        if (!this.allowConnectorChange) {
            this.connectorCombo.setEnabled(false);
        }
        GUI.label((Composite)composite, (String)Messages.FieldCriteriaSpecDialog_operator, (Object)GUI.grid.d.left1(), (int)16384);
        this.operatorCombo = GUI.combo.readOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1), (Object[])FieldCriteriaSpecificationDialog2.getValidOperators());
        this.operatorCombo.select(0);
        this.operatorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FieldCriteriaSpecificationDialog2.this.validateInput();
                FieldCriteriaSpecificationDialog2.this.valueCombo.setEnabled(true);
                if (FieldCriteriaSpecificationDialog2.this.operatorCombo.getText().equals(Oper2Type.NL.getLiteral()) || FieldCriteriaSpecificationDialog2.this.operatorCombo.getText().equals(Oper2Type.NNL.getLiteral()) || FieldCriteriaSpecificationDialog2.this.operatorCombo.getText().equals(Oper2Type.NL1.getLiteral())) {
                    FieldCriteriaSpecificationDialog2.this.valueCombo.setEnabled(false);
                } else {
                    FieldCriteriaSpecificationDialog2.this.valueCombo.setEnabled(true);
                }
            }
        });
        GUI.label((Composite)composite, (String)Messages.FieldCriteriaSpecDialog_criteriaValue, (Object)GUI.grid.d.left1(), (int)16384);
        this.valueCombo = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        this.valueCombo.setFocus();
        new ComboValueSaver(this.valueCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "criteriaValue");
        this.valueCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FieldCriteriaSpecificationDialog2.this.validateInput();
            }
        });
    }

    private static String[] getValidOperators() {
        String[] operators = new String[Oper2Type.values().length];
        int i = 0;
        while (Oper2Type.get((int)i) != null) {
            operators[i] = Oper2Type.get((int)i).getLiteral();
            ++i;
        }
        return operators;
    }

    private void validateInput() {
        if (this.layoutTable.getSelectionIndex() == -1) {
            this.setComplete(false);
            return;
        }
        if (this.operatorCombo.getText().equals(Oper2Type.NL.getLiteral()) || this.operatorCombo.getText().equals(Oper2Type.NNL.getLiteral()) || this.operatorCombo.getText().equals(Oper2Type.NL1.getLiteral())) {
            this.setComplete(true);
            return;
        }
        if (this.valueCombo.getText().trim().isEmpty()) {
            this.setComplete(false);
            return;
        }
        this.setComplete(true);
    }

    protected void okPressed() {
        Layouttype selectedLayout = (Layouttype)this.currentTemplate.getLayout().get(0);
        Symboltype selectedSymbol = (Symboltype)selectedLayout.getSymbol().get(this.layoutTable.getSelectionIndex());
        ConnType connectorType = ConnType.get((int)this.connectorCombo.getSelectionIndex());
        Oper2Type selectedOperator = Oper2Type.get((int)this.operatorCombo.getSelectionIndex());
        String value = this.valueCombo.getText();
        if (this.operatorCombo.getText().equals(Oper2Type.NL.getLiteral()) || this.operatorCombo.getText().equals(Oper2Type.NNL.getLiteral()) || this.operatorCombo.getText().equals(Oper2Type.NL1.getLiteral())) {
            value = "";
        }
        if (this.specifiedCriteria == null) {
            this.specifiedCriteria = new CriteriaElement2(connectorType, selectedSymbol, selectedOperator, 0, value, this.templateResource.getSystem());
        } else {
            this.specifiedCriteria.setaSymbol(selectedSymbol);
            this.specifiedCriteria.setOperator(selectedOperator);
            this.specifiedCriteria.setConnectorType(connectorType);
            this.specifiedCriteria.setCriteriaValue(value);
        }
        super.okPressed();
    }

    private void initFieldCriteria() {
        if (this.specifiedCriteria == null) {
            return;
        }
        Layouttype selectedLayout = (Layouttype)this.currentTemplate.getLayout().get(0);
        int selectionIndex = 0;
        int i = 0;
        while (i < selectedLayout.getSymbol().size()) {
            Symboltype aSymbol = (Symboltype)selectedLayout.getSymbol().get(i);
            if (this.specifiedCriteria.getSymbol().getRef() == aSymbol.getRef()) {
                selectionIndex = i;
                break;
            }
            ++i;
        }
        this.layoutTable.setSelection(selectionIndex);
        this.connectorCombo.setText(this.specifiedCriteria.getConnectorType().getLiteral());
        this.operatorCombo.setText(this.specifiedCriteria.getOperator().getLiteral());
        this.valueCombo.setText(this.specifiedCriteria.getCriteriaValue());
        if (this.specifiedCriteria.getOperator() == Oper2Type.NL || this.specifiedCriteria.getOperator() == Oper2Type.NNL || this.operatorCombo.getText().equals(Oper2Type.NL1.getLiteral())) {
            this.valueCombo.setEnabled(false);
        }
    }

    public CriteriaElement2 getSpecifiedCriteria() {
        return this.specifiedCriteria;
    }
}

