/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template2.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.model.template.CreateType;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.ui.widget.NumberForcer;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class FieldAttributeDialogUseAttributeComposite2 {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int HEADING_MAXLEN = 20;
    private TabItem useAttriTab;
    private Combo headingCombo;
    private Combo outputWidthCombo;
    private Button leadingZeroButton;
    private Layouttype selectedLayout;
    private int symbolIndex = 0;

    public FieldAttributeDialogUseAttributeComposite2(Layouttype selectedLayout, int symbolIndex) {
        this.selectedLayout = selectedLayout;
        this.symbolIndex = symbolIndex;
    }

    public void createUseAttributeTab(TabFolder tabFolder) {
        this.useAttriTab = new TabItem(tabFolder, 0);
        this.useAttriTab.setText(Messages.FieldAttributeDialog_UseAttrGroupName);
        Composite composite = GUI.composite((Composite)tabFolder, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)composite, (String)Messages.FieldAttributeDialog_UseAttrHeading, (Object)GUI.grid.d.left1());
        this.headingCombo = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.headingCombo, this.getClass().getCanonicalName() + "headingValue");
        this.headingCombo.setTextLimit(20);
        GUI.label.left((Composite)composite, (String)Messages.FieldAttributeDialog_UseAttrOutputWidth, (Object)GUI.grid.d.left1());
        this.outputWidthCombo = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.outputWidthCombo, this.getClass().getCanonicalName() + "outputWidth");
        NumberForcer.addTo(this.outputWidthCombo, this.getClass().getCanonicalName() + "outputWidth");
        CreateType type = ((Symboltype)this.selectedLayout.getSymbol().get(this.symbolIndex)).getCreate();
        if (type == CreateType.NU) {
            this.leadingZeroButton = GUI.button.checkbox((Composite)composite, (String)Messages.FieldAttributeDialog_UseAttrLeadingZero, (Object)GUI.grid.d.fillH((int)2));
        }
        this.useAttriTab.setControl((Control)composite);
        this.setUseAttributeValues();
    }

    private void setUseAttributeValues() {
        CreateType type;
        Symboltype aSymbol = (Symboltype)this.selectedLayout.getSymbol().get(this.symbolIndex);
        if (aSymbol.getHeading() != null) {
            this.headingCombo.setText(aSymbol.getHeading());
        }
        if (aSymbol.isSetWidth()) {
            this.outputWidthCombo.setText("" + aSymbol.getWidth());
        }
        if ((type = ((Symboltype)this.selectedLayout.getSymbol().get(this.symbolIndex)).getCreate()) == CreateType.NU && aSymbol.isSetLzero()) {
            this.leadingZeroButton.setSelection(aSymbol.isLzero());
        }
    }

    public boolean validateFields() {
        return true;
    }

    public boolean updateAndFinish() {
        if (!this.validateFields()) {
            return false;
        }
        Symboltype aSymbol = (Symboltype)this.selectedLayout.getSymbol().get(this.symbolIndex);
        if (!this.headingCombo.getText().trim().isEmpty()) {
            aSymbol.setHeading(this.headingCombo.getText().trim());
        } else {
            aSymbol.setHeading("");
        }
        if (!this.outputWidthCombo.getText().trim().isEmpty()) {
            aSymbol.setWidth(Integer.parseInt(this.outputWidthCombo.getText().trim()));
        } else {
            aSymbol.setWidth(0);
        }
        CreateType type = ((Symboltype)this.selectedLayout.getSymbol().get(this.symbolIndex)).getCreate();
        if (type == CreateType.NU) {
            aSymbol.setLzero(this.leadingZeroButton.getSelection());
        }
        return true;
    }
}

