/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template2.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.template2.dialogs.FieldAttributeDialog2;
import com.ibm.etools.fm.model.template.CreateDTtype;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateFactory;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class FieldAttributeDialogCreateAttributeDateComposite2 {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String DATE_TYPE = "DATE";
    private TabItem createAttrTab;
    private Combo dateValueCombo;
    private Combo incrementCombo;
    private FieldAttributeDialog2 dialog;
    private Layouttype selectedLayout;
    private int symbolIndex = 0;

    public FieldAttributeDialogCreateAttributeDateComposite2(FieldAttributeDialog2 dialog, Layouttype selectedLayout, int symbolIndex) {
        this.dialog = dialog;
        this.selectedLayout = selectedLayout;
        this.symbolIndex = symbolIndex;
    }

    public void createCreateAttributeTab(TabFolder tabFolder) {
        this.createAttrTab = new TabItem(tabFolder, 0);
        this.createAttrTab.setText(Messages.FieldAttributeDialog_CreateAttrGroupName);
        Composite composite = GUI.composite((Composite)tabFolder, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)composite, (String)Messages.FieldAttributeDialog_DateValue, (Object)GUI.grid.d.left1());
        this.dateValueCombo = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        this.dateValueCombo.setToolTipText(Messages.FieldAttributeDialog_DateValueTip);
        new ComboValueSaver(this.dateValueCombo, this.getClass().getCanonicalName() + "dateValue");
        Symboltype aSymbol = (Symboltype)this.selectedLayout.getSymbol().get(this.symbolIndex);
        if (DATE_TYPE.equals(aSymbol.getDb2typ())) {
            GUI.label.left((Composite)composite, (String)Messages.FieldAttributeDialog_Increment, (Object)GUI.grid.d.left1());
            this.incrementCombo = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
            new ComboValueSaver(this.incrementCombo, this.getClass().getCanonicalName() + "incrementValue");
        }
        this.createAttrTab.setControl((Control)composite);
        this.setCreateAttributeValues();
    }

    private void setCreateAttributeValues() {
        Symboltype aSymbol = (Symboltype)this.selectedLayout.getSymbol().get(this.symbolIndex);
        if (aSymbol.getCreateDT() != null) {
            CreateDTtype dtType = aSymbol.getCreateDT();
            if (dtType.getValue() != null) {
                this.dateValueCombo.setText(dtType.getValue());
            }
            if (DATE_TYPE.equals(aSymbol.getDb2typ()) && dtType.isSetInc()) {
                this.incrementCombo.setText("" + dtType.getInc());
            }
        }
    }

    public boolean validateFields() {
        String aValue;
        Symboltype aSymbol = (Symboltype)this.selectedLayout.getSymbol().get(this.symbolIndex);
        if (DATE_TYPE.equals(aSymbol.getDb2typ()) && (aValue = this.incrementCombo.getText().trim()).length() > 0 && !FieldAttributeDialogCreateAttributeDateComposite2.isValidInt(aValue)) {
            this.dialog.setErrorMessage(Messages.FieldAttributeDialog_IncrementError);
            this.incrementCombo.setFocus();
            return false;
        }
        return true;
    }

    private static boolean isValidInt(String aValue) {
        try {
            Integer.parseInt(aValue);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean updateAndFinish() {
        String aValue;
        if (!this.validateFields()) {
            return false;
        }
        Symboltype aSymbol = (Symboltype)this.selectedLayout.getSymbol().get(this.symbolIndex);
        CreateDTtype dtType = aSymbol.getCreateDT();
        if (dtType == null) {
            dtType = TemplateFactory.eINSTANCE.createCreateDTtype();
            aSymbol.setCreateDT(dtType);
        }
        if (DATE_TYPE.equals(aSymbol.getDb2typ())) {
            aValue = this.incrementCombo.getText().trim();
            if (!aValue.isEmpty()) {
                dtType.setInc(Integer.parseInt(aValue));
            } else {
                dtType.unsetInc();
            }
        }
        if (!(aValue = this.dateValueCombo.getText().trim()).isEmpty()) {
            dtType.setValue(aValue);
        }
        return true;
    }
}

