/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template2.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.db2.SessionTemplate2;
import com.ibm.etools.fm.editor.template2.dialogs.FieldAttributeDialogCreateAttributeDateComposite2;
import com.ibm.etools.fm.editor.template2.dialogs.FieldAttributeDialogCreateAttributeNoneComposite2;
import com.ibm.etools.fm.editor.template2.dialogs.FieldAttributeDialogCreateAttributeNumericComposite2;
import com.ibm.etools.fm.editor.template2.dialogs.FieldAttributeDialogCreateAttributeTextComposite2;
import com.ibm.etools.fm.editor.template2.dialogs.FieldAttributeDialogScrambleComposite2;
import com.ibm.etools.fm.editor.template2.dialogs.FieldAttributeDialogUseAttributeComposite2;
import com.ibm.etools.fm.model.template.CreateType;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.model.template.util.TemplateSerializeUtils;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class FieldAttributeDialog2
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private Text fieldNameText;
    private Text fieldTypeText;
    private TabFolder tabFolder;
    private FieldAttributeDialogCreateAttributeTextComposite2 createAttributeTextComposite;
    private FieldAttributeDialogCreateAttributeNumericComposite2 createAttributeNumberComposite;
    private FieldAttributeDialogCreateAttributeDateComposite2 createAttributeDateComposite;
    private FieldAttributeDialogCreateAttributeNoneComposite2 createAttributeNoneComposite;
    private FieldAttributeDialogUseAttributeComposite2 useAttributeComposite;
    private FieldAttributeDialogScrambleComposite2 scrambleAttributeComposite;
    private final SessionTemplate2 session;
    private final DataSetOrMember templateResource;
    private final TemplateType aTemplate;
    private final Layouttype selectedLayout;
    private int symbolIndex = 0;
    private boolean updateToTemplate = false;
    private boolean hostValidationFailure = false;
    private int selectedTab = 0;

    public void setSelectedTab(int index) {
        if (index >= 0 && index <= 2) {
            this.selectedTab = index;
        }
    }

    public FieldAttributeDialog2(SessionTemplate2 session, DataSetOrMember templateResource, TemplateType aTemplate, Layouttype selectedLayout, int symbolIndex, boolean updateToTemplate) {
        if (session == null) {
            throw new IllegalArgumentException("Must specify a non-null SessionTemplate2.");
        }
        if (templateResource == null) {
            throw new IllegalArgumentException("Must specify a non-null DataSetOrMember templateResource.");
        }
        if (selectedLayout == null) {
            throw new IllegalArgumentException("Must specify a non-null Layouttype selectedLayout.");
        }
        this.session = session;
        this.templateResource = templateResource;
        this.aTemplate = aTemplate;
        this.selectedLayout = selectedLayout;
        this.symbolIndex = symbolIndex;
        this.updateToTemplate = updateToTemplate;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.FieldAttributeDialog_Title);
        this.setMessage(Messages.FieldAttributeDialog_Msg);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.createFixedAttributeComposite(composite);
        this.tabFolder = new TabFolder(composite, 128);
        this.tabFolder.setLayoutData((Object)GUI.grid.d.fillAll());
        this.useAttributeComposite = new FieldAttributeDialogUseAttributeComposite2(this.selectedLayout, this.symbolIndex);
        this.useAttributeComposite.createUseAttributeTab(this.tabFolder);
        CreateType type = ((Symboltype)this.selectedLayout.getSymbol().get(this.symbolIndex)).getCreate();
        if (type == CreateType.AN) {
            this.createAttributeTextComposite = new FieldAttributeDialogCreateAttributeTextComposite2(this, this.selectedLayout, this.symbolIndex);
            this.createAttributeTextComposite.createCreateAttributeTab(this.tabFolder);
        } else if (type == CreateType.VC) {
            this.createAttributeTextComposite = new FieldAttributeDialogCreateAttributeTextComposite2(this, this.selectedLayout, this.symbolIndex);
            this.createAttributeTextComposite.createCreateAttributeTab(this.tabFolder);
        } else if (type == CreateType.NU) {
            this.createAttributeNumberComposite = new FieldAttributeDialogCreateAttributeNumericComposite2(this, this.selectedLayout, this.symbolIndex);
            this.createAttributeNumberComposite.createCreateAttributeTab(this.tabFolder);
        } else if (type == CreateType.DT) {
            this.createAttributeDateComposite = new FieldAttributeDialogCreateAttributeDateComposite2(this, this.selectedLayout, this.symbolIndex);
            this.createAttributeDateComposite.createCreateAttributeTab(this.tabFolder);
        } else if (type == CreateType.NA) {
            this.createAttributeNoneComposite = new FieldAttributeDialogCreateAttributeNoneComposite2();
            this.createAttributeNoneComposite.createCreateAttributeTab(this.tabFolder);
        }
        if (type == CreateType.AN || type == CreateType.VC || type == CreateType.NU) {
            this.scrambleAttributeComposite = new FieldAttributeDialogScrambleComposite2(this, this.templateResource, this.selectedLayout, this.symbolIndex);
            this.scrambleAttributeComposite.createComposite(this.tabFolder);
        }
        if (this.selectedTab > 0) {
            this.tabFolder.setSelection(this.selectedTab);
        }
        return composite;
    }

    private void createFixedAttributeComposite(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)composite, (String)Messages.FieldAttributeDialog_FieldName, (Object)GUI.grid.d.left1());
        this.fieldNameText = GUI.text.fieldReadOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)composite, (String)Messages.FieldAttributeDialog_FieldType, (Object)GUI.grid.d.left1());
        this.fieldTypeText = GUI.text.fieldReadOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        this.setFixedAttributeValues();
    }

    private void setFixedAttributeValues() {
        Symboltype aSymbol = (Symboltype)this.selectedLayout.getSymbol().get(this.symbolIndex);
        this.fieldNameText.setText(aSymbol.getName(this.session.getSystem()));
        this.fieldTypeText.setText(aSymbol.getDb2typ());
    }

    public boolean validateFields() {
        if (!this.useAttributeComposite.validateFields()) {
            return false;
        }
        if (this.createAttributeTextComposite != null && !this.createAttributeTextComposite.validateFields()) {
            return false;
        }
        if (this.createAttributeNumberComposite != null && !this.createAttributeNumberComposite.validateFields()) {
            return false;
        }
        if (this.createAttributeDateComposite != null && !this.createAttributeDateComposite.updateAndFinish()) {
            return false;
        }
        if (this.createAttributeNoneComposite != null && !this.createAttributeNoneComposite.updateAndFinish()) {
            return false;
        }
        return this.scrambleAttributeComposite == null || this.scrambleAttributeComposite.validateFields();
    }

    protected void okPressed() {
        if (!this.validateFields()) {
            return;
        }
        if (!this.useAttributeComposite.updateAndFinish()) {
            return;
        }
        if (this.createAttributeTextComposite != null && !this.createAttributeTextComposite.updateAndFinish()) {
            return;
        }
        if (this.createAttributeNumberComposite != null && !this.createAttributeNumberComposite.updateAndFinish()) {
            return;
        }
        if (this.createAttributeDateComposite != null && !this.createAttributeDateComposite.updateAndFinish()) {
            return;
        }
        if (this.createAttributeNoneComposite != null && !this.createAttributeNoneComposite.updateAndFinish()) {
            return;
        }
        if (this.scrambleAttributeComposite != null && !this.scrambleAttributeComposite.updateAndFinish()) {
            return;
        }
        if (!this.validateAttributres()) {
            this.hostValidationFailure = true;
            return;
        }
        super.okPressed();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void cancelPressed() {
        if (this.hostValidationFailure) {
            if (!PDDialogs.openConfirm((String)Messages.Warning, (String)Messages.FieldAttributeDialog_CancelWithHostValidationErr)) return;
            super.cancelPressed();
            return;
        } else {
            super.cancelPressed();
        }
    }

    private boolean validateAttributres() {
        Result result;
        try {
            final StringBuffer xmlTemplate = TemplateSerializeUtils.save((TemplateType)this.aTemplate, (IZRL)this.templateResource);
            result = new Result();
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(Messages.FieldAttributeDialog_ValidateAttributes, 1);
                        IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                        FieldAttributeDialog2.this.session.updateTemplate(xmlTemplate, howIsGoing, result, false, FieldAttributeDialog2.this.updateToTemplate);
                    }
                });
            }
            catch (Exception e) {
                PDDialogs.openErrorThreadSafe((String)Messages.FieldAttributeDialog_ValidationEx, (String)result.dumpOutputAndMessages(true), (Throwable)e);
                return false;
            }
        }
        catch (Exception e) {
            PDDialogs.openErrorThreadSafe((String)Messages.FieldAttributeDialog_ValidationEx, (Throwable)e);
            return false;
        }
        if (!result.isSuccessfulWithoutWarnings()) {
            PDDialogs.openErrorThreadSafe((String)Messages.FieldAttributeDialog_ValidationError, (String)result.dumpOutputAndMessages(true));
            return false;
        }
        return true;
    }

    public boolean validationErrorOccurred() {
        return this.hostValidationFailure;
    }

    public DataSetOrMember getTemplate() {
        return this.templateResource;
    }
}

