/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template2.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.core.model.db2.Db2EditorOptions;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2SubsystemProvider;
import com.ibm.etools.fm.core.model.db2.Db2SystemOptions;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.core.model.db2.Db2TemplateOptions;
import com.ibm.etools.fm.editor.formatted2.dialogs.Db2OptionsDialog;
import com.ibm.etools.fm.editor.template.TemplateEditorUtilities;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.lookup.Db2SubsystemLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.Db2TableLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.callback.IOnSelectionEvent;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.util.ZrlLoaderDialogUtils;
import com.ibm.etools.fm.ui.views.systems.handlers.VersionUtils;
import com.ibm.etools.fm.ui.widget.Db2TableContentProposals;
import com.ibm.etools.fm.ui.widget.ResourceContentProposals;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.ui.util.PDSafeUIRunner;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class Db2TemplateEditorDialog2
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private IPDHost host;
    private Db2TemplateOptions options;
    private Combo ssidCombo;
    private Combo ownerCombo;
    private Combo nameCombo;
    private Combo templateCombo;
    private Button templateUsageGenRepButton;
    private final ModifyListener clearErrorMessage = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Db2TemplateEditorDialog2.this.setErrorMessage(null);
        }
    };

    public Db2TemplateEditorDialog2(IPDHost host, Db2Subsystem subsystem, Db2Table table) {
        this.options = new Db2TemplateOptions();
        if (table != null) {
            this.options.setTable(table);
        } else if (subsystem != null) {
            this.options.setSubsystem(subsystem);
        } else {
            this.options.setHost(host);
        }
        this.host = this.options.getSystem();
    }

    public Db2TemplateEditorDialog2(Db2TemplateOptions options) {
        Objects.requireNonNull(options, "Must specify a non-null options.");
        this.host = options.getSystem();
        this.options = options.clone();
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.Db2TemplateEditorDialog2_0);
        this.setMessage(Messages.Db2TemplateEditorDialog2_1);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.createDB2ObjectGroup(composite);
        this.createTemplateGroup(composite);
        this.initialiseDialogValues();
        return composite;
    }

    private void initialiseDialogValues() {
        if (this.options.getSubsystem() != null) {
            Db2TemplateEditorDialog2.setText(this.ssidCombo, this.options.getSubsystem().getSubsystemID());
        }
        if (this.options.getTable() != null) {
            Db2TemplateEditorDialog2.setText(this.ownerCombo, this.options.getCreator());
            Db2TemplateEditorDialog2.setText(this.nameCombo, this.options.getName());
        }
        if (this.options.getTemplate() != null) {
            Db2TemplateEditorDialog2.setText(this.templateCombo, this.options.getTemplate().getFormattedName());
        }
        this.templateUsageGenRepButton.setSelection(this.options.isGenRep());
        if (this.options.getSubsystem() == null) {
            Db2TemplateEditorDialog2.setFocus((Composite)this.ssidCombo);
        } else if (this.options.getTable() == null) {
            Db2TemplateEditorDialog2.setFocus((Composite)this.ownerCombo);
        } else {
            Db2TemplateEditorDialog2.setFocus((Composite)this.templateCombo);
        }
    }

    private void createDB2ObjectGroup(Composite parent) {
        Group db2ObjectGroup = GUI.group((Composite)parent, (String)Messages.Db2TemplateEditorDialog2_2, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)db2ObjectGroup, (String)Messages.Db2TemplateEditorDialog2_3, (Object)GUI.grid.d.left1());
        this.ssidCombo = GUI.combo.editable((Composite)db2ObjectGroup, (Object)GUI.grid.d.fillH((int)1));
        this.ssidCombo.setToolTipText(Messages.Db2TemplateEditorDialog2_4);
        new ComboValueSaver(this.ssidCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "ssid");
        this.ssidCombo.addModifyListener(this.clearErrorMessage);
        Button ssidLookup = GUI.button.push((Composite)db2ObjectGroup, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/search.gif"), (String)Messages.Db2TemplateEditorDialog2_25, (Object)GUI.grid.d.left1());
        ssidLookup.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                Db2SubsystemLookupDialog lookup = new Db2SubsystemLookupDialog(Db2TemplateEditorDialog2.this.options.getSystem());
                if (lookup.open() == 0) {
                    Db2TemplateEditorDialog2.this.options.setSubsystem((Db2Subsystem)lookup.getFirstSelectedObject());
                    Db2TemplateEditorDialog2.setText(Db2TemplateEditorDialog2.this.ssidCombo, Db2TemplateEditorDialog2.this.options.getSubsystem().getSubsystemID());
                }
            }
        });
        GUI.label.left((Composite)db2ObjectGroup, (String)Messages.Db2TemplateEditorDialog2_7, (Object)GUI.grid.d.left1());
        this.ownerCombo = GUI.combo.editable((Composite)db2ObjectGroup, (Object)GUI.grid.d.fillH((int)1));
        this.ownerCombo.setToolTipText(Messages.Db2TemplateEditorDialog2_8);
        this.ownerCombo.addModifyListener(this.clearErrorMessage);
        SelectionAdapter lookupHandler = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Db2TemplateEditorDialog2.this.validateSubsystem(true)) {
                    Db2TableLookupDialog lookup = new Db2TableLookupDialog(Db2TemplateEditorDialog2.this.options.getSubsystem());
                    lookup.setInitialOwnerPattern(Db2TemplateEditorDialog2.this.ownerCombo.getText());
                    lookup.setInitialNamePattern(Db2TemplateEditorDialog2.this.nameCombo.getText());
                    if (lookup.open() == 0) {
                        Db2Table selected = (Db2Table)lookup.getFirstSelectedObject();
                        Db2TemplateEditorDialog2.this.options.setTable(selected);
                        Db2TemplateEditorDialog2.this.initialiseDialogValues();
                    }
                }
            }
        };
        Button lookupTableButtonForOwner = GUI.button.push((Composite)db2ObjectGroup, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/search.gif"), (String)Messages.Db2EditorDialog_33, (Object)GUI.grid.d.left1());
        lookupTableButtonForOwner.addSelectionListener((SelectionListener)lookupHandler);
        GUI.label.left((Composite)db2ObjectGroup, (String)Messages.Db2TemplateEditorDialog2_11, (Object)GUI.grid.d.left1());
        this.nameCombo = GUI.combo.editable((Composite)db2ObjectGroup, (Object)GUI.grid.d.fillH((int)1));
        this.nameCombo.setToolTipText(Messages.Db2TemplateEditorDialog2_12);
        Db2TableContentProposals.addTo(this.ownerCombo, this.nameCombo, (Db2SubsystemProvider)this.options, ((Object)((Object)this)).getClass().getCanonicalName() + "Resource");
        this.nameCombo.addModifyListener(this.clearErrorMessage);
        Button lookupTableButtonForName = GUI.button.push((Composite)db2ObjectGroup, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/search.gif"), (String)Messages.Db2EditorDialog_33, (Object)GUI.grid.d.left1());
        lookupTableButtonForName.addSelectionListener((SelectionListener)lookupHandler);
    }

    private void createTemplateGroup(Composite parent) {
        List assocs;
        Group group = GUI.group((Composite)parent, (String)Messages.Db2TemplateEditorDialog2_13, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)group, (String)Messages.Db2TemplateEditorDialog2_14, (Object)GUI.grid.d.left1());
        this.templateCombo = GUI.combo.editable((Composite)group, (Object)GUI.grid.d.fillH((int)1));
        ResourceContentProposals.addTo(this.templateCombo, (IHostProvider)this.host, ((Object)((Object)this)).getClass().getCanonicalName() + "Template", FMHost.getPermittedTemplateResourceType((IPDHost)this.host));
        if (this.options.getTable() != null && (assocs = FMHost.getSystem((IPDHost)this.host).getTemplateAssociations((IZRL)this.options.getTable())).size() > 0) {
            ComboValueSaver.getInstance((Combo)this.templateCombo).setCustomItems(assocs.toArray(new String[0]), false, false);
            this.templateCombo.select(0);
        }
        this.templateCombo.addModifyListener(this.clearErrorMessage);
        LookupDialogFactory.defaults(LookupButton.createLookupTemplateButtonLeft1((Composite)group), this.templateCombo, (IHostProvider)this.options).types(FMHost.getPermittedTemplateResourceType((IPDHost)this.host)).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                Db2TemplateEditorDialog2.this.options.setTemplate(zrl);
            }
        }).create();
        this.templateUsageGenRepButton = GUI.button.checkbox((Composite)group, (String)Messages.Db2TemplateEditorDialog2_15, (Object)GUI.grid.d.fillH((int)4));
        this.templateUsageGenRepButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Db2TemplateEditorDialog2.this.options.setGenRep(Db2TemplateEditorDialog2.this.templateUsageGenRepButton.getSelection());
            }
        });
    }

    private boolean validateTemplateDataSetName() {
        String result;
        block7: {
            String value = this.templateCombo.getText().toUpperCase().trim();
            if (value.isEmpty()) {
                this.options.setTemplate(null);
                Db2TemplateEditorDialog2.setFocus((Composite)this.templateCombo);
                this.setErrorMessage(Messages.Db2TemplateEditorDialog2_16);
                return false;
            }
            if (this.options.getTemplate() != null && value.equalsIgnoreCase(this.options.getTemplate().getFormattedName())) {
                return true;
            }
            this.options.setTemplate(null);
            this.setErrorMessage(null);
            boolean mustExist = !this.templateUsageGenRepButton.getSelection();
            result = TemplateEditorUtilities.okAsTemplate(ZRLs.parseZRL((IPDHost)this.host, (String)value), mustExist, null);
            if (result != null) break block7;
            this.options.setTemplate(ZRLs.parseZRL((IPDHost)this.host, (String)value));
            return true;
        }
        try {
            this.setErrorMessage(result);
            Db2TemplateEditorDialog2.setFocus((Composite)this.templateCombo);
            this.options.setTemplate(null);
            return false;
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(Messages.Db2TemplateEditorDialog2_20);
            Db2TemplateEditorDialog2.setFocus((Composite)this.templateCombo);
            this.options.setTemplate(null);
            return false;
        }
        catch (InterruptedException e) {
            Db2TemplateEditorDialog2.setFocus((Composite)this.templateCombo);
            this.options.setTemplate(null);
            return false;
        }
        catch (IllegalArgumentException e) {
            this.setErrorMessage(Messages.Db2TemplateEditorDialog2_5);
            Db2TemplateEditorDialog2.setFocus((Composite)this.templateCombo);
            this.options.setTemplate(null);
            return false;
        }
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonBar = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)3, (boolean)true), (Object)new GridData(0x1000008, 4, true, false));
        this.createButtonsForButtonBar(buttonBar);
        return buttonBar;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridData data = GUI.grid.d.fillH((int)1);
        data.minimumWidth = 100;
        Button editButton = GUI.button.push((Composite)parent, (String)Messages.EditorOptionDialog_EDIT, (Object)data, (String)Messages.EditorOptionDialog_EDIT_TIP);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Db2TemplateEditorDialog2.this.validateAndClose();
            }
        });
        Button optionButton = GUI.button.push((Composite)parent, (String)Messages.Db2EditorDialog_27, (Object)data, (String)Messages.Db2EditorDialog_28);
        optionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Db2EditorOptions editorOpts;
                Db2SystemOptions sysOpts;
                Db2OptionsDialog dialog;
                if (Db2TemplateEditorDialog2.this.validateSubsystem(true) && (dialog = new Db2OptionsDialog(sysOpts = ((FMHost)FMHost.getSystem((IPDHost)Db2TemplateEditorDialog2.this.host)).getDb2SystemOptions(Db2TemplateEditorDialog2.this.options.getSubsystem().getSubsystemID()), editorOpts = ((FMHost)FMHost.getSystem((IPDHost)Db2TemplateEditorDialog2.this.host)).getDb2EditorOptions(Db2TemplateEditorDialog2.this.options.getSubsystem().getSubsystemID()))).open() != 0) {
                    return;
                }
            }
        });
        Button cancelButton = GUI.button.push((Composite)parent, (String)Messages.EditorOptionDialog_CANCEL, (Object)data);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Db2TemplateEditorDialog2.this.cancelPressed();
            }
        });
        this.getShell().setDefaultButton(editButton);
    }

    private boolean validateAndClose() {
        this.setErrorMessage(null);
        if (!this.validateSubsystem(true)) {
            return false;
        }
        if (!this.validateTableName()) {
            return false;
        }
        if (this.options.getTable() == null) {
            this.setErrorMessage(Messages.Db2TemplateEditorDialog2_22);
            return false;
        }
        if (!this.validateTemplateDataSetName()) {
            return false;
        }
        Result result = new Result();
        if (!ZrlLoaderDialogUtils.tableExists(this.options.getTable(), result, true)) {
            this.setErrorMessage(MessageFormat.format(Messages.Db2ObjectCheckError, this.options.getCreator(), this.options.getName()));
            return false;
        }
        return this.close();
    }

    private static String getComboValue(final Combo combo2) {
        Objects.requireNonNull(combo2, "Please provide a non-null combo.");
        String text2 = (String)PDSafeUIRunner.syncExec((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (!combo2.isDisposed()) {
                    return combo2.getText();
                }
                return "";
            }
        });
        return text2 == null ? "" : text2;
    }

    private static void setFocus(final Composite composite) {
        Objects.requireNonNull(composite, "Please provide a non-null composite.");
        PDSafeUIRunner.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!composite.isDisposed()) {
                    composite.setFocus();
                }
            }
        });
    }

    private static void setText(final Combo combo2, final String text2) {
        Objects.requireNonNull(combo2, "Please provide a non-null combo.");
        Objects.requireNonNull(text2, "Please provide a non-null text.");
        PDSafeUIRunner.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!combo2.isDisposed()) {
                    combo2.setText(text2);
                }
            }
        });
    }

    private boolean validateSubsystem(boolean checkConnectable) {
        String ssid = Db2TemplateEditorDialog2.getComboValue(this.ssidCombo).trim();
        if (!Db2Subsystem.isValidName((IPDHost)this.host, (String)ssid)) {
            this.setErrorMessage(Messages.Db2TemplateEditorDialog2_26);
            Db2TemplateEditorDialog2.setFocus((Composite)this.ssidCombo);
            return false;
        }
        if (checkConnectable && !VersionUtils.isDB2SubsystemConnectable(this.host, ssid)) {
            this.setErrorMessage(MessageFormat.format(Messages.Db2TemplateEditorDialog2_9, ssid));
            return false;
        }
        this.options.setSubsystem(new Db2Subsystem(this.options.getSystem(), ssid));
        return true;
    }

    private boolean validateTableName() {
        String tableCreater = Db2TemplateEditorDialog2.getComboValue(this.ownerCombo).trim();
        if (tableCreater.isEmpty()) {
            try {
                AuthDetails authDetails = this.options.getSystem().getLogin(true);
                tableCreater = authDetails.getUsername();
            }
            catch (InterruptedException e) {
                logger.debug((Object)"User cancelled while retrieving the user name.");
            }
        }
        if (!Db2Table.isValidOwner((IPDHost)this.options.getSystem(), (String)tableCreater)) {
            this.setErrorMessage(Messages.Db2TemplateEditorDialog2_23);
            Db2TemplateEditorDialog2.setText(this.ownerCombo, tableCreater);
            Db2TemplateEditorDialog2.setFocus((Composite)this.ownerCombo);
            return false;
        }
        String tableName = Db2TemplateEditorDialog2.getComboValue(this.nameCombo);
        if (!Db2Table.isValidName((IPDHost)this.options.getSystem(), (String)tableName)) {
            this.setErrorMessage(Messages.Db2TemplateEditorDialog2_24);
            Db2TemplateEditorDialog2.setFocus((Composite)this.nameCombo);
            return false;
        }
        this.options.setTable(new Db2Table(this.options.getSubsystem(), tableName, tableCreater));
        return true;
    }

    public Db2TemplateOptions getOptions() {
        return this.options;
    }
}

